/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.config.StationProfile;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTDataFrame;
import cn.org.gddsn.seis.evtformat.RTDataType;
import cn.org.gddsn.seis.evtformat.RTEndFrame;
import cn.org.gddsn.seis.evtformat.RTLostFrame;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.RTResponse;
import cn.org.gddsn.seis.evtformat.RTStationInfo;
import com.nr.Complex;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public final class RTStreamManager {
    static Logger logger = Logger.getLogger(RTStreamManager.class);
    private boolean bWriteDataFrame = false;
    ObjectOutputStream os;
    ObjectInputStream oin;
    String outPutFileName;

    public RTOneChannelData readTimeSeries(String fname) throws IOException, ClassNotFoundException {
        RTLostFrame rtlost;
        Date arrivalTime;
        RTDataFrame rtData;
        File file = new File(fname);
        if (!file.exists()) {
            return null;
        }
        FilterInputStream in = new BufferedInputStream(new FileInputStream(fname), 8192);
        if (fname.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        this.oin = new ObjectInputStream(in);
        RTOneChannelData oneChannel = new RTOneChannelData();
        RTStationInfo rtSI = (RTStationInfo)this.oin.readObject();
        RTResponse rtRsp = (RTResponse)this.oin.readObject();
        LinkedList<RTDataType> list = new LinkedList<RTDataType>();
        RTDataType rtType = (RTDataType)this.oin.readObject();
        while (rtType.getType() != -1) {
            list.add(rtType);
            rtType = (RTDataType)this.oin.readObject();
        }
        this.oin.close();
        ((InputStream)in).close();
        int samples = 0;
        ListIterator listIt = list.listIterator();
        RTDataType firstObj = (RTDataType)list.getFirst();
        if (firstObj.getType() == 0) {
            rtData = (RTDataFrame)firstObj;
            arrivalTime = rtData.getArrivalTime();
        } else {
            rtlost = (RTLostFrame)firstObj;
            arrivalTime = rtlost.getFirstLostArrival();
        }
        while (listIt.hasNext()) {
            rtType = (RTDataType)listIt.next();
            if (rtType.getType() == 0) {
                rtData = (RTDataFrame)rtType;
                samples += rtData.getSamples();
                continue;
            }
            rtlost = (RTLostFrame)rtType;
            samples += rtlost.getSamples();
        }
        double[] dat = new double[samples];
        listIt = list.listIterator();
        int[] intDat = null;
        int idx = 0;
        while (listIt.hasNext()) {
            int i;
            rtType = (RTDataType)listIt.next();
            if (rtType.getType() == 0) {
                rtData = (RTDataFrame)rtType;
                intDat = rtData.getDataFrame();
                i = 0;
                while (i < intDat.length) {
                    dat[idx++] = intDat[i];
                    ++i;
                }
                continue;
            }
            rtlost = (RTLostFrame)rtType;
            i = 0;
            while (i < rtlost.getSamples()) {
                dat[idx++] = 0.0;
                ++i;
            }
        }
        oneChannel.setData(rtSI, rtRsp, arrivalTime, dat);
        return oneChannel;
    }

    public void openOutputStream(String fname) throws IOException {
        this.bWriteDataFrame = false;
        this.outPutFileName = fname;
        OutputStream out = new FileOutputStream(fname);
        if (fname.endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        this.os = new ObjectOutputStream(out);
    }

    public void openOutputStream(OutputStream os) throws IOException {
        this.os = new ObjectOutputStream(os);
    }

    public void writeHeader(RTStationInfo rtSI, RTResponse rtRsp) throws IOException {
        if (this.bWriteDataFrame) {
            throw new RuntimeException("you must first write head before write frame data");
        }
        this.os.writeObject(rtSI);
        this.os.writeObject(rtRsp);
        this.os.flush();
        this.bWriteDataFrame = true;
    }

    public void writeRTDataType(RTDataType rtData) throws IOException {
        if (this.os == null) {
            return;
        }
        if (!this.bWriteDataFrame) {
            throw new RuntimeException("you must first write head before write frame data");
        }
        this.os.writeObject(rtData);
        this.os.reset();
        this.os.flush();
    }

    public void closeOutputStream() throws IOException {
        if (this.bWriteDataFrame) {
            this.os.writeObject(new RTEndFrame());
        }
        this.os.close();
        this.os = null;
        this.bWriteDataFrame = false;
    }

    public void writeOneChannelData(String fname, RTStationInfo rtSI, RTResponse rtRsp, RTDataType[] rtData) throws IOException {
        this.openOutputStream(fname);
        this.writeHeader(rtSI, rtRsp);
        int i = 0;
        while (i < rtData.length) {
            this.writeRTDataType(rtData[i]);
            ++i;
        }
        this.closeOutputStream();
    }

    public RTOneChannelData readTimeSeries(StationProfile profile, ChannelLocator cl, String fname) throws IOException {
        File file = new File(fname);
        if (!file.exists()) {
            return null;
        }
        RTOneChannelData oneChannel = new RTOneChannelData();
        RTStationInfo rtSI = new RTStationInfo();
        RTResponse rtRsp = new RTResponse();
        StationProfile.Station stn = profile.getStation(cl.getStationCode());
        StationProfile.Channel chn = profile.getChannel(cl.getStationCode(), cl.getLocID(), cl.getChanCode());
        rtSI.setAuxId(chn.getLocID());
        rtSI.setChannelCode(chn.getCha());
        rtSI.setChannelComp(profile.getAllChannel(cl.getStationCode(), cl.getLocID()).length);
        rtSI.setCoordSys(stn.getCoordsys());
        rtSI.setHAng(chn.getHang());
        rtSI.setInstrumentType(stn.getMtype());
        rtSI.setNetworkCode(stn.getNet());
        rtSI.setSampleRate(chn.getSampleRate());
        rtSI.setStationCode(cl.getStationCode());
        rtSI.setStationType(stn.getStaType());
        rtSI.setVAng(chn.getVang());
        rtSI.setStationLocation(new Location(stn.getLat(), stn.getLon()));
        rtRsp.setCalibFactor(chn.getTranFun().getSensitivity());
        rtRsp.setCalper(chn.getTranFun().getCalper());
        rtRsp.setScaleFactor(chn.getTranFun().getSfactor());
        int zeroNum = chn.getTranFun().getNzero();
        int poleNum = chn.getTranFun().getNpole();
        Complex[] zero = new Complex[zeroNum];
        Complex[] pole = new Complex[poleNum];
        StringTokenizer strt = new StringTokenizer(chn.getTranFun().getZero(), " \t\r\n");
        int k = 0;
        while (k < zeroNum) {
            zero[k] = new Complex(Double.parseDouble(strt.nextToken()), Double.parseDouble(strt.nextToken()));
            ++k;
        }
        strt = new StringTokenizer(chn.getTranFun().getPole(), " \t\r\n");
        k = 0;
        while (k < poleNum) {
            pole[k] = new Complex(Double.parseDouble(strt.nextToken()), Double.parseDouble(strt.nextToken()));
            ++k;
        }
        rtRsp.setZero(zero);
        rtRsp.setPole(pole);
        if (chn.getTranFun().getIunits().equals("um/s")) {
            rtRsp.setOriginalType(1);
        } else if (chn.getTranFun().getIunits().equals("um")) {
            rtRsp.setOriginalType(0);
        } else {
            rtRsp.setOriginalType(2);
        }
        byte[] buf = new byte[512];
        int[] intDat = null;
        File dataFile = new File(fname);
        int nBlock = (int)(dataFile.length() / 512L);
        if (nBlock < 2) {
            logger.warn((Object)(dataFile + ": length is too short, ignore."));
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(dataFile, "r");
        raf.seek((nBlock - 1) * 512);
        raf.read(buf);
        raf.close();
        GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord((byte[])buf);
        double srate = gmsr.getSampleRate();
        if (!gmsr.decompress()) {
            logger.warn((Object)(dataFile + ": contain bad mini seed block, ignore this file."));
            return null;
        }
        long finMs = gmsr.getStartTime().toDate().getTime() + (long)((int)((double)(gmsr.getNumSamples() * 1000) / srate));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(dataFile), 8192);
        ((InputStream)in).read(buf);
        gmsr = GenericMiniSeedRecord.buildMiniSeedRecord((byte[])buf);
        if (!gmsr.decompress()) {
            logger.warn((Object)(dataFile + ": contain bad mini seed block, ignore this file."));
            return null;
        }
        Date arrivalTime = gmsr.getStartTime().toDate();
        int nTotal = (int)((double)(finMs - arrivalTime.getTime()) * srate / 1000.0);
        double[] dat = new double[nTotal];
        intDat = gmsr.getUData();
        int i = 0;
        while (i < gmsr.getNumSamples()) {
            dat[i] = intDat[i];
            ++i;
        }
        int cnt = intDat.length;
        int i2 = 1;
        while (i2 < nBlock) {
            block24: {
                block23: {
                    int ngaps;
                    block22: {
                        long ms = arrivalTime.getTime() + (long)((int)((double)(cnt * 1000) / srate));
                        ((InputStream)in).read(buf);
                        gmsr = GenericMiniSeedRecord.buildMiniSeedRecord((byte[])buf);
                        ngaps = (int)((double)(gmsr.getStartTime().toDate().getTime() - ms) * srate / 1000.0);
                        if (ngaps <= 0) break block22;
                        if ((cnt += ngaps) > dat.length) {
                            logger.warn((Object)(dataFile + ": contain big gaps ignore blocks after gaps."));
                            break;
                        }
                        break block23;
                    }
                    if (ngaps < 0) break block24;
                }
                int nsamples = gmsr.getNumSamples();
                if (!gmsr.decompress()) {
                    logger.warn((Object)(dataFile + ": contain bad mini seed block, ignore this block"));
                } else {
                    intDat = gmsr.getUData();
                    if (cnt + nsamples > dat.length) {
                        logger.warn((Object)(dataFile + ": contain seed block more than expected, ignore blocks not read."));
                    } else {
                        int j = 0;
                        while (j < nsamples) {
                            dat[cnt++] = intDat[j];
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
        ((InputStream)in).close();
        oneChannel.setData(rtSI, rtRsp, arrivalTime, dat);
        return oneChannel;
    }
}

