/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class MysqlTestCase {
    static Logger logger = Logger.getLogger(MysqlTestCase.class);
    private Connection wfdbConn = null;
    private Date beg = null;
    private Date end = null;

    public MysqlTestCase(Connection wfdbConn) {
        this.wfdbConn = wfdbConn;
    }

    public void setTimeSpan(Date beg, Date end) {
        this.beg = beg;
        this.end = end;
    }

    public boolean readEvtFile() {
        logger.info((Object)"DECODE MiniSeed ...");
        long now_ms = new Date().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+08"));
        Statement stmt = null;
        ResultSet rs = null;
        byte[] buf = null;
        try {
            stmt = this.wfdbConn.createStatement();
            String start_time = sdf.format(this.beg);
            String end_time = sdf.format(this.end);
            String sqlStr = "select * from waveform where start_time >= '" + start_time + "' AND start_time <= '" + end_time + "' order by net, sta, loc_id, chan, start_time, start_time_ns";
            rs = stmt.executeQuery(sqlStr);
            while (rs.next()) {
                Blob waveform = rs.getBlob("waveform");
                int len = (int)waveform.length();
                buf = waveform.getBytes(1L, len);
                buf = new byte[16];
                buf[13] = 53;
                buf[14] = 48;
            }
            long n_now_ms = new Date().getTime();
            logger.info((Object)("DECODE MiniSeed elapse time: " + (n_now_ms - now_ms) + " ms."));
            rs.close();
            stmt.close();
        }
        catch (SQLException sqlEx) {
            logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            return false;
        }
        return true;
    }

    public String getLocID(byte[] buf) {
        String ret = "";
        try {
            ret = new String(buf, 13, 2).trim();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        Connection conn = DriverManager.getConnection("jdbc:mysql://192.168.168.135/rts?useUnicode=true&characterEncoding=eucCN&user=rts&password=rts");
        MysqlTestCase ded = null;
        ded = new MysqlTestCase(conn);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = "2003-04-21 11:00:00";
        String endTime = "2003-04-21 12:0:00";
        Date beg = sdf.parse(startTime);
        Date end = sdf.parse(endTime);
        ded.setTimeSpan(beg, end);
        if (ded.readEvtFile()) {
            logger.info((Object)"Open DB Event OK!");
        }
        conn.close();
    }
}

