/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double lat;
    protected double lon;
    protected double alt;
    private double delta;
    private double azimuth;
    private double maxResi;

    public Location() {
    }

    public Location(double latitude, double longtitude) {
        this.lat = latitude;
        this.lon = longtitude;
    }

    public Location(double latitude, double longtitude, double alt) {
        this.lat = latitude;
        this.lon = longtitude;
        this.alt = alt;
    }

    public double getAltitude() {
        return this.alt;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLatitudeRadians() {
        return this.lat * Math.PI / 180.0;
    }

    public double getLongtitude() {
        return this.lon;
    }

    public double getLongtitudeRadians() {
        return this.lon * Math.PI / 180.0;
    }

    public String toString() {
        return "Lat " + this.lat + ", lon " + this.lon;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.lat);
        out.writeDouble(this.lon);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lat = in.readDouble();
        this.lon = in.readDouble();
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public double getMaxResi() {
        return this.maxResi;
    }

    public void setMaxResi(double resi) {
        this.maxResi = resi;
    }
}

