/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import JSci.maths.ArrayMath;
import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.MultiTimeSeries;
import cn.org.gddsn.seis.evtformat.RTEvtData;
import cn.org.gddsn.seis.evtformat.RTMiniSeedData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.UnsupportedEventFormat;
import cn.org.gddsn.seis.evtformat.WaveFormType;
import cn.org.gddsn.seis.evtformat.edas.EdasZipEvent;
import cn.org.gddsn.seis.evtformat.edas.GeoDevEvent;
import cn.org.gddsn.seis.evtformat.edas.GeoDevOldEvent;
import cn.org.gddsn.seis.evtformat.edas.JZipEvent;
import cn.org.gddsn.seis.evtformat.edas.JZipEvtHead;
import cn.org.gddsn.seis.evtformat.reftek.RefEvent;
import cn.org.gddsn.seis.evtformat.sac.SacEvent;
import cn.org.gddsn.seis.evtformat.seed.SeedVolume;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumeNativePlugin;
import cn.org.gddsn.seis.evtformat.win32.Win32Event;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.LocationMath;
import cn.org.gddsn.seis.location.NetCDFTable;
import cn.org.gddsn.seis.location.PeriodBound;
import cn.org.gddsn.seis.location.TauPToolkit;
import cn.org.gddsn.seis.picker.AICPicker;
import cn.org.gddsn.seis.picker.ARAICPicker;
import cn.org.gddsn.seis.picker.FilterPicker5;
import cn.org.gddsn.seis.picker.PickData;
import cn.org.gddsn.seis.picker.STALTA;
import cn.org.gddsn.seis.ttt3d.TTTChuanDian;
import cn.org.gddsn.seis.ttt3d.TTTDing;
import cn.org.gddsn.signal.ButterFilter;
import cn.org.gddsn.signal.FFTFilter;
import cn.org.gddsn.signal.Filter;
import cn.org.gddsn.signal.Numeric;
import com.nr.Complex;
import edu.iris.miniseedutils.steim.MiniSeedRecordDouble;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvtData
implements Serializable,
WaveFormType,
MultiTimeSeries {
    static final long serialVersionUID = -1364303022956719099L;
    static Logger logger = Logger.getLogger(EvtData.class);
    protected int evtFormat;
    protected double clat;
    protected double clon;
    protected double calt;
    protected int TCN;
    protected int TSN;
    protected int maxTRL = -1;
    protected boolean cleanNodataChannel = true;
    protected List<TimeSeries> list = new LinkedList<TimeSeries>();
    private Hashtable<ChannelLocator, Integer> tblOrder = new Hashtable(1024);
    private Hashtable<ChannelLocator, TimeSeries> tbl = new Hashtable();
    protected Vector<ChannelLocator> noDataChannel = new Vector();
    public static final int SORT_DELTA = 0;
    public static final int SORT_P_ARRIVAL = 1;
    public static final int SORT_STATION_NAME = 2;
    public static final int SORT_STATION_NUM = 3;
    public static final int SORT_AZIMUTH = 4;
    public static final int SORT_RES = 5;
    public static final int SORT_LAT_LON = 6;
    public static final int SORT_LON_LAT = 7;
    public static final int ALIGN_P = 8;
    public static final int ALIGN_S = 9;
    public static int WaveFormSortType = -1;
    public static SourceParam source = null;
    public static EvtData thisEvtData = null;
    private ComputedTravelTime ctt = null;

    public EvtData() {
    }

    public EvtData(EvtData oevt) {
        this.evtFormat = oevt.evtFormat;
        this.clat = oevt.clat;
        this.clon = oevt.clon;
        this.calt = oevt.calt;
        this.TCN = oevt.TCN;
        this.TSN = oevt.TSN;
        this.maxTRL = oevt.maxTRL;
        this.cleanNodataChannel = oevt.cleanNodataChannel;
        this.list.addAll(oevt.list);
        this.tblOrder.putAll(oevt.tblOrder);
        this.tbl.putAll(oevt.tbl);
        this.noDataChannel.addAll(oevt.noDataChannel);
    }

    public abstract boolean readEvtFile(String var1);

    public abstract boolean writeEvtFile(String var1);

    public void sort() {
        Collections.sort(this.list);
        this.tblOrder.clear();
        int i = 0;
        while (i < this.TCN) {
            this.tblOrder.put(this.list.get(i).getChannelLocator(), i);
            ++i;
        }
    }

    public void checkGain(int chan) {
        double freq;
        Complex[] zero = this.getZero(chan);
        Complex[] pole = this.getPole(chan);
        if (zero == null || pole == null) {
            logger.warn((Object)("No pole & zero for " + this.getChannelLocator(chan)));
            return;
        }
        double A0 = this.getScaleFactor(chan);
        double norm = FFTFilter.normalf(zero, pole, A0, freq = this.getCalper(chan));
        if (norm < 0.95 || norm > 1.05) {
            logger.warn((Object)String.format("%s norm factor is %.5f, please check Pole and Zero", this.getChannelLocator(chan), norm));
            norm = 1.0;
        }
    }

    public static final EvtData readEvtData(String fileName) {
        EvtData evtData = null;
        boolean success = true;
        int format = EvtData.getEvtFormat(fileName);
        switch (format) {
            case 7: {
                SeedVolume seed = new SeedVolume(true);
                int ncpu = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
                ncpu = 1;
                seed.setThreadNums(ncpu);
                SeedVolumeNativePlugin plugin = new SeedVolumeNativePlugin();
                plugin.setFile(new File(fileName));
                seed.setSeedVolumePlugin(plugin);
                evtData = seed;
                success = evtData.readEvtFile(fileName);
                if (!success) break;
                int i = 0;
                while (i < evtData.getTCN()) {
                    evtData.checkGain(i);
                    ++i;
                }
                break;
            }
            case 0: {
                evtData = new GeoDevEvent();
                success = evtData.readEvtFile(fileName);
                if (!success) break;
                int i = 0;
                while (i < evtData.getTCN()) {
                    evtData.checkGain(i);
                    ++i;
                }
                break;
            }
            case 1: {
                evtData = new GeoDevOldEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 9: {
                evtData = new EdasZipEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 2: {
                evtData = new JZipEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 3: {
                evtData = new SacEvent();
                success = evtData.readEvtFile(fileName);
                if (!success) break;
                int i = 0;
                while (i < evtData.getTCN()) {
                    evtData.checkGain(i);
                    ++i;
                }
                break;
            }
            case 5: {
                evtData = new RTEvtData();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 6: {
                evtData = new RTMiniSeedData();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 10: {
                evtData = new RefEvent();
                success = evtData.readEvtFile(fileName);
                if (!success) break;
                int i = 0;
                while (i < evtData.getTCN()) {
                    evtData.checkGain(i);
                    ++i;
                }
                break;
            }
            case 11: {
                evtData = new Win32Event();
                success = evtData.readEvtFile(fileName);
                if (!success) break;
                int i = 0;
                while (i < evtData.getTCN()) {
                    evtData.checkGain(i);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedEventFormat("Unknown Data Format: " + new File(fileName).getPath());
            }
        }
        if (!success) {
            evtData = null;
        }
        return evtData;
    }

    public static int getEvtFormat(String FileName) {
        int ret;
        block23: {
            ret = -1;
            if (!new File(FileName).isDirectory()) break block23;
            File[] file = new File(FileName).listFiles();
            if (file[0].isFile()) {
                return 3;
            }
            return 10;
        }
        try {
            FileInputStream FileIn = new FileInputStream(FileName);
            DataInputStream DatIn = new DataInputStream(FileIn);
            byte[] evtFlag = new byte[16];
            DatIn.readFully(evtFlag, 0, 16);
            DatIn.close();
            FileIn.close();
            CStringToJava.tailToZero((byte[])evtFlag, (int)16);
            String gettingID = new String(evtFlag);
            String newID = "digital event";
            String oldID1 = "PROCESSED";
            String oldID2 = "EVT-PC";
            String edasZip = "SEISMIC EVENT";
            File file = new File(FileName);
            ByteBuffer bb = ByteBuffer.wrap(evtFlag, 0, 4);
            int temp = bb.getInt();
            if (gettingID.startsWith(newID)) {
                ret = 0;
            } else if (EvtData.isSeedVolume(FileName)) {
                ret = 7;
            } else if (gettingID.startsWith(oldID1) || gettingID.startsWith(oldID2)) {
                ret = 1;
            } else if (gettingID.startsWith(edasZip)) {
                ret = 9;
            } else if (file.isDirectory()) {
                ret = 3;
            } else if (EvtData.isJZipEvt(FileName)) {
                ret = 2;
            } else if (EvtData.isRTEvtData(FileName)) {
                ret = 5;
            } else if (EvtData.isRTMiniSeedData(FileName)) {
                ret = 6;
            } else if (new String(evtFlag, 0, 2).equals("EH")) {
                ret = 10;
            } else if (temp == 0) {
                ret = 11;
            }
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    static boolean isJZipEvt(String openedFileFullName) {
        boolean ret = false;
        try {
            ZipFile zf = new ZipFile(openedFileFullName);
            ZipEntry head = zf.getEntry("head");
            ObjectInputStream ois = new ObjectInputStream(zf.getInputStream(head));
            JZipEvtHead evtHead = (JZipEvtHead)ois.readObject();
            String ID = null;
            ID = evtHead.EvtFlag;
            ois.close();
            zf.close();
            if (ID.startsWith("JZipEvt")) {
                ret = true;
            }
        }
        catch (Exception Ex) {
            ret = false;
        }
        return ret;
    }

    static boolean isRTEvtData(String openedFileFullName) {
        boolean ret = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(openedFileFullName));
            String lineStr = reader.readLine();
            StringTokenizer st = new StringTokenizer(lineStr);
            if (st.nextToken().equals("FORMAT_RTStreamData")) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            ret = false;
        }
        return ret;
    }

    static boolean isRTMiniSeedData(String openedFileFullName) {
        boolean ret = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(openedFileFullName));
            String lineStr = reader.readLine();
            StringTokenizer st = new StringTokenizer(lineStr);
            if (st.nextToken().equals("FORMAT_RTMiniSeedData")) {
                ret = true;
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            ret = false;
        }
        return ret;
    }

    static boolean isSeedVolume(String openedFileFullName) {
        boolean ret = false;
        try {
            FileReader reader = new FileReader(openedFileFullName);
            char[] lineStr = new char[8];
            reader.read(lineStr);
            if ("000001V ".equals(new String(lineStr))) {
                ret = true;
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            ret = false;
        }
        return ret;
    }

    public int getTCN() {
        return this.TCN;
    }

    public int getTSN() {
        return this.TSN;
    }

    public int getMaxTRL() {
        return this.maxTRL;
    }

    public String[] getAllNetStation() {
        Vector<String> stnCodes = new Vector<String>();
        int chan = 0;
        while (chan < this.TCN) {
            String code = String.valueOf(this.getNetworkCode(chan)) + "/" + this.getStationCode(chan);
            if (!stnCodes.contains(code)) {
                stnCodes.add(code);
            }
            ++chan;
        }
        Object[] objs = stnCodes.toArray();
        String[] rets = new String[objs.length];
        int i = 0;
        while (i < objs.length) {
            rets[i] = (String)objs[i];
            ++i;
        }
        return rets;
    }

    public double getClat() {
        return this.clat;
    }

    public double getClon() {
        return this.clon;
    }

    public double getCalt() {
        return this.calt;
    }

    public int getEvtFormat() {
        return this.evtFormat;
    }

    public double getTRL(int chanOrder) {
        return (double)this.getSamples(chanOrder) / this.getSampleRate(chanOrder);
    }

    public synchronized void setEvtData(EvtData evtData) {
        this.clat = evtData.clat;
        this.clon = evtData.clon;
        this.calt = evtData.calt;
        this.TCN = evtData.TCN;
        this.TSN = evtData.TSN;
        this.maxTRL = evtData.maxTRL;
        this.list = evtData.list;
    }

    public synchronized void addTimeSeries(TimeSeries[] timeSeries) {
        int i = 0;
        while (i < timeSeries.length) {
            this.list.add(timeSeries[i]);
            ++i;
        }
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < timeSeries.length) {
            this.tbl.put(this.getChannelLocator(i), timeSeries[i]);
            ++i;
        }
        this.tblOrder.clear();
        i = 0;
        while (i < this.TCN) {
            this.tblOrder.put(this.list.get(i).getChannelLocator(), i);
            ++i;
        }
    }

    public synchronized void removeTimeSeries(ChannelLocator cl) {
        int i = 0;
        while (i < this.TCN) {
            if (this.getChannelLocator(i).equals((Object)cl)) {
                this.list.remove(i);
                break;
            }
            ++i;
        }
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < this.list.size()) {
            this.tbl.put(this.getChannelLocator(i), this.list.get(i));
            ++i;
        }
        this.tblOrder.clear();
        i = 0;
        while (i < this.TCN) {
            this.tblOrder.put(this.list.get(i).getChannelLocator(), i);
            ++i;
        }
    }

    public synchronized void setTimeSeries(TimeSeries[] timeSeries) {
        this.list = new LinkedList<TimeSeries>();
        int i = 0;
        while (i < timeSeries.length) {
            this.list.add(timeSeries[i]);
            ++i;
        }
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < timeSeries.length) {
            this.tbl.put(this.getChannelLocator(i), timeSeries[i]);
            ++i;
        }
        this.tblOrder.clear();
        i = 0;
        while (i < this.TCN) {
            this.tblOrder.put(this.list.get(i).getChannelLocator(), i);
            ++i;
        }
    }

    public synchronized void setTimeSeries(List<TimeSeries> aList) {
        int i = 0;
        while (i < aList.size()) {
            if (!(aList.get(i) instanceof TimeSeries)) {
                throw new IllegalArgumentException("List contain an element is not TimeSeries");
            }
            ++i;
        }
        this.list = aList;
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < aList.size()) {
            this.tbl.put(this.getChannelLocator(i), aList.get(i));
            ++i;
        }
        this.tblOrder.clear();
        i = 0;
        while (i < this.TCN) {
            this.tblOrder.put(this.list.get(i).getChannelLocator(), i);
            ++i;
        }
    }

    public synchronized void setTimeSeries() {
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        this.maxTRL = -1;
        try {
            int i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        int i = 0;
        while (i < this.list.size()) {
            this.tbl.put(this.getChannelLocator(i), this.list.get(i));
            ++i;
        }
        this.tblOrder.clear();
        i = 0;
        while (i < this.TCN) {
            this.tblOrder.put(this.list.get(i).getChannelLocator(), i);
            ++i;
        }
        logger.info((Object)("Total Station / Total Channel : " + this.TSN + " / " + this.TCN));
    }

    public synchronized int[] getChanOrder(int chanOrder) {
        return this.getChanOrder(this.getNetworkCode(chanOrder), this.getStationCode(chanOrder));
    }

    public synchronized int[] getChanOrder(String network, String stationCode, String locId, String chan2) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getNetworkCode().equals(network) && chanData.getStationCode().equals(stationCode) && chanData.getAuxId().equals(locId) && chanData.getChannelCode().substring(0, 2).equals(chan2)) {
                aList.add(i);
            }
            ++i;
        }
        if (aList.size() == 0) {
            return null;
        }
        Collections.sort(aList);
        Object[] integer = aList.toArray();
        int[] cOrder = new int[integer.length];
        int i2 = 0;
        while (i2 < cOrder.length) {
            cOrder[i2] = (Integer)integer[i2];
            ++i2;
        }
        return cOrder;
    }

    public synchronized int[] getChanOrder(String networkId, String stationCode) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getNetworkCode().equals(networkId) && chanData.getStationCode().equals(stationCode)) {
                aList.add(i);
            }
            ++i;
        }
        if (aList.size() == 0) {
            return null;
        }
        Object[] integer = aList.toArray();
        int[] cOrder = new int[integer.length];
        int i2 = 0;
        while (i2 < cOrder.length) {
            cOrder[i2] = (Integer)integer[i2];
            ++i2;
        }
        Arrays.sort(cOrder);
        return cOrder;
    }

    public synchronized int getChanOrder(String networkId, String stationCode, String channelCode) {
        int retVal = -1;
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getNetworkCode().equals(networkId) && chanData.getStationCode().equals(stationCode) && chanData.getChannelCode().equals(channelCode)) {
                retVal = i;
                break;
            }
            ++i;
        }
        if (retVal == -1) {
            // empty if block
        }
        return retVal;
    }

    public int getChanOrder(String scl) {
        ChannelLocator cl = ChannelLocator.parse((String)scl, (String)"/");
        return this.getChanOrder(cl);
    }

    public synchronized int getChanOrder(ChannelLocator cl) {
        Integer odr = this.tblOrder.get(cl);
        if (odr != null) {
            return odr;
        }
        return -1;
    }

    public synchronized boolean isThreeComp(int chanOrder) {
        this.checkChannelOrder(chanOrder);
        int[] chans = this.getChanOrder(chanOrder);
        return chans != null && chans.length >= 3;
    }

    public synchronized boolean isThreeComp(String networkCode, String stationCode, String auxId, String channelCode) {
        return this.isThreeComp(this.chanOrder(networkCode, stationCode, auxId, channelCode));
    }

    public synchronized TimeSeries getTimeSeries(int chanOrder) {
        this.checkChannelOrder(chanOrder);
        return this.list.get(chanOrder);
    }

    public synchronized TimeSeries getTimeSeries(ChannelLocator cl) {
        return this.tbl.get(cl);
    }

    public double[] getSampData(int chanOrder, Date date, int samples) {
        return this.getSampData(chanOrder);
    }

    public int toComp(int chanOrder) {
        int ret = -1;
        if (this.getChannelCode(chanOrder).endsWith("Z")) {
            ret = 1;
        } else if (this.getChannelCode(chanOrder).endsWith("E")) {
            ret = 2;
        } else if (this.getChannelCode(chanOrder).endsWith("N")) {
            ret = 3;
        }
        return ret;
    }

    public void clipEvtData(int begCutTime, int cutLength) {
    }

    private void checkChannelOrder(int chanOrder) {
        if (chanOrder >= this.TCN || chanOrder < 0) {
            throw new IllegalArgumentException("channal order exceed: " + chanOrder);
        }
    }

    private int chanOrder(String networkCode, String stationCode, String auxId, String channelCode) {
        ListIterator<TimeSeries> itr = this.list.listIterator();
        while (itr.hasNext()) {
            TimeSeries chanData = itr.next();
            if (!chanData.getNetworkCode().equals(networkCode) || !chanData.getStationCode().equals(stationCode) || !chanData.getAuxId().equals(auxId) || !chanData.getChannelCode().equals(channelCode)) continue;
            return itr.previousIndex();
        }
        return -1;
    }

    @Override
    public Date getArrivalTime(int chanOrder) {
        return this.getTimeSeries(chanOrder).getArrivalTime();
    }

    @Override
    public double[] getSampData(int chanOrder) {
        return this.getTimeSeries(chanOrder).getSampData();
    }

    @Override
    public int getSamples(int chanOrder) {
        return this.getTimeSeries(chanOrder).getSamples();
    }

    @Override
    public void setArrivalTime(int chanOrder, Date newArrivalTime) {
        this.getTimeSeries(chanOrder).setArrivalTime(newArrivalTime);
    }

    @Override
    public void setSampData(int chanOrder, double[] newSampData) {
        this.getTimeSeries(chanOrder).setSampData(newSampData);
    }

    @Override
    public String getNetworkCode(int chanOrder) {
        return this.getTimeSeries(chanOrder).getNetworkCode();
    }

    @Override
    public String getStationCode(int chanOrder) {
        return this.getTimeSeries(chanOrder).getStationCode();
    }

    @Override
    public String getAuxId(int chanOrder) {
        return this.getTimeSeries(chanOrder).getAuxId();
    }

    @Override
    public ChannelLocator getChannelLocator(int chanOrder) {
        return this.getTimeSeries(chanOrder).getChannelLocator();
    }

    @Override
    public String getStationType(int chanOrder) {
        return this.getTimeSeries(chanOrder).getStationType();
    }

    @Override
    public int getChannelComp(int chanOrder) {
        return this.getTimeSeries(chanOrder).getChannelComp();
    }

    @Override
    public String getChannelCode(int chanOrder) {
        return this.getTimeSeries(chanOrder).getChannelCode();
    }

    @Override
    public Location getStationLocation(int chanOrder) {
        return this.getTimeSeries(chanOrder).getStationLocation();
    }

    @Override
    public String getCoordSys(int chanOrder) {
        return this.getTimeSeries(chanOrder).getCoordSys();
    }

    @Override
    public String getInstrumentType(int chanOrder) {
        return this.getTimeSeries(chanOrder).getInstrumentType();
    }

    @Override
    public double getHAng(int chanOrder) {
        return this.getTimeSeries(chanOrder).getHAng();
    }

    @Override
    public double getVAng(int chanOrder) {
        return this.getTimeSeries(chanOrder).getVAng();
    }

    @Override
    public double getSampleRate(int chanOrder) {
        return this.getTimeSeries(chanOrder).getSampleRate();
    }

    @Override
    public void setNetworkCode(int chanOrder, String newNetworkCode) {
        this.getTimeSeries(chanOrder).setNetworkCode(newNetworkCode);
    }

    @Override
    public void setStationCode(int chanOrder, String newStationCode) {
        this.getTimeSeries(chanOrder).setStationCode(newStationCode);
    }

    @Override
    public void setStationType(int chanOrder, String newStationType) {
        this.getTimeSeries(chanOrder).setStationType(newStationType);
    }

    @Override
    public void setAuxId(int chanOrder, String newAuxId) {
        this.getTimeSeries(chanOrder).setAuxId(newAuxId);
    }

    @Override
    public void setChannelComp(int chanOrder, int newChannelComp) {
        this.getTimeSeries(chanOrder).setChannelComp(newChannelComp);
    }

    @Override
    public void setChannelCode(int chanOrder, String newChannelCode) {
        this.getTimeSeries(chanOrder).setChannelCode(newChannelCode);
    }

    @Override
    public void setInstrumentType(int chanOrder, String newInstrumentType) {
        this.getTimeSeries(chanOrder).setInstrumentType(newInstrumentType);
    }

    @Override
    public void setStationLocation(int chanOrder, Location newStationlocation) {
        this.getTimeSeries(chanOrder).setStationLocation(newStationlocation);
    }

    @Override
    public void setCoordSys(int chanOrder, String newCoordSys) {
        this.getTimeSeries(chanOrder).setCoordSys(newCoordSys);
    }

    @Override
    public void setHAng(int chanOrder, double newHAng) {
        this.getTimeSeries(chanOrder).setHAng(newHAng);
    }

    @Override
    public void setVAng(int chanOrder, double newVAng) {
        this.getTimeSeries(chanOrder).setVAng(newVAng);
    }

    @Override
    public void setSampleRate(int chanOrder, double newSampleRate) {
        this.getTimeSeries(chanOrder).setSampleRate(newSampleRate);
    }

    @Override
    public double getCalibFactor(int chanOrder) {
        return this.getTimeSeries(chanOrder).getCalibFactor();
    }

    @Override
    public double getCalper(int chanOrder) {
        return this.getTimeSeries(chanOrder).getCalper();
    }

    @Override
    public double getScaleFactor(int chanOrder) {
        return this.getTimeSeries(chanOrder).getScaleFactor();
    }

    @Override
    public Complex[] getZero(int chanOrder) {
        return this.getTimeSeries(chanOrder).getZero();
    }

    @Override
    public Complex[] getPole(int chanOrder) {
        return this.getTimeSeries(chanOrder).getPole();
    }

    @Override
    public int getZeroNum(int chanOrder) {
        return this.getTimeSeries(chanOrder).getZeroNum();
    }

    @Override
    public int getPoleNum(int chanOrder) {
        return this.getTimeSeries(chanOrder).getPoleNum();
    }

    @Override
    public void setCalibFactor(int chanOrder, double newCalibFactor) {
        this.getTimeSeries(chanOrder).setCalibFactor(newCalibFactor);
    }

    @Override
    public void setCalper(int chanOrder, double newCalper) {
        this.getTimeSeries(chanOrder).setCalper(newCalper);
    }

    @Override
    public void setScaleFactor(int chanOrder, double newScaleFactor) {
        this.getTimeSeries(chanOrder).setScaleFactor(newScaleFactor);
    }

    @Override
    public void setZero(int chanOrder, Complex[] newZero) {
        this.getTimeSeries(chanOrder).setZero(newZero);
    }

    @Override
    public void setPole(int chanOrder, Complex[] newPole) {
        this.getTimeSeries(chanOrder).setPole(newPole);
    }

    @Override
    public void setOriginalType(int chanOrder, int newOriginalType) {
        this.getTimeSeries(chanOrder).setOriginalType(newOriginalType);
    }

    @Override
    public int getOriginalType(int chanOrder) {
        return this.getTimeSeries(chanOrder).getOriginalType();
    }

    public Vector<Phase> getTheoreticPhases(int chanOrder) {
        return this.getTimeSeries(chanOrder).getTheoreticPhases();
    }

    public void setTheoreticPhases(int chanOrder, Vector<Phase> theoreticPhase) {
        this.getTimeSeries(chanOrder).setTheoreticPhases(theoreticPhase);
    }

    public Vector<Phase> getAutoPhases(int chanOrder) {
        return this.getTimeSeries(chanOrder).getAutoPhases();
    }

    public void setAutoPhases(int chanOrder, Vector<Phase> autoPhases) {
        this.getTimeSeries(chanOrder).setAutoPhases(autoPhases);
    }

    public Vector<Phase> getPhases(int chanOrder) {
        return this.getTimeSeries(chanOrder).getPhases();
    }

    public void setPhases(int chanOrder, Vector<Phase> thePhases) {
        this.getTimeSeries(chanOrder).setPhases(thePhases);
    }

    public boolean hasPhase(int chanOrder) {
        return !this.getTimeSeries(chanOrder).getPhases().isEmpty();
    }

    public boolean hasPhase(String networkId, String stationCode) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        boolean has = false;
        int i = 0;
        while (i < chn.length) {
            boolean bl = has = !this.getTimeSeries(chn[i]).getPhases().isEmpty();
            if (has) {
                return has;
            }
            ++i;
        }
        return has;
    }

    public boolean hasPhase(String networkId, String stationCode, String phaseName) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        int i = 0;
        while (i < chn.length) {
            Vector<Phase> vec = this.getTimeSeries(chn[i]).getPhases();
            for (Phase p : vec) {
                if (!p.getPhaseName().equals(phaseName)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public Phase getPhase(String networkId, String stationCode, String phaseName) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        int i = 0;
        while (i < chn.length) {
            Vector<Phase> vec = this.getTimeSeries(chn[i]).getPhases();
            for (Phase p : vec) {
                if (!p.getPhaseName().equals(phaseName)) continue;
                return p;
            }
            ++i;
        }
        return null;
    }

    public int getMaxPPCountWithPeriod(int chn, int start, int end, double mean, PeriodBound pb) {
        int maxIdx = start;
        double maxAmp = -1.0;
        int maxPer = 0;
        double[] WDat = this.getSampData(chn);
        double sr = this.getSampleRate(chn);
        if (end > WDat.length) {
            end = WDat.length;
        }
        int i = start;
        while (i < end) {
            double[] par = LocationMath.measurePeriod(WDat, i, start, end, sr, mean);
            int per = (int)(sr * par[0]);
            double amp = this.getMaxPPCount(chn, i - per / 2, i + per / 2) / 2.0;
            if (pb.accept(par) && maxAmp < amp) {
                maxIdx = i;
                maxAmp = amp;
                maxPer = per;
            }
            i += per / 2;
            ++i;
        }
        return this.getMaxCountIndex(chn, maxIdx - maxPer / 2, maxIdx + maxPer / 2, mean);
    }

    public int getMaxCountIndex(int chn, int start, int end, double mean) {
        double[] WDat = this.getSampData(chn);
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length - 1;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        double max = Math.abs(WDat[start] - mean);
        int imax = start;
        int i = start + 1;
        while (i < end) {
            if (max < Math.abs(WDat[i] - mean)) {
                max = Math.abs(WDat[i] - mean);
                imax = i;
            }
            ++i;
        }
        return imax;
    }

    public double getMaxPPCount(int chn, int start, int end) {
        double[] WDat = this.getSampData(chn);
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length - 1;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        int minIndex = start;
        int maxIndex = start;
        int i = start;
        while (i < end) {
            if (WDat[minIndex] <= WDat[i]) {
                if (WDat[maxIndex] <= WDat[i]) {
                    maxIndex = i;
                }
            } else {
                minIndex = i;
            }
            ++i;
        }
        return WDat[maxIndex] - WDat[minIndex];
    }

    public double getMean(int chn, int start, int end) {
        double sum = 0.0;
        double[] WDat = this.getSampData(chn);
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        double srate = this.getSampleRate(chn);
        int Count = (int)(srate * this.getTRL(chn));
        int min = Math.min(end, Count);
        int i = start;
        while (i < min) {
            sum += WDat[i];
            ++i;
        }
        return sum / (double)(min - start);
    }

    public Phase getPhase(int chn, String phaseName) {
        Vector<Phase> vec = this.getTimeSeries(chn).getPhases();
        for (Phase p : vec) {
            if (!p.getPhaseName().equals(phaseName)) continue;
            return p;
        }
        return null;
    }

    public Phase getTheoreticPhase(int chn, String phaseName) {
        Vector<Phase> vec = this.getTimeSeries(chn).getTheoreticPhases();
        for (Phase p : vec) {
            if (!p.getPhaseName().equals(phaseName)) continue;
            return p;
        }
        return null;
    }

    public void removePhase(String phaseName) {
        int chn = 0;
        while (chn < this.TCN) {
            Vector<Phase> phs = this.getPhases(chn);
            Iterator<Phase> it = phs.iterator();
            while (it.hasNext()) {
                Phase ph = it.next();
                if (!ph.getPhaseName().equals(phaseName)) continue;
                it.remove();
            }
            ++chn;
        }
    }

    public void removeStationPhases(String net, String sta) {
        int[] chans = this.getChanOrder(net, sta);
        int i = 0;
        while (i < chans.length) {
            this.getPhases(chans[i]).clear();
            ++i;
        }
    }

    public float getMaxRes(String networkId, String stationCode) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        float max = 0.0f;
        int i = 0;
        while (i < chn.length) {
            Vector<Phase> phs = this.getPhases(chn[i]);
            for (Phase p : phs) {
                if (p.getPhaType() != 0 || !(max < Math.abs(p.getResi()))) continue;
                max = Math.abs(p.getResi());
            }
            ++i;
        }
        return max;
    }

    public double getTheoreticTravelTime(String pha, double delta, double depth) {
        double travelTime = this.ctt.calTravelTime(depth, delta, pha);
        if (travelTime == -1.0) {
            travelTime = Double.NaN;
        }
        return travelTime;
    }

    public double getTheoreticTravelTime(String pha, double delta, double depth, String model) {
        this.setComputedTravelTime(model);
        return this.getTheoreticTravelTime(pha, delta, depth);
    }

    public double getTheoreticTravelTime(String netSta, String pha, double s_lat, double s_lon, double s_depth, Date otime, String model) {
        double[] sta;
        double[] src;
        double travelTime;
        this.setComputedTravelTime(model);
        int idx = netSta.indexOf(47);
        String net = netSta.substring(0, idx);
        String stn = netSta.substring(idx + 1);
        int[] chn = this.getChanOrder(net, stn);
        if (chn == null || chn.length == 0) {
            return Double.NaN;
        }
        int c = chn[0];
        double staLat = this.getStationLocation(c).getLatitude();
        double staLon = this.getStationLocation(c).getLongtitude();
        double staAlt = this.getStationLocation(c).getAltitude();
        if (model.equals("TTTChuanDian")) {
            TTTChuanDian ttc = (TTTChuanDian)this.ctt;
            staLat = ttc.findStationIndex(net, stn);
            staLon = 0.0;
            staAlt = 0.0;
        }
        if ((travelTime = this.ctt.calTravelTime(src = new double[]{s_lat, s_lon, s_depth}, sta = new double[]{staLat, staLon, staAlt}, pha)) == -1.0) {
            travelTime = Double.NaN;
        }
        return travelTime;
    }

    public void generateTheoreticPhase(String[] netSta, String[] phaList, double s_lat, double s_lon, double s_depth, Date otime, String model, boolean onlyShowFirstPS) {
        this.setComputedTravelTime(model);
        double[] srcCoordinate = new double[]{s_lat, s_lon, s_depth};
        Vector<PH_TT> vecP = new Vector<PH_TT>(4);
        Vector<PH_TT> vecS = new Vector<PH_TT>(4);
        int s = 0;
        while (s < netSta.length) {
            int[] chn;
            int idx = netSta[s].indexOf(47);
            String net = netSta[s].substring(0, idx);
            String stn = netSta[s].substring(idx + 1);
            int[] nArray = chn = this.getChanOrder(net, stn);
            int n = chn.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                double staLat = this.getStationLocation(c).getLatitude();
                double staLon = this.getStationLocation(c).getLongtitude();
                double staAlt = this.getStationLocation(c).getAltitude();
                double delta = SphereUtil.distOnSphere((double)s_lat, (double)s_lon, (double)staLat, (double)staLon);
                if (model.equals("TTTChuanDian")) {
                    TTTChuanDian ttc = (TTTChuanDian)this.ctt;
                    staLat = ttc.findStationIndex(net, stn);
                    staLon = 0.0;
                    staAlt = 0.0;
                }
                double[] stnCoordinate = new double[]{staLat, staLon, staAlt};
                Vector<Phase> vec = this.getTheoreticPhases(c);
                vec.clear();
                Phase phase = null;
                int addP = 0;
                int addS = 0;
                vecP.clear();
                vecS.clear();
                String[] stringArray = phaList;
                int n3 = phaList.length;
                int n4 = 0;
                while (n4 < n3) {
                    double travelTime;
                    String phaName = stringArray[n4];
                    if (!(delta > 10.0 && (phaName.equals("Pn") || phaName.equals("Sn")) || delta > 9.0 && (phaName.equals("p") || phaName.equals("s")) || delta > 9.0 && (phaName.equals("Pg") || phaName.equals("Sg")) || delta < 28.0 && phaName.equals("PP") || delta < 145.0 && phaName.equals("PKP") || delta < 115.0 && phaName.equals("PKIKP") || delta < 105.0 && phaName.equals("PKiKP") || Double.isNaN(travelTime = this.ctt.calTravelTime(srcCoordinate, stnCoordinate, phaName)) || travelTime == -1.0 || delta >= 110.0 && phaName.endsWith("diff"))) {
                        if (onlyShowFirstPS) {
                            if (addP > 3 && addS > 3) break;
                            if (phaName.startsWith("P") || phaName.startsWith("p")) {
                                ++addP;
                                vecP.add(new PH_TT(phaName, travelTime));
                            }
                            if (phaName.startsWith("S") || phaName.startsWith("s")) {
                                ++addS;
                                vecS.add(new PH_TT(phaName, travelTime));
                            }
                        } else {
                            vecP.add(new PH_TT(phaName, travelTime));
                        }
                    }
                    ++n4;
                }
                if (onlyShowFirstPS) {
                    Collections.sort(vecP);
                    Collections.sort(vecS);
                    if (!vecP.isEmpty()) {
                        PH_TT e = (PH_TT)vecP.get(0);
                        vecP.clear();
                        vecP.add(e);
                    }
                    if (!vecS.isEmpty()) {
                        vecP.add((PH_TT)vecS.get(0));
                    }
                }
                for (PH_TT e : vecP) {
                    String phaName = e.ph;
                    double travelTime = e.tt;
                    phase = new Phase();
                    phase.setPhaseName(phaName);
                    phase.setNetCode(this.getNetworkCode(c));
                    phase.setStationCode(stn);
                    phase.setLocId(this.getAuxId(c));
                    phase.setChanCode(this.getChannelCode(c));
                    phase.setBelongedChannelID(0);
                    phase.setInstrumentName(this.getInstrumentType(c));
                    long date = otime.getTime() + (long)(travelTime * 1000.0);
                    phase.setPhaseTime(new Date(date));
                    phase.offset = (int)((double)(phase.getPhaseTime().getTime() - this.getArrivalTime(c).getTime()) / 1000.0 * this.getSampleRate(c));
                    phase.setWeight(0);
                    phase.setProcessType('T');
                    boolean found = false;
                    Enumeration<Phase> enu = vec.elements();
                    while (enu.hasMoreElements()) {
                        Phase phs = enu.nextElement();
                        if (!phs.getPhaseName().equals(phase.getPhaseName()) || phs.getProcessType() != 'T') continue;
                        found = true;
                    }
                    if (found) continue;
                    vec.add(phase);
                }
                ++n2;
            }
            ++s;
        }
    }

    public Vector<ChannelLocator> getNoDataChannel() {
        return this.noDataChannel;
    }

    public boolean isCleanNodataChannel() {
        return this.cleanNodataChannel;
    }

    public void setCleanNodataChannel(boolean cleanNodataChannel) {
        this.cleanNodataChannel = cleanNodataChannel;
    }

    @Override
    public synchronized boolean add(int chanOrder, Date newArrival, MiniSeedRecordDouble mrd) {
        return this.getTimeSeries(chanOrder).add(newArrival, mrd);
    }

    public synchronized void prepareStationDelta(double lat, double lon, Date otime) {
        source = new SourceParam();
        source.setLat(lat);
        source.setLon(lon);
        source.setOriginTime(otime);
        int i = 0;
        while (i < this.TCN) {
            Location loc = this.getStationLocation(i);
            SphereUtil.DELTAI deltai = SphereUtil.deltai((double)source.getLat(), (double)source.getLon(), (double)loc.getLatitude(), (double)loc.getLongtitude());
            loc.setDelta(deltai.delta);
            loc.setAzimuth(deltai.az1);
            ++i;
        }
        WaveFormSortType = 0;
    }

    public synchronized void prepareStationDelta(int chn) {
        source = new SourceParam();
        Location theLoc = this.getStationLocation(chn);
        source.setLat(theLoc.getLatitude());
        source.setLon(theLoc.getLongtitude());
        int i = 0;
        while (i < this.TCN) {
            Location loc = this.getStationLocation(i);
            SphereUtil.DELTAI deltai = SphereUtil.deltai((double)source.getLat(), (double)source.getLon(), (double)loc.getLatitude(), (double)loc.getLongtitude());
            loc.setDelta(deltai.delta);
            loc.setAzimuth(deltai.az1);
            ++i;
        }
        WaveFormSortType = 0;
    }

    public synchronized void cleanAllPhases() {
        int i = 0;
        while (i < this.TCN) {
            this.getPhases(i).removeAllElements();
            ++i;
        }
    }

    public synchronized void cleanAllPhases(char type) {
        int i = 0;
        while (i < this.TCN) {
            Iterator<Phase> it = this.getPhases(i).iterator();
            while (it.hasNext()) {
                Phase p = it.next();
                if (p.getProcessType() != type) continue;
                it.remove();
            }
            ++i;
        }
    }

    public synchronized void prepareTheoreticPhases(String model) {
        String[] phaList = new String[]{"P", "S", "Pn", "Sn", "Pg", "Sg", "p", "s", "Pdiff", "Sdiff", "PKiKP", "PKIKP", "PKP", "PP"};
        this.prepareTheoreticPhases(model, phaList, true);
    }

    public synchronized void prepareTheoreticPhases(String model, String[] phaList, boolean onlyShowFirstPS) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < this.TCN) {
            Location loc = this.getStationLocation(i);
            SphereUtil.DELTAI deltai = SphereUtil.deltai((double)source.getLat(), (double)source.getLon(), (double)loc.getLatitude(), (double)loc.getLongtitude());
            loc.setDelta(deltai.delta);
            loc.setAzimuth(deltai.az1);
            loc.setMaxResi(this.getMaxRes(this.getNetworkCode(i), this.getStationCode(i)));
            ++i;
        }
        SourceParam s = source;
        double depth = s.getDepth();
        if (depth < 0.0 || depth > 1000.0) {
            depth = 0.0;
        }
        this.generateTheoreticPhase(this.getAllNetStation(), phaList, s.getLat(), s.getLon(), depth, s.getOriginTime(), model, onlyShowFirstPS);
    }

    private void setComputedTravelTime(String model) {
        if (model.equals("TTTDing")) {
            this.ctt = new TTTDing();
        } else if (model.equals("TTTChuanDian")) {
            EvtData.generateChuanDianStationList(this);
            this.ctt = new TTTChuanDian();
            TTTChuanDian.init();
        } else if (model.equals("IASPEI91")) {
            if (!(this.ctt instanceof NetCDFTable)) {
                NetCDFTable lst = new NetCDFTable();
                lst.setInterpolate(false);
                lst.setup_tttables("../lib/nc/iasp91.nc");
                this.ctt = lst;
            }
        } else {
            this.ctt = new TauPToolkit(model);
        }
    }

    public static void generateChuanDianStationList(EvtData evtData) {
        String staFileName = "../lib/chuandian/sy_station.txt";
        File staFile = new File("../lib/chuandian/sy_station.txt");
        if (!staFile.getParentFile().exists()) {
            return;
        }
        Hashtable<String, Location> tbl = new Hashtable<String, Location>(256);
        Vector<String> stnList = new Vector<String>(16);
        int i = 0;
        while (i < evtData.TCN) {
            String key = String.valueOf(evtData.getNetworkCode(i)) + evtData.getStationCode(i);
            if (!stnList.contains(key)) {
                stnList.add(key);
            }
            Location loc = evtData.getStationLocation(i);
            tbl.put(key, loc);
            ++i;
        }
        Collections.sort(stnList);
        try {
            PrintWriter pw = new PrintWriter(new FileWriter("../lib/chuandian/sy_station.txt"));
            pw.printf("%d %d\n", tbl.size(), 0);
            for (String key : stnList) {
                Location loc = (Location)tbl.get(key);
                pw.printf("%6s %9.5f  %10.5f %4d %6s %6s %6s\n", key, loc.lat, loc.lon, (int)(loc.alt * 1000.0), key, key, key);
            }
            pw.close();
        }
        catch (IOException io) {
            logger.warn((Object)io.getMessage(), (Throwable)io);
        }
    }

    public boolean hasGapsData(int chn, int start, int end) {
        int count = 0;
        double[] wDat = this.getSampData(chn);
        int i = start;
        while (i < end) {
            count = Math.abs(wDat[i]) < 1.0 ? ++count : 0;
            if (count == 20) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasClippingData(int chn, int start, int end) {
        int MAX_COUNT = (int)(Math.pow(2.0, 23.0) * 0.85);
        double[] wDat = this.getSampData(chn);
        int i = start;
        while (i < end) {
            if (Math.abs(wDat[i]) > (double)MAX_COUNT) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void autoAdjustPick() {
        int chn = 0;
        while (chn < this.TCN) {
            Vector<Phase> vec = this.getPhases(chn);
            Collections.sort(vec);
            String phName = null;
            for (Phase ph : vec) {
                if (ph.getPhaType() != 0 || ph.getProcessType() == 'T' || !ph.getPhaseName().startsWith("P")) continue;
                phName = ph.getPhaseName();
                break;
            }
            if (phName != null) {
                this.autoAdjustPick(phName, chn);
            }
            ++chn;
        }
    }

    public void autoAdjustPick(String phName, int chn) {
        Enumeration<Phase> vectEnum = this.getPhases(chn).elements();
        Phase phase = null;
        while (vectEnum.hasMoreElements()) {
            phase = vectEnum.nextElement();
            if (!phase.getPhaseName().equals(phName) || phase.getProcessType() == 'T') continue;
            this.getPhases(chn).removeElement(phase);
            break;
        }
        if (phase == null) {
            return;
        }
        logger.info((Object)String.format("User pick offset: %d", phase.offset));
        phase.offset = this.autoAdjustPick(phase.offset, chn);
        int sr = (int)Math.round(this.getSampleRate(chn));
        long date = this.getArrivalTime(chn).getTime() + (long)phase.offset * 1000L / (long)sr;
        phase.setPhaseTime(new Date(date));
        phase.setBackAzimuth(-99999.0f);
        this.getPhases(chn).addElement(phase);
    }

    public int autoAdjustPick(int offset, int chn) {
        int fltIdx;
        int len;
        int sr = (int)Math.round(this.getSampleRate(chn));
        double[] v = this.getSampData(chn);
        int range = sr * 10;
        int off = offset - range;
        if (off < 0) {
            off = 0;
        }
        if (off + (len = 2 * range) > v.length) {
            return offset;
        }
        int rawIdx = AICPicker.pick(v, off, len);
        double fp1 = 0.7;
        double fp2 = Math.min(8.0, (double)sr / 2.0);
        Filter[] flt = ButterFilter.getButterFilter(sr, 1, "BP", 2, fp1, fp2);
        double[] vv = new double[len];
        System.arraycopy(v, off, vv, 0, len);
        vv = ArrayMath.add((double[])vv, (double)(-ArrayMath.mean((double[])vv)));
        Numeric.taper(vv, len, 0.1);
        int tp_off = (int)(0.1 * (double)len);
        double[] vvv = flt[0].filter(vv);
        int idx = fltIdx = off + AICPicker.pick(vvv, tp_off, len - 2 * tp_off);
        double snr = EvtData.signal_noise_ratio(v, rawIdx, Math.abs(fltIdx - rawIdx));
        if (rawIdx < fltIdx && (fltIdx - rawIdx) / sr < 3 && snr > 4.0) {
            off = rawIdx - range;
            if (off < 0) {
                off = 0;
            }
            if (off + len > v.length) {
                len = v.length - off;
            }
            vv = new double[len];
            System.arraycopy(v, off, vv, 0, len);
            double mean = ArrayMath.mean((double[])vv);
            int cz = 0;
            int j = rawIdx;
            while (j < fltIdx) {
                if ((v[j] - mean) * (v[j + 1] - mean) < 0.0) {
                    ++cz;
                }
                ++j;
            }
            if (cz < 3) {
                idx = rawIdx;
            }
        }
        logger.info((Object)String.format("AIC found offset: %d  %d  %d %.2f snr=%.1f for %s", idx, rawIdx, fltIdx, Float.valueOf((float)(fltIdx - rawIdx) / (float)sr), snr, this.getChannelLocator(chn)));
        if (idx != -1) {
            offset = idx;
        }
        return offset;
    }

    private static double signal_noise_ratio(double[] x, int r0, int winlen) {
        if (r0 - winlen < 0 || r0 + winlen > x.length) {
            return -1.0;
        }
        double mean = 0.0;
        int i = 0;
        while (i < winlen) {
            mean += x[r0 - i];
            ++i;
        }
        mean /= (double)winlen;
        double signal = 0.0;
        double noise = 0.0;
        i = 0;
        while (i < winlen) {
            double f = x[r0 - i] - mean;
            noise += Math.abs(f);
            f = x[r0 + i] - mean;
            signal += Math.abs(f);
            ++i;
        }
        return noise == 0.0 ? -1.0 : signal / noise;
    }

    public void autoPicker(boolean multiPhase) {
        boolean fp5 = true;
        if (fp5) {
            this.pickerFP5(multiPhase);
            return;
        }
        Vector<String> ns = new Vector<String>(64);
        int chn = 0;
        while (chn < this.getTCN()) {
            String key;
            if (this.getChannelCode(chn).endsWith("Z") && !ns.contains(key = String.valueOf(this.getStationCode(chn)) + "." + this.getNetworkCode(chn))) {
                ns.add(key);
                this.pickerStaLta(chn);
            }
            ++chn;
        }
        this.autoAdjustPick();
    }

    public void pickerStaLta(int chn) {
        int len;
        int SNR_WLEN = 5;
        int sr = (int)Math.round(this.getSampleRate(chn));
        double dt = 1.0 / this.getSampleRate(chn);
        double[] dz = this.getSampData(chn);
        ARAICPicker.remove_mean(dz, dz.length);
        double fp1 = ARAICPicker.BPF_CO1;
        double fp2 = Math.min(ARAICPicker.BPF_CO2, (double)(sr / 2));
        Filter[] staltaFlt = ButterFilter.getButterFilter(sr, 1, "BP", 4, fp1, fp2);
        double[] f_dz = staltaFlt[0].filter(dz);
        STALTA stalta = new STALTA(true, sr);
        int r0_detect = stalta.detect_stalta(f_dz, f_dz.length, dt);
        if (r0_detect == 0) {
            logger.info((Object)String.format("%s could not trig!", this.getChannelLocator(chn)));
            return;
        }
        fp1 = ARAICPicker.PP_CF1;
        fp2 = Math.min(ARAICPicker.PP_CF2, (double)(sr / 2));
        Filter[] aicFlt = ButterFilter.getButterFilter(sr, 1, "BP", 4, fp1, fp2);
        f_dz = aicFlt[0].filter(dz);
        double sn = EvtData.signal_noise_ratio(f_dz, r0_detect, (int)(5.0 / dt));
        ARAICPicker araicPicker = new ARAICPicker();
        int r0_pick = araicPicker.araic(f_dz, r0_detect, dt, f_dz.length);
        double sn0 = EvtData.signal_noise_ratio(dz, r0_pick, len = (int)(5.0 / dt));
        if (sn0 < 0.0 || this.hasGapsData(chn, r0_pick - len, r0_pick + len)) {
            logger.info((Object)String.format("%s could not trig!", this.getChannelLocator(chn)));
            return;
        }
        logger.info((Object)String.format("%s: STA/LTA onset estimate at %d, SNR(bpf) %.1f; ARAIC at %d, SNR(raw) %.1f", this.getChannelLocator(chn), r0_detect, sn, r0_pick, sn0));
        String phName = "P";
        Iterator<Phase> it = this.getPhases(chn).iterator();
        Phase phase = null;
        while (it.hasNext()) {
            phase = it.next();
            if (!phase.getPhaseName().equals(phName) || phase.getProcessType() == 'T') continue;
            it.remove();
        }
        phase = new Phase();
        phase.setPhaseName(phName);
        phase.setNetCode(this.getNetworkCode(chn));
        phase.setStationCode(this.getStationCode(chn));
        phase.setLocId(this.getAuxId(chn));
        phase.setChanCode(this.getChannelCode(chn));
        phase.setBelongedChannelID(this.toComp(chn) - 1);
        phase.setRecType(this.getOriginalType(chn));
        phase.setInstrumentName(this.getInstrumentType(chn));
        phase.setPhaType(0);
        phase.setBackAzimuth(-99999.0f);
        phase.offset = r0_pick;
        long date = this.getArrivalTime(chn).getTime() + (long)phase.offset * 1000L / (long)sr;
        phase.setPhaseTime(new Date(date));
        phase.setSnr(sn0);
        this.getPhases(chn).addElement(phase);
    }

    public void pickerFP5(boolean multiPhase) {
        long now = System.currentTimeMillis();
        int SNR_WLEN = 5;
        Vector<Integer> vecChn = new Vector<Integer>(16);
        Vector<String> ns = new Vector<String>(64);
        int chn = 0;
        while (chn < this.getTCN()) {
            String key;
            if (this.getChannelCode(chn).endsWith("Z") && !ns.contains(key = String.valueOf(this.getStationCode(chn)) + "." + this.getNetworkCode(chn))) {
                ns.add(key);
                vecChn.add(chn);
            }
            ++chn;
        }
        int size = vecChn.size();
        int ncpu = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        int n = size / ncpu;
        if (size % ncpu != 0) {
            ++n;
        }
        ExecutorService pool = Executors.newFixedThreadPool(ncpu);
        Future[] futurePD = new Future[ncpu];
        int i = 0;
        while (i < n) {
            double dt;
            int chn2;
            int ncount = 0;
            int k = 0;
            while (k < ncpu) {
                int idx = i * ncpu + k;
                if (idx >= size) break;
                chn2 = (Integer)vecChn.get(idx);
                dt = 1.0 / this.getSampleRate(chn2);
                double[] dz = this.getSampData(chn2);
                FilterPicker5.CallFP5 callFP5 = new FilterPicker5.CallFP5(chn2, dt, dz, 10.0, 10.0, 10.0, 0.5, 5.0, !multiPhase);
                futurePD[k] = pool.submit(callFP5);
                ++k;
                ++ncount;
            }
            try {
                int j = 0;
                while (j < ncount) {
                    FilterPicker5.PD PD2 = (FilterPicker5.PD)futurePD[j].get();
                    chn2 = PD2.chn;
                    dt = 1.0 / this.getSampleRate(chn2);
                    int sr = (int)Math.round(this.getSampleRate(chn2));
                    double[] dz = this.getSampData(chn2);
                    String phName = "P";
                    Iterator<Phase> it = this.getPhases(chn2).iterator();
                    Phase phase = null;
                    while (it.hasNext()) {
                        phase = it.next();
                        if (!phase.getPhaseName().equals(phName) || phase.getProcessType() == 'T') continue;
                        it.remove();
                    }
                    for (PickData pd : PD2.pd) {
                        phase = new Phase();
                        phase.setPhaseName(phName);
                        phase.setNetCode(this.getNetworkCode(chn2));
                        phase.setStationCode(this.getStationCode(chn2));
                        phase.setLocId(this.getAuxId(chn2));
                        phase.setChanCode(this.getChannelCode(chn2));
                        phase.setBelongedChannelID(this.toComp(chn2) - 1);
                        phase.setRecType(this.getOriginalType(chn2));
                        phase.setInstrumentName(this.getInstrumentType(chn2));
                        phase.setPhaType(0);
                        phase.setBackAzimuth(-99999.0f);
                        int r0_pick = (int)(pd.indices[0] + pd.indices[1]) / 2;
                        int len = (int)(5.0 / dt);
                        double sn0 = EvtData.signal_noise_ratio(dz, r0_pick, len);
                        if (sn0 < 0.0 || this.hasGapsData(chn2, r0_pick - len, r0_pick + len)) continue;
                        phase.offset = r0_pick;
                        long date = this.getArrivalTime(chn2).getTime() + (long)phase.offset * 1000L / (long)sr;
                        phase.setPhaseTime(new Date(date));
                        phase.setSnr(sn0);
                        this.getPhases(chn2).addElement(phase);
                        if (!multiPhase) break;
                    }
                    ++j;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        pool.shutdown();
        logger.info((Object)("pickerFP5 time: " + (System.currentTimeMillis() - now)));
    }

    public void autoPickerByTheoreticPhase() {
        Vector<String> ns = new Vector<String>(64);
        int chn = 0;
        while (chn < this.getTCN()) {
            String key;
            if (this.getChannelCode(chn).endsWith("Z") && !ns.contains(key = String.valueOf(this.getStationCode(chn)) + "." + this.getNetworkCode(chn))) {
                ns.add(key);
                this.autoPickerByTheoreticPhase(chn);
            }
            ++chn;
        }
    }

    public void autoPickerByTheoreticPhase(int chn) {
        Phase ph = this.getPhase(chn, "P");
        if (ph == null) {
            ph = this.getPhase(chn, "p");
        }
        if (ph == null) {
            ph = this.getPhase(chn, "Pg");
        }
        if (ph == null) {
            ph = this.getPhase(chn, "Pb");
        }
        if (ph == null) {
            ph = this.getPhase(chn, "Pn");
        }
        if (ph == null) {
            ph = this.getPhase(chn, "Pdiff");
        }
        if (ph != null) {
            return;
        }
        Phase phase = new Phase();
        phase.setPhaseName("P");
        phase.setNetCode(this.getNetworkCode(chn));
        phase.setStationCode(this.getStationCode(chn));
        phase.setChanCode(this.getChannelCode(chn));
        phase.setLocId(this.getAuxId(chn));
        phase.setRecType(this.getOriginalType(chn));
        phase.setBelongedChannelID(this.toComp(chn) - 1);
        phase.setInstrumentName(this.getInstrumentType(chn));
        phase.setPhaType(0);
        phase.setBackAzimuth(-99999.0f);
        Vector<Phase> vecPhs = this.getTheoreticPhases(chn);
        if (vecPhs.isEmpty()) {
            return;
        }
        Collections.sort(vecPhs);
        ph = vecPhs.get(0);
        if (ph.getPhaseName().startsWith("P") || ph.getPhaseName().startsWith("p")) {
            int len;
            double sr = Math.round(this.getSampleRate(chn));
            phase.offset = this.autoAdjustPick(ph.offset, chn);
            double[] dz = this.getSampData(chn);
            double sn = EvtData.signal_noise_ratio(dz, phase.offset, len = (int)(5.0 * sr));
            if (sn < 0.0 || this.hasGapsData(chn, phase.offset - len, phase.offset + len)) {
                return;
            }
            if (Math.abs((double)(ph.offset - phase.offset) / sr) > 4.0 || sn < 4.0) {
                return;
            }
            long date = this.getArrivalTime(chn).getTime() + (long)((double)((long)phase.offset * 1000L) / sr);
            phase.setPhaseTime(new Date(date));
            phase.setSnr(sn);
            this.getPhases(chn).addElement(phase);
        }
    }

    public void shiftTheoreticPhase(int chn) {
        double theoPhT;
        Phase manPh;
        Vector<Phase> theoVec = this.getTheoreticPhases(chn);
        if (theoVec.size() == 0) {
            return;
        }
        Collections.sort(theoVec);
        Phase theoPh = theoVec.get(0);
        String phName = theoPh.getPhaseName();
        Phase ph_old = this.getPhase(chn, phName);
        if (ph_old != null) {
            return;
        }
        if (phName.equals("p")) {
            phName = source != null && source.getDepth() <= 33.0 ? "Pg" : "P";
        }
        if (phName.equals("s")) {
            phName = source != null && source.getDepth() <= 33.0 ? "Sg" : "S";
        }
        if ((manPh = this.getPhase(chn, "P")) == null) {
            return;
        }
        double sr = Math.round(this.getSampleRate(chn));
        double manT = (double)manPh.offset / sr;
        if (Math.abs(manT - (theoPhT = (double)theoPh.offset / sr)) < 2.0) {
            manPh.setPhaseName(phName);
        }
    }

    public void autoMarkWaveSignAndClarity(int chn, String phaseName) {
        double MIN_ACC = 25.0;
        double MIN_DIS = 15.0;
        Phase ph = this.getPhase(chn, phaseName);
        if (!phaseName.startsWith("P") && !phaseName.startsWith("p") || ph == null || ph.getPhaType() != 0 || ph.getWsign().length() != 0) {
            return;
        }
        double[] wdat = this.getSampData(chn);
        int sr = (int)this.getSampleRate(chn);
        int beg = ph.offset - 10 * sr;
        int end = ph.offset + 10 * sr;
        if (beg < 0) {
            beg = 0;
        }
        if (end > wdat.length) {
            end = wdat.length;
        }
        double mean = 0.0;
        int i = 0;
        while (i < 10 * sr) {
            mean += wdat[beg + i];
            ++i;
        }
        mean /= (double)(10 * sr);
        mean = wdat[ph.offset - 1];
        double snr = EvtData.signal_noise_ratio(wdat, ph.offset, sr);
        double[] par = LocationMath.measurePeriod(wdat, ph.offset, beg, end, sr, mean);
        if (Double.isNaN(par[0]) || par[0] < 0.1 || snr < 16.0) {
            return;
        }
        int halfPer = (int)((double)sr * par[0]) / 2;
        int maxIdx = ph.offset;
        int i2 = 1;
        while (i2 < halfPer) {
            if ((wdat[ph.offset + i2 - 1] - mean) * (wdat[ph.offset + i2] - mean) <= 0.0 && i2 > 5) break;
            if (Math.abs(wdat[ph.offset + i2]) > Math.abs(wdat[maxIdx])) {
                maxIdx = ph.offset + i2;
            }
            ++i2;
        }
        double acc = Math.abs(wdat[maxIdx] - mean) / this.getCalibFactor(chn) / ((double)(maxIdx - ph.offset) / (double)sr);
        double dis = Math.abs(wdat[maxIdx] - mean) / this.getCalibFactor(chn) * ((double)(maxIdx - ph.offset) / (double)sr) / 2.0;
        if (acc > 25.0 || dis > 15.0) {
            ph.setClarity("I");
        }
        String wsign = "";
        wsign = wdat[maxIdx] > mean ? "U" : "R";
        if (this.getChannelCode(chn).charAt(0) == 'S' || this.getChannelCode(chn).charAt(0) == 'H' || this.getInstrumentType(chn).equals("W.A.") || this.getInstrumentType(chn).equals("WWSSNSP")) {
            if (wsign.equals("U")) {
                wsign = "C";
            } else if (wsign.equals("R")) {
                wsign = "D";
            }
        }
        ph.setWsign(wsign);
        logger.info((Object)String.format("%.2f  %.2f  %d", acc, par[0], (int)Math.signum(wdat[maxIdx] - mean)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PH_TT
    implements Comparable<PH_TT> {
        public String ph;
        public double tt;

        public PH_TT(String ph, double tt) {
            this.ph = ph;
            this.tt = tt;
        }

        @Override
        public int compareTo(PH_TT o) {
            double d = Math.abs(this.tt - o.tt);
            if (d < 0.01) {
                return o.ph.compareTo(this.ph);
            }
            return (int)Math.signum(this.tt - o.tt);
        }
    }
}

