/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.edas.GeoDevEvent;
import cn.org.gddsn.util.Log4jConfig;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Event2Edas {
    static Logger logger = Logger.getLogger(Event2Edas.class);

    public static void convert(File seedFile, File edasFile) throws IOException {
        EvtData seedEvt = EvtData.readEvtData(seedFile.getAbsolutePath());
        GeoDevEvent geoDevEvt = new GeoDevEvent(seedEvt);
        geoDevEvt.writeEvtFile(edasFile.getAbsolutePath());
    }

    public static void main(String[] args) throws IOException {
        File edasDir;
        File seedDir;
        Log4jConfig.loadForMain((String)"Event2Edas.properties");
        if (args.length != 2) {
            System.err.println("Usage: Event2Edas seedDir edasDir");
            System.exit(-1);
        }
        if (!(seedDir = new File(args[0])).exists() || seedDir.isFile()) {
            System.err.println("seedDir is not exit or not directory");
            System.exit(-1);
        }
        if (!(edasDir = new File(args[1])).exists() || edasDir.isFile()) {
            System.err.println("edasDir is not exit or not directory");
            System.exit(-1);
        }
        File[] seedList = seedDir.listFiles();
        String efn = null;
        File[] fileArray = seedList;
        int n = seedList.length;
        int n2 = 0;
        while (n2 < n) {
            File seedFile = fileArray[n2];
            String sfn = seedFile.getName();
            int idx = sfn.lastIndexOf(".");
            if (idx != 0) {
                efn = idx != -1 ? String.valueOf(sfn.substring(0, idx)) + ".EVT" : String.valueOf(sfn) + ".EVT";
                try {
                    logger.info((Object)("Proceeding " + seedFile));
                    File edasFile = new File(edasDir, efn);
                    Event2Edas.convert(seedFile, edasFile);
                    logger.info((Object)("wrote " + edasFile));
                }
                catch (IOException ioEx) {
                    logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
                }
            }
            ++n2;
        }
    }
}

