/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.eqim;

import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.eqim.Catalog;
import cn.org.gddsn.seis.eqim.EqimLocation;
import cn.org.gddsn.seis.eqim.Layer;
import cn.org.gddsn.seis.eqim.Model;
import cn.org.gddsn.seis.eqim.Network;
import cn.org.gddsn.seis.eqim.Phase;
import cn.org.gddsn.seis.eqim.Station;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.InputInfoForLoc;
import cn.org.gddsn.seis.location.StnLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

public class EqimUtils {
    static Logger logger = Logger.getLogger(EqimLocation.class);
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

    public static EqimLocation buildEqimLocation(String networkId, String networkName, EvtData evt, cn.org.gddsn.jopens.entity.Catalog c) {
        EqimLocation eqimLocation = new EqimLocation();
        Model model = new Model();
        model.setNet(networkId);
        model.setCataId(c.getId());
        Layer[] layers = new Layer[3];
        layers[0] = new Layer();
        layers[0].setThickness(15.0);
        layers[0].setVelp(6.0);
        layers[1] = new Layer();
        layers[1].setThickness(18.0);
        layers[1].setVelp(6.5);
        layers[2] = new Layer();
        layers[2].setThickness(0.0);
        layers[2].setVelp(8.0);
        model.setLayer(layers);
        model.setLayerNum(layers.length);
        model.setCrust(33.0);
        model.setVelpDivVels(1.71);
        eqimLocation.setModel(model);
        Network network = new Network();
        network.setCode(networkId);
        network.setCname(networkName);
        network.setSname(networkName);
        eqimLocation.setNetwork(network);
        if (evt != null) {
            String[] ns = evt.getAllNetStation();
            Station[] station = new Station[ns.length];
            int i = 0;
            while (i < station.length) {
                station[i] = new Station();
                int idx = ns[i].indexOf(47);
                int[] chn = evt.getChanOrder(ns[i].substring(0, idx), ns[i].substring(idx + 1));
                int ch = chn[0];
                station[i].setNet(evt.getNetworkCode(ch));
                station[i].setCode(evt.getStationCode(ch));
                station[i].setLat(evt.getStationLocation(ch).getLatitude());
                station[i].setLon(evt.getStationLocation(ch).getLongtitude());
                station[i].setElev(evt.getStationLocation(ch).getAltitude());
                ++i;
            }
            network.setStation(station);
        }
        Catalog catalog = new Catalog();
        catalog.setCataId(c.getId());
        if (c.getEventInfo() != null) {
            catalog.setEventId(c.getEventInfo().getEventId());
        } else {
            catalog.setEventId(c.getId());
        }
        catalog.setProgram(c.getLocProgram());
        catalog.setSaveTime(sdf.format(c.getSaveTime()));
        catalog.setEqType(c.getEqType());
        catalog.setOtime(sdf.format(new Date(c.getFullOriginTime().getTime())));
        catalog.setLat(c.getLat());
        catalog.setLon(c.getLon());
        catalog.setDepth(c.getDepth());
        catalog.setMs(c.getM());
        catalog.setM(c.getM());
        catalog.setRms(c.getRms());
        catalog.setUsedPha(c.getLocPha());
        catalog.setUsedStn(c.getLocStn());
        catalog.setEpicId(c.getEpicId());
        catalog.setSourceId(c.getSourceId());
        eqimLocation.setCatalog(catalog);
        int size = c.getPhases().size();
        Phase[] phase = new Phase[size];
        int n = 0;
        for (cn.org.gddsn.jopens.entity.Phase ph : c.getPhases()) {
            phase[n] = new Phase();
            phase[n].setCataId(c.getId());
            phase[n].setNet(ph.getChannelLocator().getNetCode());
            phase[n].setStaCode(ph.getChannelLocator().getStationCode());
            phase[n].setLocId("00");
            phase[n].setChanCode(ph.getChannelLocator().getChanCode());
            phase[n].setPhaseName(ph.getPhaseName());
            phase[n].setPhaseTime(sdf.format(ph.getFullPhaseTime()));
            phase[n].setAmp(ph.getAmp());
            phase[n].setPeriod(ph.getPeriod());
            phase[n].setAmpType("full");
            phase[n].setAmpUnit("um/s");
            ++n;
        }
        eqimLocation.setPhase(phase);
        return eqimLocation;
    }

    public static EqimLocation buildEqimLocation(String networkId, String networkName, InputInfoForLoc inputInfoForLoc, SourceParam source) {
        EqimLocation eqimLocation = new EqimLocation();
        Model model = new Model();
        model.setNet(networkId);
        model.setCataId(source.getCataId());
        Layer[] layers = new Layer[3];
        layers[0] = new Layer();
        layers[0].setThickness(15.0);
        layers[0].setVelp(6.0);
        layers[1] = new Layer();
        layers[1].setThickness(18.0);
        layers[1].setVelp(6.5);
        layers[2] = new Layer();
        layers[2].setThickness(0.0);
        layers[2].setVelp(8.0);
        model.setLayer(layers);
        model.setLayerNum(layers.length);
        model.setCrust(33.0);
        model.setVelpDivVels(1.71);
        eqimLocation.setModel(model);
        Network network = new Network();
        network.setCode(networkId);
        network.setCname(networkName);
        network.setSname(networkName);
        StnLocation[] stnLocation = inputInfoForLoc.getStnLocations();
        Station[] station = new Station[stnLocation.length];
        int i = 0;
        while (i < stnLocation.length) {
            station[i] = new Station();
            station[i].setCode(stnLocation[i].getSta());
            station[i].setLat(stnLocation[i].getLat());
            station[i].setLon(stnLocation[i].getLon());
            station[i].setElev(stnLocation[i].getAlt());
            ++i;
        }
        network.setStation(station);
        eqimLocation.setNetwork(network);
        Catalog catalog = new Catalog();
        catalog.setCataId(source.getCataId());
        catalog.setEventId(source.getEventId());
        catalog.setProgram(source.locProgram);
        catalog.setSaveTime(sdf.format(source.saveTime));
        catalog.setEqType("\u5730\u9707");
        catalog.setOtime(sdf.format(source.originTime));
        catalog.setLat(source.lat);
        catalog.setLon(source.lon);
        catalog.setDepth(source.depth);
        if (!Double.isNaN(source.ml)) {
            catalog.setMl(source.ml);
        }
        if (!Double.isNaN(source.ms)) {
            catalog.setMs(source.ms);
        }
        if (!Double.isNaN(source.getM())) {
            catalog.setM(source.getM());
        }
        catalog.setRms(source.rms);
        catalog.setUsedPha(source.getLocPha());
        catalog.setUsedStn(source.locStn);
        catalog.setEpicId(source.epicId);
        catalog.setSourceId(source.sourceId);
        eqimLocation.setCatalog(catalog);
        Vector<cn.org.gddsn.seis.Phase>[] stnPhases = inputInfoForLoc.getStnPhases();
        Vector<Phase> vecPha = new Vector<Phase>(32);
        int i2 = 0;
        while (i2 < stnPhases.length) {
            int size = stnPhases[i2].size();
            int j = 0;
            while (j < size) {
                Phase phase = new Phase();
                vecPha.add(phase);
                cn.org.gddsn.seis.Phase ph = stnPhases[i2].get(j);
                phase.setCataId(ph.getCataId());
                phase.setNet(ph.getNetCode());
                phase.setStaCode(ph.getStationCode());
                phase.setLocId("00");
                phase.setChanCode(ph.getChanCode());
                phase.setPhaseName(ph.getPhaseName());
                phase.setPhaseTime(sdf.format(ph.getPhaseTime()));
                phase.setAmp(ph.getAmp());
                phase.setPeriod(ph.getPeriod());
                phase.setAmpType("full");
                phase.setAmpUnit("um/s");
                ++j;
            }
            ++i2;
        }
        Phase[] phs = new Phase[vecPha.size()];
        vecPha.toArray(phs);
        eqimLocation.setPhase(phs);
        return eqimLocation;
    }

    public static EqimLocation readEqimLocation(InputStream reader) throws IOException {
        EqimLocation dataless = null;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(EqimLocation.class.getResource("mapping.xml"));
            Unmarshaller unmarshaller = new Unmarshaller(EqimLocation.class);
            unmarshaller.setMapping(mapping);
            dataless = (EqimLocation)unmarshaller.unmarshal(new InputSource(reader));
            reader.close();
        }
        catch (ValidationException vEx) {
            logger.warn((Object)vEx.getMessage(), (Throwable)vEx);
        }
        catch (MarshalException marEx) {
            logger.warn((Object)marEx.getMessage(), (Throwable)marEx);
        }
        catch (MappingException mEx) {
            logger.warn((Object)mEx.getMessage(), (Throwable)mEx);
        }
        return dataless;
    }

    public static boolean writeEqimLocation(OutputStream writer, EqimLocation qeimlocation) throws IOException {
        boolean ret = false;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(EqimLocation.class.getResource("mapping.xml"));
            String encoding = "UTF-8";
            OutputStreamWriter osw = new OutputStreamWriter(writer, encoding);
            Marshaller marshaller = new Marshaller((Writer)osw);
            marshaller.setEncoding(encoding);
            marshaller.setMapping(mapping);
            marshaller.setSuppressNamespaces(true);
            marshaller.setSuppressXSIType(true);
            marshaller.marshal((Object)qeimlocation);
            ret = true;
        }
        catch (ValidationException vEx) {
            logger.warn((Object)vEx.getMessage(), (Throwable)vEx);
            ret = false;
        }
        catch (MarshalException marEx) {
            logger.warn((Object)marEx.getMessage(), (Throwable)marEx);
            ret = false;
        }
        catch (MappingException mEx) {
            mEx.printStackTrace();
            logger.warn((Object)mEx.getMessage(), (Throwable)mEx);
            ret = false;
        }
        return ret;
    }
}

