/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.ttt3d.TTTDing;
import cn.org.gddsn.util.Log4jConfig;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class TBTTMgr {
    static Logger logger = Logger.getLogger(TBTTMgr.class);
    private File staFile = new File("/tmp/yjs/jopens/netcdftbtt/station.txt");
    private File ncFilename = new File("/tmp/yjs/jopens/netcdftbtt/capital.nc");
    private final String[] phs = new String[]{"Pg", "Pb", "Pn", "PmP", "Sg", "Sb", "Sn", "SmS"};
    private int nsta = -1;
    private int nphs = this.phs.length;
    private int maxtbazi = 72;
    private int maxtbdelta = 100;
    private int maxtbdep = 15;
    private int maxPhaseLength = 8;
    private int maxStaLength = 8;
    private String[] station;
    private float[] tbstalat;
    private float[] tbstalon;
    private float[] tbstaelev;
    private float[] tbazi;
    private float[] tbdelta;
    private float[] tbdep = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 10.0f, 15.0f, 19.0f, 21.0f, 25.0f, 30.0f, 33.0f, 35.0f, 40.0f};
    private float[][][][][] tb3dt;
    private ExecutorService pool = null;
    private int ncpu = 2;

    public void generate() throws Exception {
        this.init();
        this.fillStationInfo();
        this.cttt1();
        this.writeNetCDF();
    }

    private int getStationCount() throws IOException {
        int n = 0;
        BufferedReader br = new BufferedReader(new FileReader(this.staFile));
        while (br.readLine() != null) {
            ++n;
        }
        br.close();
        this.nsta = n;
        System.out.printf("Total station number: %d\n", this.nsta);
        return this.nsta;
    }

    private void fillStationInfo() throws IOException {
        int n = 0;
        String line = null;
        BufferedReader br = new BufferedReader(new FileReader(this.staFile));
        while ((line = br.readLine()) != null) {
            Scanner sc = new Scanner(line);
            this.station[n] = sc.next();
            this.tbstalat[n] = sc.nextFloat();
            this.tbstalon[n] = sc.nextFloat();
            this.tbstaelev[n] = sc.nextFloat();
            ++n;
        }
        br.close();
    }

    private void init() throws IOException {
        this.nsta = this.getStationCount();
        this.station = new String[this.nsta];
        this.tbstalat = new float[this.nsta];
        this.tbstalon = new float[this.nsta];
        this.tbstaelev = new float[this.nsta];
        this.tbazi = new float[this.maxtbazi];
        this.tbdelta = new float[this.maxtbdelta];
        this.tb3dt = new float[this.nsta][this.nphs][this.maxtbazi][this.maxtbdep][this.maxtbdelta];
        this.fillStationInfo();
        int i = 0;
        while (i < 72) {
            this.tbazi[i] = i * 5;
            ++i;
        }
        i = 0;
        while (i < this.maxtbdelta) {
            this.tbdelta[i] = 0.1f * (float)i;
            ++i;
        }
    }

    public void cttt() {
        this.pool = Executors.newFixedThreadPool(this.ncpu);
        Future[] fts = new Future[this.nsta];
        int s = 0;
        while (s < this.nsta) {
            CTTT ct = new CTTT(s);
            fts[s] = this.pool.submit(ct);
            ++s;
        }
        try {
            s = 0;
            while (s < this.nsta) {
                fts[s].get();
                ++s;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.pool.shutdown();
    }

    public void cttt1() {
        TTTDing ttt = new TTTDing();
        int s = 0;
        while (s < this.nsta) {
            float slat = this.tbstalat[s];
            float slon = this.tbstalon[s];
            float selev = this.tbstaelev[s];
            int p = 0;
            while (p < this.nphs) {
                String ph = this.phs[p];
                double per = (double)(s * this.nphs + p) / (double)(this.nsta * this.nphs) * 100.0;
                System.out.printf("%.3f%%, %d, %d, %d, %d\n", per, s, p, this.nsta, this.nphs);
                int a = 0;
                while (a < this.maxtbazi) {
                    float backAzi = this.tbazi[a];
                    int d = 0;
                    while (d < this.maxtbdep) {
                        float dep = this.tbdep[d];
                        int e = 0;
                        while (e < this.maxtbdelta) {
                            float delta = this.tbdelta[e] * 111.19f;
                            Point2D.Double p2d = new Point2D.Double();
                            SphereUtil.filam((double)slat, (double)slon, (double)delta, (double)backAzi, (Point2D)p2d);
                            double elat = ((Point2D)p2d).getX();
                            double elon = ((Point2D)p2d).getY();
                            double tt = ttt.calTravelTime(new double[]{elat, elon, dep}, new double[]{slat, slon, selev}, ph);
                            if (Double.isNaN(tt)) {
                                tt = -1.0;
                            }
                            this.tb3dt[s][p][a][d][e] = (float)tt;
                            ++e;
                        }
                        ++d;
                    }
                    ++a;
                }
                ++p;
            }
            ++s;
        }
    }

    public void addOneStation(String sta, float lat, float lon, float alt) throws IOException {
        TTTDing ttt = new TTTDing();
        this.tbazi = new float[this.maxtbazi];
        this.tbdelta = new float[this.maxtbdelta];
        this.tbdep = new float[this.maxtbdep];
        int i = 0;
        while (i < 72) {
            this.tbazi[i] = i * 5;
            ++i;
        }
        i = 0;
        while (i < this.maxtbdelta) {
            this.tbdelta[i] = 0.1f * (float)i;
            ++i;
        }
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.openExisting((String)this.ncFilename.getAbsolutePath());
        int nsta = ncfile.getUnlimitedDimension().getLength();
        ArrayChar.D2 a_station = new ArrayChar.D2(1, this.maxStaLength);
        Index i_station = a_station.getIndex();
        a_station.setString(i_station.set(0), sta);
        ArrayFloat.D1 a_sta_lat = new ArrayFloat.D1(1);
        Index i_sta_lat = a_sta_lat.getIndex();
        a_sta_lat.setFloat(i_sta_lat.set(0), lat);
        ArrayFloat.D1 a_sta_lon = new ArrayFloat.D1(1);
        Index i_sta_lon = a_sta_lon.getIndex();
        a_sta_lon.setFloat(i_sta_lon.set(0), lon);
        ArrayFloat.D1 a_sta_alt = new ArrayFloat.D1(1);
        Index i_sta_alt = a_sta_alt.getIndex();
        a_sta_alt.setFloat(i_sta_alt.set(0), alt);
        ArrayFloat.D5 a_tbtt = new ArrayFloat.D5(1, this.nphs, this.maxtbazi, this.maxtbdep, this.maxtbdelta);
        Index i_tbtt = a_tbtt.getIndex();
        float slat = lat;
        float slon = lon;
        float selev = alt;
        int p = 0;
        while (p < this.nphs) {
            String ph = this.phs[p];
            int a = 0;
            while (a < this.maxtbazi) {
                float backAzi = this.tbazi[a];
                int d = 0;
                while (d < this.maxtbdep) {
                    float dep = this.tbdep[d];
                    int e = 0;
                    while (e < this.maxtbdelta) {
                        float delta = this.tbdelta[e] * 111.19f;
                        Point2D.Double p2d = new Point2D.Double();
                        SphereUtil.filam((double)slat, (double)slon, (double)delta, (double)backAzi, (Point2D)p2d);
                        double elat = ((Point2D)p2d).getX();
                        double elon = ((Point2D)p2d).getY();
                        double tt = ttt.calTravelTime(new double[]{elat, elon, dep}, new double[]{slat, slon, selev}, ph);
                        if (Double.isNaN(tt)) {
                            tt = -1.0;
                        }
                        a_tbtt.set(i_tbtt.set(0, p, a, d, e), (float)tt);
                        ++e;
                    }
                    ++d;
                }
                ++a;
            }
            ++p;
        }
        int[] o1 = new int[]{nsta};
        int[] nArray = new int[2];
        nArray[0] = nsta;
        int[] o2 = nArray;
        int[] nArray2 = new int[5];
        nArray2[0] = nsta;
        int[] o5 = nArray2;
        try {
            ncfile.write("station", o2, (Array)a_station);
            ncfile.write("tbstalat", o1, (Array)a_sta_lat);
            ncfile.write("tbstalon", o1, (Array)a_sta_lon);
            ncfile.write("tbstaelev", o1, (Array)a_sta_alt);
            ncfile.write("tb3dt", o5, (Array)a_tbtt);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        ncfile.flush();
        ncfile.close();
    }

    public void writeNetCDF() throws Exception {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)this.ncFilename.getAbsolutePath(), (boolean)true);
        Dimension maxStaLengthDim = ncfile.addDimension("maxStaLength", this.maxStaLength);
        Dimension maxPhaseLengthDim = ncfile.addDimension("maxPhaseLength", this.maxPhaseLength);
        Dimension nstaDim = ncfile.addUnlimitedDimension("nsta");
        nstaDim.setLength(this.nsta);
        Dimension nphsDim = ncfile.addDimension("nphs", this.nphs);
        Dimension maxtbaziDim = ncfile.addDimension("maxtbazi", this.maxtbazi);
        Dimension maxtbdepDim = ncfile.addDimension("maxtbdep", this.maxtbdep);
        Dimension maxtbdeltaDim = ncfile.addDimension("maxtbdelta", this.maxtbdelta);
        ncfile.addVariable("station", DataType.CHAR, new Dimension[]{nstaDim, maxStaLengthDim});
        ncfile.addVariable("phase", DataType.CHAR, new Dimension[]{nphsDim, maxPhaseLengthDim});
        ncfile.addVariable("tbstalat", DataType.FLOAT, new Dimension[]{nstaDim});
        ncfile.addVariable("tbstalon", DataType.FLOAT, new Dimension[]{nstaDim});
        ncfile.addVariable("tbstaelev", DataType.FLOAT, new Dimension[]{nstaDim});
        ncfile.addVariable("tbazi", DataType.FLOAT, new Dimension[]{maxtbaziDim});
        ncfile.addVariable("tbdep", DataType.FLOAT, new Dimension[]{maxtbdepDim});
        ncfile.addVariable("tbdelta", DataType.FLOAT, new Dimension[]{maxtbdeltaDim});
        ncfile.addVariable("tb3dt", DataType.FLOAT, new Dimension[]{nstaDim, nphsDim, maxtbaziDim, maxtbdepDim, maxtbdeltaDim});
        ncfile.addVariableAttribute("tb3dt", "_FillValue", (Number)-2);
        ncfile.addVariableAttribute("tb3dt", "missing_value", (Number)-1);
        ncfile.create();
        Variable v = ncfile.findVariable("tb3dt");
        int[] shape = v.getShape();
        Array atbtt = v.read(":,:,:,:,:");
        Index ima = atbtt.getIndex();
        int i = 0;
        while (i < shape[0]) {
            int j = 0;
            while (j < shape[1]) {
                int k = 0;
                while (k < shape[2]) {
                    int m = 0;
                    while (m < shape[3]) {
                        int n = 0;
                        while (n < shape[4]) {
                            atbtt.setFloat(ima.set(i, j, k, m, n), this.tb3dt[i][j][k][m][n]);
                            ++n;
                        }
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int[] origin = new int[5];
        ncfile.write("tb3dt", origin, atbtt);
        v = ncfile.findVariable("station");
        ArrayChar acSta = (ArrayChar)v.read();
        ima = acSta.getIndex();
        i = 0;
        while (i < this.nsta) {
            acSta.setString(i, this.station[i]);
            ++i;
        }
        ncfile.write("station", (Array)acSta);
        v = ncfile.findVariable("phase");
        ArrayChar acPh = (ArrayChar)v.read();
        ima = acPh.getIndex();
        i = 0;
        while (i < this.nphs) {
            acPh.setString(i, this.phs[i]);
            ++i;
        }
        ncfile.write("phase", (Array)acPh);
        v = ncfile.findVariable("tbstalat");
        Array staLat = v.read();
        ima = staLat.getIndex();
        shape = v.getShape();
        i = 0;
        while (i < shape[0]) {
            staLat.setFloat(ima.set(i), this.tbstalat[i]);
            ++i;
        }
        ncfile.write("tbstalat", new int[1], staLat);
        v = ncfile.findVariable("tbstalon");
        Array staLon = v.read();
        ima = staLon.getIndex();
        shape = v.getShape();
        i = 0;
        while (i < shape[0]) {
            staLon.setFloat(ima.set(i), this.tbstalon[i]);
            ++i;
        }
        ncfile.write("tbstalon", new int[1], staLon);
        v = ncfile.findVariable("tbstaelev");
        Array staElev = v.read();
        ima = staElev.getIndex();
        shape = v.getShape();
        i = 0;
        while (i < shape[0]) {
            staElev.setFloat(ima.set(i), this.tbstaelev[i]);
            ++i;
        }
        ncfile.write("tbstaelev", new int[1], staElev);
        v = ncfile.findVariable("tbazi");
        Array acAzi = v.read();
        ima = acAzi.getIndex();
        shape = v.getShape();
        i = 0;
        while (i < shape[0]) {
            acAzi.setFloat(ima.set(i), this.tbazi[i]);
            ++i;
        }
        ncfile.write("tbazi", new int[1], acAzi);
        v = ncfile.findVariable("tbdelta");
        Array acDelta = v.read();
        ima = acDelta.getIndex();
        shape = v.getShape();
        i = 0;
        while (i < shape[0]) {
            acDelta.setFloat(ima.set(i), this.tbdelta[i]);
            ++i;
        }
        ncfile.write("tbdelta", new int[1], acDelta);
        v = ncfile.findVariable("tbdep");
        Array acDep = v.read();
        ima = acDep.getIndex();
        shape = v.getShape();
        i = 0;
        while (i < shape[0]) {
            acDep.setFloat(ima.set(i), this.tbdep[i]);
            ++i;
        }
        ncfile.write("tbdep", new int[1], acDep);
        ncfile.close();
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain((String)"TBTTMgr.properties");
        TBTTMgr ttt3d = new TBTTMgr();
        Options options = new Options();
        Option help = new Option("h", "print this message");
        Option generate = new Option("generate", "Generate travel table");
        OptionBuilder.withArgName((String)"sta lat lon alt");
        OptionBuilder.hasArgs((int)4);
        OptionBuilder.withDescription((String)"sets one station info.");
        Option add = OptionBuilder.create((String)"add");
        OptionGroup operationGroup = new OptionGroup();
        operationGroup.addOption(help).addOption(generate).addOption(add);
        OptionBuilder.withArgName((String)"Station info");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"Station info list file");
        Option station = OptionBuilder.create((String)"sta");
        OptionBuilder.withArgName((String)"NC output file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"NetCDF output file");
        Option ncOut = OptionBuilder.create((String)"nc");
        options.addOption(station).addOption(ncOut).addOptionGroup(operationGroup);
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("TBTTMgr", options);
            System.exit(-1);
        } else if (cmd.hasOption(generate.getOpt()) && cmd.hasOption(ncOut.getOpt()) && cmd.hasOption(station.getOpt())) {
            String ncFile = cmd.getOptionValue(ncOut.getOpt());
            String staFile = cmd.getOptionValue(station.getOpt());
            ttt3d.ncFilename = new File(ncFile);
            ttt3d.staFile = new File(staFile);
            ttt3d.generate();
        } else if (cmd.hasOption(add.getOpt()) && cmd.hasOption(ncOut.getOpt())) {
            String ncFile = cmd.getOptionValue(ncOut.getOpt());
            ttt3d.ncFilename = new File(ncFile);
            String[] addArgs = cmd.getOptionValues(add.getOpt());
            String sta = addArgs[0];
            float lat = Float.parseFloat(addArgs[1]);
            float lon = Float.parseFloat(addArgs[2]);
            float alt = Float.parseFloat(addArgs[3]);
            ttt3d.addOneStation(sta, lat, lon, alt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CTTT
    implements Callable<Boolean> {
        private ComputedTravelTime ttt = new TTTDing();
        private int s;

        @Override
        public Boolean call() {
            float slat = TBTTMgr.this.tbstalat[this.s];
            float slon = TBTTMgr.this.tbstalon[this.s];
            float selev = TBTTMgr.this.tbstaelev[this.s];
            int p = 0;
            while (p < TBTTMgr.this.nphs) {
                String ph = TBTTMgr.this.phs[p];
                int a = 0;
                while (a < TBTTMgr.this.maxtbazi) {
                    float backAzi = TBTTMgr.this.tbazi[a];
                    int d = 0;
                    while (d < TBTTMgr.this.maxtbdep) {
                        float dep = TBTTMgr.this.tbdep[d];
                        int e = 0;
                        while (e < TBTTMgr.this.maxtbdelta) {
                            float delta = TBTTMgr.this.tbdelta[e] * 111.19f;
                            Point2D.Double p2d = new Point2D.Double();
                            SphereUtil.filam((double)slat, (double)slon, (double)delta, (double)backAzi, (Point2D)p2d);
                            double elat = ((Point2D)p2d).getX();
                            double elon = ((Point2D)p2d).getY();
                            double tt = this.ttt.calTravelTime(new double[]{elat, elon, dep}, new double[]{slat, slon, selev}, ph);
                            if (Double.isNaN(tt)) {
                                tt = -1.0;
                            }
                            ((TBTTMgr)TBTTMgr.this).tb3dt[this.s][p][a][d][e] = (float)tt;
                            ++e;
                        }
                        ++d;
                    }
                    ++a;
                }
                ++p;
            }
            System.out.printf("Finished station: %d\n", this.s);
            return true;
        }

        public CTTT(int s) {
            this.s = s;
        }
    }
}

