/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.convert.CatalogueForDB;
import cn.org.gddsn.seis.convert.PhaseForDB;
import cn.org.gddsn.seis.convert.ResFile;
import cn.org.gddsn.seis.convert.StnParForDB;
import cn.org.gddsn.seis.location.StnLocation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ResFileForDB {
    static Logger logger = Logger.getLogger(ResFileForDB.class);
    CatalogueForDB catalogueForDB = new CatalogueForDB();
    StnParForDB[] stnparForDB;
    PhaseForDB[] phaseForDB;

    public CatalogueForDB getCatalogueForDB() {
        return this.catalogueForDB;
    }

    public void setResData(ResFile resFile) {
        SourceParam source = resFile.getOutputInfoForLoc().getSource();
        long t = source.originTime.getTime();
        GregorianCalendar c = new GregorianCalendar();
        Date d = new Date(t);
        c.setTime(d);
        this.catalogueForDB.year = c.get(1);
        this.catalogueForDB.mon = c.get(2) + 1;
        this.catalogueForDB.day = c.get(5);
        this.catalogueForDB.hour = c.get(11);
        this.catalogueForDB.min = c.get(12);
        this.catalogueForDB.sec = (float)c.get(13) + (float)(t % 1000L) / 1000.0f;
        this.catalogueForDB.otime = source.originTime.getTime() / 1000L;
        this.catalogueForDB.lat = (float)source.lat;
        this.catalogueForDB.lon = (float)source.lon;
        this.catalogueForDB.depth = Double.isNaN(source.depth) ? -99999.0f : (float)source.depth;
        this.catalogueForDB.delta = -99999.0f;
        this.catalogueForDB.azimuth = -99999.0f;
        this.catalogueForDB.Ml = (float)source.ml;
        this.catalogueForDB.Md = -99999.0f;
        this.catalogueForDB.Ms = (float)source.ms;
        this.catalogueForDB.Mb = -99999.0f;
        this.catalogueForDB.mB = -99999.0f;
        this.catalogueForDB.Mm = -99999.0f;
        this.catalogueForDB.residual = (float)source.rms;
        this.catalogueForDB.loc_stn = resFile.getInputInfoForLoc().getLocStnSum();
        Vector<Phase>[] stnPhases = resFile.getInputInfoForLoc().getStnPhases();
        int phaNum = 0;
        int i = 0;
        while (i < stnPhases.length) {
            phaNum += stnPhases[i].size();
            ++i;
        }
        this.catalogueForDB.loc_pha = phaNum;
        System.arraycopy("Genetic".getBytes(), 0, this.catalogueForDB.LocPrg, 0, "Genetic".length());
        StnLocation[] stnLocations = resFile.getInputInfoForLoc().getStnLocations();
        this.stnparForDB = new StnParForDB[this.catalogueForDB.loc_stn];
        int i2 = 0;
        while (i2 < this.catalogueForDB.loc_stn) {
            this.stnparForDB[i2] = new StnParForDB();
            System.arraycopy(stnLocations[i2].getSta().getBytes(), 0, this.stnparForDB[i2].name, 0, stnLocations[i2].getSta().length());
            this.stnparForDB[i2].latitude = (float)stnLocations[i2].getLat();
            this.stnparForDB[i2].longitude = (float)stnLocations[i2].getLon();
            this.stnparForDB[i2].altitude = (float)stnLocations[i2].getAlt();
            this.stnparForDB[i2].no1 = -99999;
            this.stnparForDB[i2].state = 2;
            this.stnparForDB[i2].omin = 25;
            this.stnparForDB[i2].osec = 1.0f;
            this.stnparForDB[i2].ts_p = -99999.0f;
            this.stnparForDB[i2].oref = 105.0f;
            this.stnparForDB[i2].x = 302.0f;
            this.stnparForDB[i2].y = 200.0f;
            this.stnparForDB[i2].odis = 0.0f;
            this.stnparForDB[i2].tdis = (float)resFile.getOutputInfoForLoc().getDetailDelta()[i2];
            this.stnparForDB[i2].azimuth1 = -99999.0f;
            this.stnparForDB[i2].incident1 = -99999.0f;
            this.stnparForDB[i2].Ml = (float)resFile.getOutputInfoForLoc().getDetailML()[i2];
            this.stnparForDB[i2].Md = -99999.0f;
            this.stnparForDB[i2].Ms = (float)resFile.getOutputInfoForLoc().getDetailMs()[i2];
            this.stnparForDB[i2].Mb = -99999.0f;
            this.stnparForDB[i2].mB = -99999.0f;
            this.stnparForDB[i2].Mm = -99999.0f;
            ++i2;
        }
        this.phaseForDB = new PhaseForDB[phaNum];
        i2 = 0;
        while (i2 < phaNum) {
            this.phaseForDB[i2] = new PhaseForDB();
            ++i2;
        }
        int order = 0;
        int i3 = 0;
        while (i3 < stnPhases.length) {
            Enumeration<Phase> vectEnum = stnPhases[i3].elements();
            while (vectEnum.hasMoreElements()) {
                Phase next = vectEnum.nextElement();
                System.arraycopy(next.getStationCode().getBytes(), 0, this.phaseForDB[order].StnName, 0, next.getStationCode().length());
                this.phaseForDB[order].StnNum = 0;
                this.phaseForDB[order].origin = 0;
                this.phaseForDB[order].rec_type = 1;
                this.phaseForDB[order].flag = 0;
                System.arraycopy(next.getPhaseName().getBytes(), 0, this.phaseForDB[order].name, 0, next.getPhaseName().length());
                this.phaseForDB[order].CompNo = (short)next.getBelongedChannelID();
                System.arraycopy(next.getChanCode().getBytes(), 0, this.phaseForDB[order].CompName, 0, next.getChanCode().length());
                this.phaseForDB[order].phaType = (short)next.getPhaType();
                if (next.getPhaType() == 0) {
                    this.phaseForDB[order].phaType = (short)2;
                    this.phaseForDB[order].Amp = 0.0f;
                    this.phaseForDB[order].Prd = -0.0f;
                    this.phaseForDB[order].AmpType = -99999;
                } else {
                    this.phaseForDB[order].phaType = 1;
                    this.phaseForDB[order].Amp = (float)next.getAmp();
                    this.phaseForDB[order].Prd = (float)next.getPeriod();
                    this.phaseForDB[order].AmpType = next.getAmpType();
                }
                t = next.getPhaseTime().getTime();
                c = new GregorianCalendar();
                d = new Date(t);
                c.setTime(d);
                this.phaseForDB[order].year = c.get(1);
                this.phaseForDB[order].mon = c.get(2) + 1;
                this.phaseForDB[order].day = c.get(5);
                this.phaseForDB[order].hour = c.get(11);
                this.phaseForDB[order].min = c.get(12);
                this.phaseForDB[order].sec = (float)c.get(13) + (float)(t % 1000L) / 1000.0f;
                if (next.getWsign() == null || next.getWsign().compareTo("") == 0) {
                    this.phaseForDB[order].msign = 0;
                } else if (next.getWsign().compareTo("C") == 0) {
                    this.phaseForDB[order].msign = 1;
                } else if (next.getWsign().compareTo("U") == 0) {
                    this.phaseForDB[order].msign = 1;
                } else if (next.getWsign().compareTo("D") == 0) {
                    this.phaseForDB[order].msign = (byte)-1;
                } else if (next.getWsign().compareTo("R") == 0) {
                    this.phaseForDB[order].msign = (byte)-1;
                }
                if (next.getClarity() == null || next.getClarity().compareTo("") == 0) {
                    this.phaseForDB[order].clar = (byte)2;
                } else if (next.getClarity().compareTo("I") == 0) {
                    this.phaseForDB[order].clar = 0;
                } else if (next.getClarity().compareTo("E") == 0) {
                    this.phaseForDB[order].clar = 1;
                } else if (next.getClarity().compareTo("(") == 0) {
                    this.phaseForDB[order].clar = (byte)3;
                }
                ++order;
            }
            ++i3;
        }
    }

    public void readResFile(String fname) {
        try {
            FileInputStream FileIn = new FileInputStream(fname);
            BufferedInputStream BufferedIn = new BufferedInputStream(FileIn, 4096);
            LittleEndianInputStream DatIn = new LittleEndianInputStream((InputStream)BufferedIn);
            this.catalogueForDB.locnum = DatIn.readInt();
            DatIn.readFully(this.catalogueForDB.name, 0, 28);
            this.catalogueForDB.srcnum = DatIn.readInt();
            DatIn.readFully(this.catalogueForDB.datasrc, 0, 32);
            DatIn.readFully(this.catalogueForDB.NetName, 0, 80);
            this.catalogueForDB.stn_sum = DatIn.readInt();
            this.catalogueForDB.centlat = DatIn.readFloat();
            this.catalogueForDB.centlon = DatIn.readFloat();
            this.catalogueForDB.centalt = DatIn.readFloat();
            this.catalogueForDB.year = DatIn.readInt();
            this.catalogueForDB.mon = DatIn.readInt();
            this.catalogueForDB.day = DatIn.readInt();
            this.catalogueForDB.hour = DatIn.readInt();
            this.catalogueForDB.min = DatIn.readInt();
            this.catalogueForDB.sec = DatIn.readFloat();
            this.catalogueForDB.otime = DatIn.readLong();
            this.catalogueForDB.lat = DatIn.readFloat();
            this.catalogueForDB.lon = DatIn.readFloat();
            this.catalogueForDB.depth = DatIn.readFloat();
            this.catalogueForDB.delta = DatIn.readFloat();
            this.catalogueForDB.azimuth = DatIn.readFloat();
            this.catalogueForDB.x = DatIn.readFloat();
            this.catalogueForDB.y = DatIn.readFloat();
            this.catalogueForDB.wx = DatIn.readInt();
            this.catalogueForDB.wy = DatIn.readInt();
            this.catalogueForDB.Ml = DatIn.readFloat();
            this.catalogueForDB.Md = DatIn.readFloat();
            this.catalogueForDB.Ms = DatIn.readFloat();
            this.catalogueForDB.Mb = DatIn.readFloat();
            this.catalogueForDB.mB = DatIn.readFloat();
            this.catalogueForDB.Mm = DatIn.readFloat();
            this.catalogueForDB.residual = DatIn.readFloat();
            this.catalogueForDB.epic_accu = DatIn.readFloat();
            this.catalogueForDB.depth_accu = DatIn.readFloat();
            this.catalogueForDB.sum_stn = DatIn.readInt();
            this.catalogueForDB.loc_stn = DatIn.readInt();
            this.catalogueForDB.sum_pha = DatIn.readInt();
            this.catalogueForDB.loc_pha = DatIn.readInt();
            this.catalogueForDB.qua_loc = DatIn.readByte();
            this.catalogueForDB.qua_dis = DatIn.readByte();
            this.catalogueForDB.lev_loc = DatIn.readByte();
            this.catalogueForDB.reserved = DatIn.readByte();
            DatIn.readFully(this.catalogueForDB.Operator, 0, 16);
            this.catalogueForDB.EqType = DatIn.readInt();
            DatIn.readFully(this.catalogueForDB.LocPrg, 0, 16);
            DatIn.readFully(this.catalogueForDB.remark, 0, 1024);
            this.stnparForDB = new StnParForDB[this.catalogueForDB.loc_stn];
            int i = 0;
            while (i < this.catalogueForDB.loc_stn) {
                this.stnparForDB[i] = new StnParForDB();
                this.stnparForDB[i].no = DatIn.readInt();
                DatIn.readFully(this.stnparForDB[i].name, 0, 20);
                DatIn.readFully(this.stnparForDB[i].DASType, 0, 10);
                this.stnparForDB[i].wlen = DatIn.readShort();
                this.stnparForDB[i].VLtd = DatIn.readFloat();
                this.stnparForDB[i].samp = DatIn.readInt();
                this.stnparForDB[i].comp = DatIn.readInt();
                this.stnparForDB[i].TranMode = DatIn.readShort();
                DatIn.readFully(this.stnparForDB[i].TranIns, 0, 12);
                this.stnparForDB[i].TimerMode = DatIn.readShort();
                DatIn.readFully(this.stnparForDB[i].ClkType, 0, 12);
                this.stnparForDB[i].ClkErr = DatIn.readFloat();
                this.stnparForDB[i].latitude = DatIn.readFloat();
                this.stnparForDB[i].longitude = DatIn.readFloat();
                this.stnparForDB[i].altitude = DatIn.readFloat();
                this.stnparForDB[i].azimuth = DatIn.readFloat();
                this.stnparForDB[i].incident = DatIn.readFloat();
                this.stnparForDB[i].weight = DatIn.readShort();
                this.stnparForDB[i].vmode = DatIn.readByte();
                this.stnparForDB[i].ttable = DatIn.readByte();
                this.stnparForDB[i].oritype = DatIn.readInt();
                DatIn.readFully(this.stnparForDB[i].seismometer, 0, 8);
                this.stnparForDB[i].SMMode = DatIn.readInt();
                this.stnparForDB[i].no1 = DatIn.readInt();
                this.stnparForDB[i].state = DatIn.readInt();
                this.stnparForDB[i].omin = DatIn.readInt();
                this.stnparForDB[i].osec = DatIn.readFloat();
                this.stnparForDB[i].ts_p = DatIn.readFloat();
                this.stnparForDB[i].oref = DatIn.readFloat();
                this.stnparForDB[i].x = DatIn.readFloat();
                this.stnparForDB[i].y = DatIn.readFloat();
                this.stnparForDB[i].odis = DatIn.readFloat();
                this.stnparForDB[i].tdis = DatIn.readFloat();
                this.stnparForDB[i].azimuth1 = DatIn.readFloat();
                this.stnparForDB[i].incident1 = DatIn.readFloat();
                this.stnparForDB[i].Ml = DatIn.readFloat();
                this.stnparForDB[i].Md = DatIn.readFloat();
                this.stnparForDB[i].Ms = DatIn.readFloat();
                this.stnparForDB[i].Mb = DatIn.readFloat();
                this.stnparForDB[i].mB = DatIn.readFloat();
                this.stnparForDB[i].Mm = DatIn.readFloat();
                ++i;
            }
            this.phaseForDB = new PhaseForDB[this.catalogueForDB.loc_pha];
            i = 0;
            while (i < this.catalogueForDB.loc_pha) {
                this.phaseForDB[i] = new PhaseForDB();
                DatIn.readFully(this.phaseForDB[i].StnName, 0, 20);
                this.phaseForDB[i].StnNum = DatIn.readInt();
                this.phaseForDB[i].origin = DatIn.readInt();
                this.phaseForDB[i].phaType = DatIn.readShort();
                this.phaseForDB[i].rec_type = DatIn.readShort();
                this.phaseForDB[i].flag = DatIn.readInt();
                this.phaseForDB[i].CompNo = DatIn.readInt();
                DatIn.readFully(this.phaseForDB[i].CompName, 0, 8);
                DatIn.readFully(this.phaseForDB[i].name, 0, 8);
                this.phaseForDB[i].year = DatIn.readInt();
                this.phaseForDB[i].mon = DatIn.readInt();
                this.phaseForDB[i].day = DatIn.readInt();
                this.phaseForDB[i].hour = DatIn.readInt();
                this.phaseForDB[i].min = DatIn.readInt();
                this.phaseForDB[i].sec = DatIn.readFloat();
                this.phaseForDB[i].Amp = DatIn.readFloat();
                this.phaseForDB[i].Prd = DatIn.readFloat();
                this.phaseForDB[i].AmpType = DatIn.readInt();
                this.phaseForDB[i].iwht = DatIn.readShort();
                this.phaseForDB[i].msign = DatIn.readByte();
                this.phaseForDB[i].clar = DatIn.readByte();
                this.phaseForDB[i].rwht = DatIn.readFloat();
                this.phaseForDB[i].otra = DatIn.readFloat();
                this.phaseForDB[i].residual = DatIn.readFloat();
                this.phaseForDB[i].ttra = DatIn.readFloat();
                this.phaseForDB[i].rsec = DatIn.readFloat();
                ++i;
            }
            DatIn.close();
            BufferedIn.close();
            FileIn.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void writeResFile(String fname) {
        try {
            FileOutputStream FileOut = new FileOutputStream(fname);
            BufferedOutputStream BufferedOut = new BufferedOutputStream(FileOut, 4096);
            LittleEndianOutputStream DatOut = new LittleEndianOutputStream((OutputStream)BufferedOut);
            DatOut.writeInt(this.catalogueForDB.locnum);
            DatOut.write(this.catalogueForDB.name, 0, 28);
            DatOut.writeInt(this.catalogueForDB.srcnum);
            DatOut.write(this.catalogueForDB.datasrc, 0, 32);
            DatOut.write(this.catalogueForDB.NetName, 0, 80);
            DatOut.writeInt(this.catalogueForDB.stn_sum);
            DatOut.writeFloat(this.catalogueForDB.centlat);
            DatOut.writeFloat(this.catalogueForDB.centlon);
            DatOut.writeFloat(this.catalogueForDB.centalt);
            DatOut.writeInt(this.catalogueForDB.year);
            DatOut.writeInt(this.catalogueForDB.mon);
            DatOut.writeInt(this.catalogueForDB.day);
            DatOut.writeInt(this.catalogueForDB.hour);
            DatOut.writeInt(this.catalogueForDB.min);
            DatOut.writeFloat(this.catalogueForDB.sec);
            DatOut.writeLong(this.catalogueForDB.otime);
            DatOut.writeFloat(this.catalogueForDB.lat);
            DatOut.writeFloat(this.catalogueForDB.lon);
            DatOut.writeFloat(this.catalogueForDB.depth);
            DatOut.writeFloat(this.catalogueForDB.delta);
            DatOut.writeFloat(this.catalogueForDB.azimuth);
            DatOut.writeFloat(this.catalogueForDB.x);
            DatOut.writeFloat(this.catalogueForDB.y);
            DatOut.writeInt(this.catalogueForDB.wx);
            DatOut.writeInt(this.catalogueForDB.wy);
            DatOut.writeFloat(this.catalogueForDB.Ml);
            DatOut.writeFloat(this.catalogueForDB.Md);
            DatOut.writeFloat(this.catalogueForDB.Ms);
            DatOut.writeFloat(this.catalogueForDB.Mb);
            DatOut.writeFloat(this.catalogueForDB.mB);
            DatOut.writeFloat(this.catalogueForDB.Mm);
            DatOut.writeFloat(this.catalogueForDB.residual);
            DatOut.writeFloat(this.catalogueForDB.epic_accu);
            DatOut.writeFloat(this.catalogueForDB.depth_accu);
            DatOut.writeInt(this.catalogueForDB.sum_stn);
            DatOut.writeInt(this.catalogueForDB.loc_stn);
            DatOut.writeInt(this.catalogueForDB.sum_pha);
            DatOut.writeInt(this.catalogueForDB.loc_pha);
            DatOut.writeByte((int)this.catalogueForDB.qua_loc);
            DatOut.writeByte((int)this.catalogueForDB.qua_dis);
            DatOut.writeByte((int)this.catalogueForDB.lev_loc);
            DatOut.writeByte((int)this.catalogueForDB.reserved);
            DatOut.write(this.catalogueForDB.Operator, 0, 16);
            DatOut.writeInt(this.catalogueForDB.EqType);
            DatOut.write(this.catalogueForDB.LocPrg, 0, 16);
            DatOut.write(this.catalogueForDB.remark, 0, 1024);
            int i = 0;
            while (i < this.catalogueForDB.loc_stn) {
                DatOut.writeInt(this.stnparForDB[i].no);
                DatOut.write(this.stnparForDB[i].name, 0, 20);
                DatOut.write(this.stnparForDB[i].DASType, 0, 10);
                DatOut.writeShort((int)this.stnparForDB[i].wlen);
                DatOut.writeFloat(this.stnparForDB[i].VLtd);
                DatOut.writeInt(this.stnparForDB[i].samp);
                DatOut.writeInt(this.stnparForDB[i].comp);
                DatOut.writeShort((int)this.stnparForDB[i].TranMode);
                DatOut.write(this.stnparForDB[i].TranIns, 0, 12);
                DatOut.writeShort((int)this.stnparForDB[i].TimerMode);
                DatOut.write(this.stnparForDB[i].ClkType, 0, 12);
                DatOut.writeFloat(this.stnparForDB[i].ClkErr);
                DatOut.writeFloat(this.stnparForDB[i].latitude);
                DatOut.writeFloat(this.stnparForDB[i].longitude);
                DatOut.writeFloat(this.stnparForDB[i].altitude);
                DatOut.writeFloat(this.stnparForDB[i].azimuth);
                DatOut.writeFloat(this.stnparForDB[i].incident);
                DatOut.writeShort((int)this.stnparForDB[i].weight);
                DatOut.writeByte((int)this.stnparForDB[i].vmode);
                DatOut.writeByte((int)this.stnparForDB[i].ttable);
                DatOut.writeInt(this.stnparForDB[i].oritype);
                DatOut.write(this.stnparForDB[i].seismometer, 0, 8);
                DatOut.writeInt(this.stnparForDB[i].SMMode);
                DatOut.writeInt(this.stnparForDB[i].no1);
                DatOut.writeInt(this.stnparForDB[i].state);
                DatOut.writeInt(this.stnparForDB[i].omin);
                DatOut.writeFloat(this.stnparForDB[i].osec);
                DatOut.writeFloat(this.stnparForDB[i].ts_p);
                DatOut.writeFloat(this.stnparForDB[i].oref);
                DatOut.writeFloat(this.stnparForDB[i].x);
                DatOut.writeFloat(this.stnparForDB[i].y);
                DatOut.writeFloat(this.stnparForDB[i].odis);
                DatOut.writeFloat(this.stnparForDB[i].tdis);
                DatOut.writeFloat(this.stnparForDB[i].azimuth1);
                DatOut.writeFloat(this.stnparForDB[i].incident1);
                DatOut.writeFloat(this.stnparForDB[i].Ml);
                DatOut.writeFloat(this.stnparForDB[i].Md);
                DatOut.writeFloat(this.stnparForDB[i].Ms);
                DatOut.writeFloat(this.stnparForDB[i].Mb);
                DatOut.writeFloat(this.stnparForDB[i].mB);
                DatOut.writeFloat(this.stnparForDB[i].Mm);
                ++i;
            }
            i = 0;
            while (i < this.catalogueForDB.loc_pha) {
                DatOut.write(this.phaseForDB[i].StnName, 0, 20);
                DatOut.writeInt(this.phaseForDB[i].StnNum);
                DatOut.writeInt(this.phaseForDB[i].origin);
                DatOut.writeShort((int)this.phaseForDB[i].phaType);
                DatOut.writeShort((int)this.phaseForDB[i].rec_type);
                DatOut.writeInt(this.phaseForDB[i].flag);
                DatOut.writeInt(this.phaseForDB[i].CompNo);
                DatOut.write(this.phaseForDB[i].CompName, 0, 8);
                DatOut.write(this.phaseForDB[i].name, 0, 8);
                DatOut.writeInt(this.phaseForDB[i].year);
                DatOut.writeInt(this.phaseForDB[i].mon);
                DatOut.writeInt(this.phaseForDB[i].day);
                DatOut.writeInt(this.phaseForDB[i].hour);
                DatOut.writeInt(this.phaseForDB[i].min);
                DatOut.writeFloat(this.phaseForDB[i].sec);
                DatOut.writeFloat(this.phaseForDB[i].Amp);
                DatOut.writeFloat(this.phaseForDB[i].Prd);
                DatOut.writeInt(this.phaseForDB[i].AmpType);
                DatOut.writeShort((int)this.phaseForDB[i].iwht);
                DatOut.writeByte((int)this.phaseForDB[i].msign);
                DatOut.writeByte((int)this.phaseForDB[i].clar);
                DatOut.writeFloat(this.phaseForDB[i].rwht);
                DatOut.writeFloat(this.phaseForDB[i].otra);
                DatOut.writeFloat(this.phaseForDB[i].residual);
                DatOut.writeFloat(this.phaseForDB[i].ttra);
                DatOut.writeFloat(this.phaseForDB[i].rsec);
                ++i;
            }
            DatOut.flush();
            BufferedOut.flush();
            FileOut.flush();
            DatOut.close();
            BufferedOut.close();
            FileOut.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        ResFileForDB resFileDB = new ResFileForDB();
        resFileDB.readResFile("/tmp/pha/BMPHA_BAK/830808061337.0.0.pha");
        System.out.println("ok");
    }
}

