/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.seis.location.InputInfoForLoc;
import cn.org.gddsn.seis.location.OutputInfoForLoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;

public class ResFile
implements Serializable,
Comparable {
    static Logger logger = Logger.getLogger(ResFile.class);
    static final long serialVersionUID = 6998920899305263464L;
    private InputInfoForLoc inputInfoForLoc;
    private OutputInfoForLoc outputInfoForLoc;

    public void setResFileData(InputInfoForLoc inputInfoForLoc, OutputInfoForLoc outputInfoForLoc) {
        this.inputInfoForLoc = inputInfoForLoc;
        this.outputInfoForLoc = outputInfoForLoc;
    }

    public void setInputInfoForLoc(InputInfoForLoc newInputInfoForLoc) {
        this.inputInfoForLoc = newInputInfoForLoc;
    }

    public InputInfoForLoc getInputInfoForLoc() {
        return this.inputInfoForLoc;
    }

    public void setOutputInfoForLoc(OutputInfoForLoc newOutputInfoForLoc) {
        this.outputInfoForLoc = newOutputInfoForLoc;
    }

    public OutputInfoForLoc getOutputInfoForLoc() {
        return this.outputInfoForLoc;
    }

    public static ResFile loadResFile(String fileName) {
        ResFile ret = null;
        try {
            FileInputStream In = new FileInputStream(fileName);
            BufferedInputStream BufferedIn = new BufferedInputStream(In, 4096);
            ObjectInputStream ois = new ObjectInputStream(BufferedIn);
            ret = (ResFile)ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            logger.warn((Object)("Trouble reading " + fileName), (Throwable)ex);
            ret = null;
        }
        return ret;
    }

    public static boolean saveResFile(ResFile resFile, String fileName) {
        boolean ret = false;
        try {
            FileOutputStream Out = new FileOutputStream(fileName);
            BufferedOutputStream BufferedOut = new BufferedOutputStream(Out, 4096);
            ObjectOutputStream oos = new ObjectOutputStream(BufferedOut);
            oos.writeObject(resFile);
            oos.flush();
            BufferedOut.close();
            Out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            ret = false;
        }
        return ret;
    }

    public int compareTo(Object o) {
        ResFile res = (ResFile)o;
        Date thisDate = this.getOutputInfoForLoc() == null ? this.getInputInfoForLoc().getStnPhases()[0].elementAt(0).getPhaseTime() : this.getOutputInfoForLoc().getSource().originTime;
        Date anDate = res.getOutputInfoForLoc() == null ? res.getInputInfoForLoc().getStnPhases()[0].elementAt(0).getPhaseTime() : res.getOutputInfoForLoc().getSource().originTime;
        return thisDate.compareTo(anDate);
    }
}

