/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class Old2NetCDF {
    static Logger logger = Logger.getLogger(Old2NetCDF.class);
    int ttTableColumSum;
    int ttTableRowSum;
    int ttDepthSum;
    int[] ndelta;
    double[][][] ttTable;
    double[] depth;
    String[][] phaseName = null;

    void readTable(String fname) {
        try {
            BufferedReader ds = new BufferedReader(new FileReader(fname));
            String lineStr = ds.readLine();
            StringTokenizer st = new StringTokenizer(lineStr);
            this.ttDepthSum = Integer.parseInt(st.nextToken());
            lineStr = ds.readLine();
            st = new StringTokenizer(lineStr);
            this.ttTableRowSum = Integer.parseInt(st.nextToken());
            lineStr = ds.readLine();
            st = new StringTokenizer(lineStr);
            this.ttTableColumSum = Integer.parseInt(st.nextToken());
            this.ttTable = new double[this.ttDepthSum][this.ttTableRowSum][this.ttTableColumSum];
            this.depth = new double[this.ttDepthSum];
            this.phaseName = new String[this.ttDepthSum][this.ttTableColumSum];
            this.ndelta = new int[this.ttTableColumSum];
            int i = 0;
            while (i < this.ttDepthSum) {
                int j = 0;
                while (j < this.ttTableRowSum) {
                    int k = 0;
                    while (k < this.ttTableColumSum) {
                        this.ttTable[i][j][k] = -1.0;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.ttDepthSum) {
                lineStr = ds.readLine();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("reading line: " + lineStr));
                }
                st = new StringTokenizer(lineStr);
                int row = Integer.parseInt(st.nextToken());
                lineStr = ds.readLine();
                st = new StringTokenizer(lineStr);
                int colume = Integer.parseInt(st.nextToken());
                lineStr = ds.readLine();
                st = new StringTokenizer(lineStr);
                this.depth[i] = Double.valueOf(st.nextToken());
                lineStr = ds.readLine();
                st = new StringTokenizer(lineStr);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("reading phase name: " + lineStr));
                }
                int k = 0;
                while (k < colume) {
                    this.phaseName[i][k] = st.nextToken();
                    this.ndelta[k] = row;
                    ++k;
                }
                int j = 0;
                while (j < row) {
                    lineStr = ds.readLine();
                    st = new StringTokenizer(lineStr);
                    int k2 = 0;
                    while (k2 < colume) {
                        int n = this.idx(i, k2);
                        if (n != k2) {
                            System.out.printf("depth=%f, phase=%s, %d->%d\n", this.depth[i], this.phaseName[i][k2], k2, n);
                        }
                        this.ttTable[i][j][n] = Double.valueOf(st.nextToken());
                        ++k2;
                    }
                    ++j;
                }
                ++i;
            }
            ds.close();
        }
        catch (IOException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    private int idx(int i, int k) {
        String pn = this.phaseName[i][k];
        int n = 0;
        while (n < this.phaseName[0].length) {
            if (pn.equals(this.phaseName[0][n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void writeNetCDF(String ncFile) throws Exception {
        int j;
        int j2;
        int nphs = this.phaseName[0].length - 1;
        String[] phs = new String[nphs];
        int i = 0;
        while (i < nphs) {
            phs[i] = this.phaseName[0][i + 1];
            ++i;
        }
        int[] ntbd = new int[nphs];
        int[] ntbz = new int[nphs];
        int maxtbz = this.depth.length;
        int maxtbd = this.ttTableRowSum;
        float[][] tbz = new float[nphs][maxtbz];
        float[][] tbd = new float[nphs][maxtbd];
        float[][][] tbtt = new float[nphs][maxtbz][maxtbd];
        int i2 = 0;
        while (i2 < ntbd.length) {
            ntbd[i2] = -2;
            ++i2;
        }
        i2 = 0;
        while (i2 < ntbz.length) {
            ntbz[i2] = -2;
            ++i2;
        }
        i2 = 0;
        while (i2 < nphs) {
            j2 = 0;
            while (j2 < maxtbz) {
                tbz[i2][j2] = -2.0f;
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nphs) {
            j2 = 0;
            while (j2 < maxtbd) {
                tbd[i2][j2] = -2.0f;
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nphs) {
            j2 = 0;
            while (j2 < maxtbz) {
                int k = 0;
                while (k < maxtbd) {
                    tbtt[i2][j2][k] = -2.0f;
                    ++k;
                }
                ++j2;
            }
            ++i2;
        }
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)ncFile, (boolean)false);
        Dimension nphsDim = ncfile.addDimension("nphs", nphs);
        Dimension maxtbzDim = ncfile.addDimension("maxtbz", maxtbz);
        Dimension maxtbdDim = ncfile.addDimension("maxtbd", maxtbd);
        Dimension maxPhaseLengthDim = ncfile.addDimension("maxPhaseLength", 8);
        ArrayList<Dimension> nphsDims = new ArrayList<Dimension>();
        nphsDims.add(nphsDim);
        nphsDims.add(maxPhaseLengthDim);
        ncfile.addVariable("phase", DataType.CHAR, nphsDims);
        ArrayList<Dimension> ntbzDims = new ArrayList<Dimension>();
        ntbzDims.add(nphsDim);
        ncfile.addVariable("ntbz", DataType.INT, ntbzDims);
        ArrayList<Dimension> ntbdDims = new ArrayList<Dimension>();
        ntbdDims.add(nphsDim);
        ncfile.addVariable("ntbd", DataType.INT, ntbdDims);
        ArrayList<Dimension> tbzDims = new ArrayList<Dimension>();
        tbzDims.add(nphsDim);
        tbzDims.add(maxtbzDim);
        ncfile.addVariable("tbz", DataType.FLOAT, tbzDims);
        ArrayList<Dimension> tbdDims = new ArrayList<Dimension>();
        tbdDims.add(nphsDim);
        tbdDims.add(maxtbdDim);
        ncfile.addVariable("tbd", DataType.FLOAT, tbdDims);
        ArrayList<Dimension> tbttDims = new ArrayList<Dimension>();
        tbttDims.add(nphsDim);
        tbttDims.add(maxtbzDim);
        tbttDims.add(maxtbdDim);
        ncfile.addVariable("tbtt", DataType.FLOAT, tbttDims);
        ncfile.create();
        ArrayChar.D2 ac2 = new ArrayChar.D2(nphs, 8);
        int i3 = 0;
        while (i3 < nphs) {
            ac2.setString(i3, phs[i3]);
            ++i3;
        }
        ncfile.write("phase", (Array)ac2);
        ArrayInt.D1 a_ntbz = new ArrayInt.D1(nphs);
        int i4 = 0;
        while (i4 < nphs) {
            a_ntbz.setInt(i4, this.depth.length);
            ++i4;
        }
        ncfile.write("ntbz", (Array)a_ntbz);
        ArrayInt.D1 a_ntbd = new ArrayInt.D1(nphs);
        int i5 = 0;
        while (i5 < nphs) {
            a_ntbd.setInt(i5, this.ndelta[i5 + 1]);
            ++i5;
        }
        ncfile.write("ntbd", (Array)a_ntbd);
        ArrayFloat.D2 a_tbz = new ArrayFloat.D2(nphs, maxtbz);
        Index ima = a_tbz.getIndex();
        int i6 = 0;
        while (i6 < nphs) {
            j = 0;
            while (j < maxtbz) {
                a_tbz.setFloat(ima.set(i6, j), (float)this.depth[j]);
                ++j;
            }
            ++i6;
        }
        ncfile.write("tbz", (Array)a_tbz);
        ArrayFloat.D2 a_tbd = new ArrayFloat.D2(nphs, maxtbd);
        ima = a_tbd.getIndex();
        i6 = 0;
        while (i6 < nphs) {
            j = 0;
            while (j < maxtbd) {
                a_tbd.setFloat(ima.set(i6, j), (float)this.ttTable[0][j][0]);
                ++j;
            }
            ++i6;
        }
        ncfile.write("tbd", (Array)a_tbd);
        ArrayFloat.D3 a_tbtt = new ArrayFloat.D3(nphs, maxtbz, maxtbd);
        ima = a_tbtt.getIndex();
        i6 = 0;
        while (i6 < nphs) {
            j = 0;
            while (j < maxtbz) {
                int k = 0;
                while (k < maxtbd) {
                    a_tbtt.setFloat(ima.set(i6, j, k), (float)this.ttTable[j][k][i6 + 1]);
                    ++k;
                }
                ++j;
            }
            ++i6;
        }
        ncfile.write("tbtt", (Array)a_tbtt);
        ncfile.close();
    }

    public static void main(String[] args) throws Exception {
        Old2NetCDF ttt3d = new Old2NetCDF();
        ttt3d.readTable("/tmp/dd20/my.tab");
        ttt3d.writeNetCDF("/tmp/dd20/southChina.nc");
    }
}

