/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.seis.Phase;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import javolution.io.Struct;
import org.apache.log4j.Logger;

public class EdasPhase {
    public static final int AT = 2;
    public static final int MA = 1;
    public static final int FM = 0;
    public static final float Vp = 6.2f;
    public static final float Vs = 3.57f;
    static Logger logger = Logger.getLogger(EdasPhase.class);
    private static String[] pns = new String[]{"PG", "PN", "P11", "SG", "SN", "S11", "P", "S", "LG1", "LG2"};
    private static String[] _pns = new String[]{"Pg", "Pn", "PmP", "Sg", "Sn", "SmS", "P", "S", "Lg1", "Lg2"};

    public static PHA readPha(File phaFile) throws IOException {
        logger.info((Object)("process " + phaFile));
        PHA pha = new PHA();
        pha.phaFile = phaFile.getAbsolutePath();
        DataInputStream dis = new DataInputStream(new FileInputStream(phaFile));
        pha.netpar.readFully(dis);
        int nsta = pha.netpar.stn_sum.get();
        int i = 0;
        while (i < nsta) {
            STN_PHASE stn_phase = new STN_PHASE();
            stn_phase.stn_par = new STN_PAR();
            stn_phase.stn_par.readFully(dis);
            pha.stn_phase_list.add(stn_phase);
            ++i;
        }
        while (true) {
            PHASE p = new PHASE();
            try {
                p.readFully(dis);
            }
            catch (EOFException eof) {
                break;
            }
            STN_PHASE sp = pha.get_stn_phase(p.stnName.get());
            sp.phaList.add(p);
        }
        dis.close();
        return pha;
    }

    private static String getGoodName(String name) {
        int i = 0;
        while (i < pns.length) {
            if (name.equals(pns[i])) {
                return _pns[i];
            }
            ++i;
        }
        return name;
    }

    public static void main(String[] args) throws Exception {
        EdasPhase.readPha(new File("/tmp/pha/BMPHA_BAK/570808062332.57.0.pha"));
        System.out.println();
    }

    public static class DTIME
    extends Struct {
        public final Struct.Signed32 year = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 month = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 day = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 hour = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 min = new Struct.Signed32((Struct)this);
        public final Struct.Float32 sec = new Struct.Float32((Struct)this);
        public final Struct.Float64 fdt = new Struct.Float64((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class EFFECT
    extends Struct {
        public final Struct.Float32 residual = new Struct.Float32((Struct)this);
        public final Struct.Float32 epic_accu = new Struct.Float32((Struct)this);
        public final Struct.Float32 depth_accu = new Struct.Float32((Struct)this);
        public final Struct.Signed32 sum_stn = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 loc_stn = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 sum_pha = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 loc_pha = new Struct.Signed32((Struct)this);
        public final Struct.Float32 mB = new Struct.Float32((Struct)this);
        public final Struct.Utf8String qua_loc = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Utf8String qua_dis = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Utf8String lev_loc = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Utf8String reserved = new Struct.Utf8String((Struct)this, 1);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class EPIC
    extends Struct {
        public final Struct.Float32 lat = new Struct.Float32((Struct)this);
        public final Struct.Float32 lon = new Struct.Float32((Struct)this);
        public final Struct.Float32 depth = new Struct.Float32((Struct)this);
        public final Struct.Float32 delta = new Struct.Float32((Struct)this);
        public final Struct.Float32 azimuth = new Struct.Float32((Struct)this);
        public final Struct.Float32 x = new Struct.Float32((Struct)this);
        public final Struct.Float32 y = new Struct.Float32((Struct)this);
        public final Struct.Signed32 wx = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 wy = new Struct.Signed32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class EQLOCRES
    extends Struct {
        public final Struct.Signed32 locnum = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 28);
        public final Struct.Signed32 srcnum = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String datasrc = new Struct.Utf8String((Struct)this, 32);
        public final NETPAR netpar = (NETPAR)this.inner(new NETPAR());
        public final DTIME otime = (DTIME)this.inner(new DTIME());
        public final EPIC epic = (EPIC)this.inner(new EPIC());
        public final MAGI mag = (MAGI)this.inner(new MAGI());
        public final EFFECT eff = (EFFECT)this.inner(new EFFECT());
        public final Struct.Utf8String username = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Signed32 EqType = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String LocPrg = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String remark = new Struct.Utf8String((Struct)this, 1024);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class MAGI
    extends Struct {
        public final Struct.Float32 Ml = new Struct.Float32((Struct)this);
        public final Struct.Float32 Md = new Struct.Float32((Struct)this);
        public final Struct.Float32 Ms = new Struct.Float32((Struct)this);
        public final Struct.Float32 Mb = new Struct.Float32((Struct)this);
        public final Struct.Float32 mB = new Struct.Float32((Struct)this);
        public final Struct.Float32 Mm = new Struct.Float32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class NETPAR
    extends Struct {
        public final Struct.Utf8String netName = new Struct.Utf8String((Struct)this, 80);
        public final Struct.Signed32 stn_sum = new Struct.Signed32((Struct)this);
        public final Struct.Float32 centlat = new Struct.Float32((Struct)this);
        public final Struct.Float32 centlon = new Struct.Float32((Struct)this);
        public final Struct.Float32 centalt = new Struct.Float32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class PHA {
        public String phaFile = null;
        public final NETPAR netpar = new NETPAR();
        public List<STN_PHASE> stn_phase_list = new LinkedList<STN_PHASE>();

        public STN_PAR getStaPar(String sta) {
            STN_PAR sp = null;
            for (STN_PHASE s : this.stn_phase_list) {
                if (!s.stn_par.name.get().equals(sta)) continue;
                sp = s.stn_par;
                break;
            }
            return sp;
        }

        public STN_PHASE get_stn_phase(String sta) {
            STN_PHASE sp = null;
            for (STN_PHASE s : this.stn_phase_list) {
                if (!s.stn_par.name.get().equals(sta)) continue;
                sp = s;
                break;
            }
            return sp;
        }
    }

    public static class PHASE
    extends Struct {
        public final Struct.Utf8String stnName = new Struct.Utf8String((Struct)this, 20);
        public final Struct.Signed32 stnNum = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 origin = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 phaType = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 recType = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 flag = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 CompNo = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String CompName = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Signed32 year = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 month = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 day = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 hour = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 min = new Struct.Signed32((Struct)this);
        public final Struct.Float32 sec = new Struct.Float32((Struct)this);
        public final Struct.Float32 amp = new Struct.Float32((Struct)this);
        public final Struct.Float32 prd = new Struct.Float32((Struct)this);
        public final Struct.Signed32 ampType = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 iwht = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String msign = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Utf8String clar = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Float32 rwht = new Struct.Float32((Struct)this);
        public final Struct.Float32 otra = new Struct.Float32((Struct)this);
        public final Struct.Float32 residual = new Struct.Float32((Struct)this);
        public final Struct.Float32 ttra = new Struct.Float32((Struct)this);
        public final Struct.Float32 rsec = new Struct.Float32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public Phase toPhase(String netCode) {
            Phase p = new Phase();
            short pt = this.phaType.get();
            if (pt == 2) {
                p.setPhaType(0);
            } else {
                p.setPhaType(1);
            }
            p.setAmp(this.amp.get());
            p.setAmpType(this.ampType.get());
            p.setAzimuth(-99999.0f);
            p.setBelongedChannelID(0);
            if (this.CompNo.get() == 0) {
                p.setChanCode("BHZ");
            } else if (this.CompNo.get() == 1) {
                p.setChanCode("BHE");
            } else {
                p.setChanCode("BHN");
            }
            p.setClarity(this.clar.get());
            p.setIncident(-99999.0);
            p.setInstrumentName("DD-1");
            p.setLocId("00");
            p.setMagVal(-99999.0f);
            p.setMagName("Ml");
            p.setNetCode(netCode);
            p.setPeriod(this.prd.get());
            p.setPhaseName(EdasPhase.getGoodName(this.name.get()));
            if (this.recType.get() == 0) {
                p.setProcessType('D');
            } else if (this.recType.get() == 1) {
                p.setProcessType('V');
            } else {
                p.setProcessType('A');
            }
            GregorianCalendar g = new GregorianCalendar();
            g.set(this.year.get(), this.month.get() - 1, this.day.get(), this.hour.get(), this.min.get(), 0);
            long ms = g.getTime().getTime() / 1000L * 1000L + (long)this.sec.get() * 1000L;
            p.setPhaseTime(new Date(ms));
            p.setRecType(this.recType.get());
            if (Double.isNaN(this.residual.get())) {
                p.setResi(-99999.0f);
            } else {
                p.setResi(this.residual.get());
            }
            p.setSnr(-99999.0);
            p.setStationCode(this.stnName.get());
            p.setWaveType(this.origin.get());
            p.setWeight(1);
            p.setWsign(this.msign.get());
            return p;
        }
    }

    public static class SDY_PAR
    extends Struct {
        public final Struct.Signed32 no = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 state = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 omin = new Struct.Signed32((Struct)this);
        public final Struct.Float32 osec = new Struct.Float32((Struct)this);
        public final Struct.Float32 ts_p = new Struct.Float32((Struct)this);
        public final Struct.Float32 oref = new Struct.Float32((Struct)this);
        public final Struct.Float32 x = new Struct.Float32((Struct)this);
        public final Struct.Float32 y = new Struct.Float32((Struct)this);
        public final Struct.Float32 odis = new Struct.Float32((Struct)this);
        public final Struct.Float32 tdis = new Struct.Float32((Struct)this);
        public final Struct.Float32 azi = new Struct.Float32((Struct)this);
        public final Struct.Float32 inc = new Struct.Float32((Struct)this);
        public final MAGI mag = (MAGI)this.inner(new MAGI());

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class STN_PAR
    extends Struct {
        public final Struct.Signed32 no = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 20);
        public final Struct.Utf8String DASType = new Struct.Utf8String((Struct)this, 10);
        public final Struct.Signed16 wlen = new Struct.Signed16((Struct)this);
        public final Struct.Float32 VLtd = new Struct.Float32((Struct)this);
        public final Struct.Signed32 samp = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 comp = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 TranMode = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String TranIns = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Signed16 TimerMode = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String ClkType = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Float32 ClkErr = new Struct.Float32((Struct)this);
        public final Struct.Float32 lat = new Struct.Float32((Struct)this);
        public final Struct.Float32 lon = new Struct.Float32((Struct)this);
        public final Struct.Float32 alt = new Struct.Float32((Struct)this);
        public final Struct.Float32 azimuth = new Struct.Float32((Struct)this);
        public final Struct.Float32 incident = new Struct.Float32((Struct)this);
        public final Struct.Signed16 weight = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String vmode = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Utf8String ttable = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Signed32 OriType = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String seismometer = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Signed32 smode = new Struct.Signed32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class STN_PHASE {
        public STN_PAR stn_par;
        public List<PHASE> phaList = new LinkedList<PHASE>();
        private List<Phase> list = null;

        public List<Phase> toPhases(String netCode) {
            if (this.list != null) {
                return this.list;
            }
            this.list = new LinkedList<Phase>();
            for (PHASE p : this.phaList) {
                this.list.add(p.toPhase(netCode));
            }
            return this.list;
        }
    }
}

