/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.seis.convert.Catalog2HypoDDPhase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Bul2Catalog {
    static Logger logger = Logger.getLogger(Bul2Catalog.class);
    private static String[] pns = new String[]{"PG", "PN", "P11", "SG", "SN", "S11", "P", "S"};
    private static String[] _pns = new String[]{"Pg", "Pn", "PmP", "Sg", "Sn", "SmS", "P", "S"};

    public Catalog readBul(File bul) throws Exception {
        Catalog c = new Catalog();
        c.setMags(new HashSet());
        c.setPhases(new LinkedList());
        c.setId(bul.getName());
        BufferedReader br = new BufferedReader(new FileReader(bul));
        String line = null;
        StringTokenizer st = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS");
        String strD = null;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (line.contains("Origin Time")) {
                st = new StringTokenizer(line);
                st.nextToken();
                st.nextToken();
                st.nextToken();
                strD = st.nextToken().trim();
                String strT = String.valueOf(st.nextToken().trim()) + "0";
                c.setFullOriginTime(sdf.parse(String.valueOf(strD) + " " + strT));
            }
            if (line.contains("Epicentre   ")) {
                st = new StringTokenizer(line, " :d'()");
                st.nextToken();
                float lat = (float)Integer.parseInt(st.nextToken()) + Float.parseFloat(st.nextToken()) / 60.0f;
                if (!st.nextToken().equals("N")) {
                    lat *= -1.0f;
                }
                c.setLat(lat);
                float lon = (float)Integer.parseInt(st.nextToken()) + Float.parseFloat(st.nextToken()) / 60.0f;
                if (!st.nextToken().equals("E")) {
                    lon *= -1.0f;
                }
                c.setLon(lon);
            }
            if (line.contains("Magnitude")) {
                st = new StringTokenizer(line, " :()");
                st.nextToken();
                float ml = Float.parseFloat(st.nextToken());
                Mag m = new Mag();
                m.setMagVal(ml);
                MagType ML = new MagType();
                ML.setId("ML");
                m.setMagType(ML);
                c.getMags().add(m);
                st.nextToken();
                if (st.hasMoreTokens()) {
                    float ms = Float.parseFloat(st.nextToken());
                    m = new Mag();
                    m.setMagVal(ms);
                    MagType Ms = new MagType();
                    Ms.setId("Ms");
                    m.setMagType(Ms);
                    st.nextToken();
                    c.getMags().add(m);
                }
            }
            if (line.contains("Focal Depth")) {
                st = new StringTokenizer(line, " :()");
                st.nextToken();
                st.nextToken();
                c.setDepth(Float.parseFloat(st.nextToken()));
                st.nextToken();
                st.nextToken();
                c.setRms(Float.parseFloat(st.nextToken()));
            }
            if (line.contains("Number of Used Phases")) {
                st = new StringTokenizer(line, " :");
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                c.setSumPha(Integer.parseInt(st.nextToken()));
                st.nextToken();
                st.nextToken();
                st.nextToken();
                c.setLocStn(Integer.parseInt(st.nextToken()));
            }
            if (line.contains("Epicentre Accuracy")) {
                st = new StringTokenizer(line, " :()");
                st.nextToken();
                st.nextToken();
                try {
                    float erh = Float.parseFloat(st.nextToken());
                    c.setErh(erh);
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    if (st.hasMoreTokens()) {
                        c.setErz(Float.parseFloat(st.nextToken()));
                    }
                }
                catch (NumberFormatException erh) {
                    // empty catch block
                }
            }
            if (line.contains("No Stn")) break;
        }
        br.readLine();
        boolean idLine = true;
        String fw = null;
        String lw = null;
        String sta = null;
        String phase = null;
        while ((line = br.readLine()) != null) {
            String w;
            if (line.startsWith(".........")) break;
            st = new StringTokenizer(line);
            try {
                fw = st.nextToken();
                if (fw.equals("N") || fw.equals("E")) continue;
                Integer.parseInt(new String(fw).replace('*', '0'));
                idLine = true;
                sta = st.nextToken();
                phase = st.nextToken();
            }
            catch (Exception ex) {
                idLine = false;
                phase = fw;
            }
            if (phase.endsWith("Z") || phase.endsWith("LE") || phase.endsWith("LN")) continue;
            String pn = this.getGoodName(phase);
            if (pn == null) {
                logger.warn((Object)("Could not match " + phase + ", ignore line: " + line));
                continue;
            }
            Phase p = new Phase();
            p.setPhaseName(pn);
            p.setClarity("");
            p.setWsign("");
            if (phase.charAt(0) == 'E' || phase.charAt(0) == 'I') {
                p.setClarity(phase.substring(0, 1));
            }
            if ((w = phase.substring(phase.length() - 1)).equals("C") || w.equals("D") || w.equals("U") || w.equals("R")) {
                p.setWsign(w);
            }
            p.setChannelLocator(new ChannelLocator("__", sta, "__", "__"));
            p.setFullPhaseTime(sdf2.parse(String.valueOf(strD) + " " + st.nextToken() + "00"));
            p.setPhaseType("time");
            p.setRecType("V");
            p.setAmpType("half");
            p.setWeight(1);
            while (st.hasMoreElements()) {
                lw = st.nextToken();
            }
            try {
                p.setResi(Float.parseFloat(lw));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            c.getPhases().add(p);
        }
        br.close();
        return c;
    }

    private String getGoodName(String name) {
        int i = 0;
        while (i < pns.length) {
            if (name.contains(pns[i])) {
                return _pns[i];
            }
            ++i;
        }
        return null;
    }

    public void writeOneCatalog(PrintWriter pw, File bul) throws Exception {
        Bul2Catalog b2c = new Bul2Catalog();
        Catalog c = b2c.readBul(bul);
        Catalog2HypoDDPhase c2d = new Catalog2HypoDDPhase();
        c2d.write(pw, c);
    }

    public void writeCatalogs(PrintWriter pw, File inDir) {
        File[] lf;
        File[] fileArray = lf = inDir.listFiles();
        int n = lf.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f != null) {
                if (f.isFile()) {
                    logger.info((Object)("process " + f));
                    try {
                        this.writeOneCatalog(pw, f);
                    }
                    catch (IOException ioEx) {
                        logger.warn((Object)("Error: " + ioEx.getMessage()));
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Warning, ingore " + f + ": " + ex.getMessage()));
                    }
                } else {
                    this.writeCatalogs(pw, f);
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) throws Exception {
        Bul2Catalog b2c = new Bul2Catalog();
        PrintWriter pw = new PrintWriter(new FileWriter("/tmp/test.dat"));
        b2c.writeCatalogs(pw, new File("/home/samba/tttd/bul2004-2007"));
        pw.close();
    }
}

