/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.chart;

import cn.org.gddsn.chart.ContourPlotApplet;
import cn.org.gddsn.chart.ParseMatrixException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;

public class ContourPlot
extends Canvas {
    static final boolean SHOW_NUMBERS = true;
    static final int BLANK = 32;
    static final int OPEN_SUITE = 123;
    static final int CLOSE_SUITE = 125;
    static final int BETWEEN_ARGS = 44;
    static final int N_CONTOURS = 10;
    static final int PLOT_MARGIN = 20;
    static final int WEE_BIT = 3;
    static final int NUMBER_LENGTH = 3;
    static final double Z_MAX_MAX = 1.0E10;
    static final double Z_MIN_MIN = -1.0E10;
    static final String EOL = System.getProperty("line.separator");
    int xSteps;
    int ySteps;
    float[][] z;
    boolean logInterpolation = false;
    Dimension d;
    double deltaX;
    double deltaY;
    int ncv = 10;
    int[] l1 = new int[4];
    int[] l2 = new int[4];
    int[] ij = new int[2];
    int[] i1 = new int[2];
    int[] i2 = new int[2];
    int[] i3 = new int[6];
    int ibkey;
    int icur;
    int jcur;
    int ii;
    int jj;
    int elle;
    int ix;
    int iedge;
    int iflag;
    int ni;
    int ks;
    int cntrIndex;
    int prevIndex;
    int idir;
    int nxidir;
    int k;
    double z1;
    double z2;
    double cval;
    double zMax;
    double zMin;
    double[] intersect = new double[4];
    double[] xy = new double[2];
    double[] prevXY = new double[2];
    float[] cv = new float[this.ncv];
    boolean jump;

    public ContourPlot(int x, int y) {
        this.xSteps = x;
        this.ySteps = y;
        this.setForeground(Color.black);
        this.setBackground(Color.white);
    }

    int sign(int a, int b) {
        a = Math.abs(a);
        if (b < 0) {
            return -a;
        }
        return a;
    }

    void InvalidData() {
        this.cv[0] = 0.0f;
        this.cv[1] = 0.0f;
    }

    void GetExtremes() throws ParseMatrixException {
        this.zMax = this.zMin = (double)this.z[0][0];
        int i = 0;
        while (i < this.xSteps) {
            int j = 0;
            while (j < this.ySteps) {
                double here = this.z[i][j];
                if (this.zMin > here) {
                    this.zMin = here;
                }
                if (this.zMax < here) {
                    this.zMax = here;
                }
                ++j;
            }
            ++i;
        }
        if (this.zMin == this.zMax) {
            this.InvalidData();
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errEqual);
        }
    }

    void AssignContourValues() throws ParseMatrixException {
        if (this.logInterpolation && this.zMin <= 0.0) {
            this.InvalidData();
            throw new ParseMatrixException(ContourPlotApplet.errLog);
        }
        if (this.logInterpolation) {
            double temp = Math.log(this.zMin);
            double delta = (Math.log(this.zMax) - temp) / (double)this.ncv;
            int i = 0;
            while (i < this.ncv) {
                this.cv[i] = (float)Math.exp(temp + (double)(i + 1) * delta);
                ++i;
            }
        } else {
            double delta = (this.zMax - this.zMin) / (double)this.ncv;
            int i = 0;
            while (i < this.ncv) {
                this.cv[i] = (float)(this.zMin + (double)(i + 1) * delta);
                ++i;
            }
        }
    }

    String GetContourValuesString() {
        String s = new String();
        int i = 0;
        while (i < this.ncv) {
            s = String.valueOf(s) + "[" + Integer.toString(i) + "] " + Float.toString(this.cv[i]) + EOL;
            ++i;
        }
        return s;
    }

    void SetMeasurements() {
        this.d = this.getSize();
        this.d.width -= 40;
        this.d.height -= 40;
        this.deltaX = (double)this.d.width / ((double)this.xSteps - 1.0);
        this.deltaY = (double)this.d.height / ((double)this.ySteps - 1.0);
    }

    void DrawGrid(Graphics g) {
        g.clearRect(0, 0, this.d.height + 40, this.d.width + 40);
        g.setColor(Color.gray);
        int i = 0;
        while (i < this.xSteps) {
            int kx = (int)((double)i * this.deltaX);
            g.drawLine(20, 20 + kx, 20 + this.d.height, 20 + kx);
            ++i;
        }
        int j = 0;
        while (j < this.ySteps) {
            int ky = (int)((double)j * this.deltaY);
            g.drawLine(20 + ky, 20, 20 + ky, 20 + this.d.width);
            ++j;
        }
        g.setColor(Color.black);
    }

    void SetColour(Graphics g) {
        Color c = new Color(((this.ncv - this.cntrIndex) * Color.blue.getRed() + this.cntrIndex * Color.red.getRed()) / this.ncv, ((this.ncv - this.cntrIndex) * Color.blue.getGreen() + this.cntrIndex * Color.red.getGreen()) / this.ncv, ((this.ncv - this.cntrIndex) * Color.blue.getBlue() + this.cntrIndex * Color.red.getBlue()) / this.ncv);
        g.setColor(c);
    }

    void DrawKernel(Graphics g) {
        if (this.iflag == 1 || this.iflag == 4 || this.iflag == 5) {
            if (this.cntrIndex != this.prevIndex) {
                this.SetColour(g);
                this.prevIndex = this.cntrIndex;
            }
            int prevU = (int)((this.prevXY[0] - 1.0) * this.deltaX);
            int prevV = (int)((this.prevXY[1] - 1.0) * this.deltaY);
            int u = (int)((this.xy[0] - 1.0) * this.deltaX);
            int v = (int)((this.xy[1] - 1.0) * this.deltaY);
            g.drawLine(20 + prevV, 20 + prevU, 20 + v, 20 + u);
            if (this.iflag == 4 || this.iflag == 5) {
                if (u == 0) {
                    u -= 3;
                } else if (u == this.d.width) {
                    u += 10;
                } else if (v == 0) {
                    v -= 10;
                } else if (v == this.d.height) {
                    v += 3;
                }
                g.drawString(Integer.toString(this.cntrIndex), 20 + v, 20 + u);
            }
        }
        this.prevXY[0] = this.xy[0];
        this.prevXY[1] = this.xy[1];
    }

    void DetectBoundary() {
        this.ix = 1;
        if (this.ij[1 - this.elle] != 1) {
            this.ii = this.ij[0] - this.i1[1 - this.elle];
            this.jj = this.ij[1] - this.i1[this.elle];
            if ((double)this.z[this.ii - 1][this.jj - 1] <= 1.0E10) {
                this.ii = this.ij[0] + this.i2[this.elle];
                this.jj = this.ij[1] + this.i2[1 - this.elle];
                if ((double)this.z[this.ii - 1][this.jj - 1] < 1.0E10) {
                    this.ix = 0;
                }
            }
            if (this.ij[1 - this.elle] >= this.l1[1 - this.elle]) {
                this.ix += 2;
                return;
            }
        }
        this.ii = this.ij[0] + this.i1[1 - this.elle];
        this.jj = this.ij[1] + this.i1[this.elle];
        if ((double)this.z[this.ii - 1][this.jj - 1] > 1.0E10) {
            this.ix += 2;
            return;
        }
        if ((double)this.z[this.ij[0]][this.ij[1]] >= 1.0E10) {
            this.ix += 2;
        }
    }

    boolean Routine_label_020() {
        this.l2[0] = this.ij[0];
        this.l2[1] = this.ij[1];
        this.l2[2] = -this.ij[0];
        this.l2[3] = -this.ij[1];
        this.idir = 0;
        this.nxidir = 1;
        this.k = 1;
        this.ij[0] = Math.abs(this.ij[0]);
        this.ij[1] = Math.abs(this.ij[1]);
        if ((double)this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
            this.elle = this.idir % 2;
            this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
            return true;
        }
        this.elle = 0;
        return false;
    }

    boolean Routine_label_050() {
        block2: {
            while (true) {
                if (this.ij[this.elle] >= this.l1[this.elle]) {
                    if (++this.elle <= 1) continue;
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    if (!this.Routine_label_150()) continue;
                    return true;
                }
                this.ii = this.ij[0] + this.i1[this.elle];
                this.jj = this.ij[1] + this.i1[1 - this.elle];
                if (!((double)this.z[this.ii - 1][this.jj - 1] > 1.0E10)) break block2;
                if (++this.elle <= 1) continue;
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.Routine_label_150()) break;
            }
            return true;
        }
        this.jump = false;
        return false;
    }

    boolean Routine_label_150() {
        while (true) {
            if (this.ij[this.elle] < this.l1[this.k - 1]) {
                int n = this.elle;
                this.ij[n] = this.ij[n] + 1;
                if (this.ij[this.elle] > this.l2[this.k - 1]) {
                    this.l2[this.k - 1] = this.ij[this.elle];
                    this.idir = this.nxidir;
                    this.k = this.nxidir = this.idir + 1;
                    if (this.nxidir > 3) {
                        this.nxidir = 0;
                    }
                }
                this.ij[0] = Math.abs(this.ij[0]);
                this.ij[1] = Math.abs(this.ij[1]);
                if ((double)this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    continue;
                }
                this.elle = 0;
                return false;
            }
            if (this.idir != this.nxidir) {
                this.ij[this.elle] = this.l1[this.k - 1];
                this.k = ++this.nxidir;
                this.elle = 1 - this.elle;
                this.ij[this.elle] = this.l2[this.k - 1];
                if (this.nxidir <= 3) continue;
                this.nxidir = 0;
                continue;
            }
            if (this.ibkey != 0) {
                return true;
            }
            this.ibkey = 1;
            this.ij[0] = this.icur;
            this.ij[1] = this.jcur;
            if (!this.Routine_label_020()) break;
        }
        return false;
    }

    short Routine_label_200(Graphics g, boolean[] workSpace) {
        while (true) {
            this.xy[this.elle] = 1.0 * (double)this.ij[this.elle] + this.intersect[this.iedge - 1];
            this.xy[1 - this.elle] = 1.0 * (double)this.ij[1 - this.elle];
            workSpace[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle] = true;
            this.DrawKernel(g);
            if (this.iflag >= 4) {
                this.icur = this.ij[0];
                this.jcur = this.ij[1];
                return 1;
            }
            this.ContinueContour();
            if (!workSpace[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle]) {
                return 2;
            }
            this.iflag = 5;
            this.iedge = this.ks + 2;
            if (this.iedge > 4) {
                this.iedge -= 4;
            }
            this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
        }
    }

    boolean CrossedByContour(boolean[] workSpace) {
        this.ii = this.ij[0] + this.i1[this.elle];
        this.jj = this.ij[1] + this.i1[1 - this.elle];
        this.z1 = this.z[this.ij[0] - 1][this.ij[1] - 1];
        this.z2 = this.z[this.ii - 1][this.jj - 1];
        this.cntrIndex = 0;
        while (this.cntrIndex < this.ncv) {
            float x;
            int i = 2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle;
            if (!workSpace[i] && (double)(x = this.cv[this.cntrIndex]) > Math.min(this.z1, this.z2) && (double)x <= Math.max(this.z1, this.z2)) {
                workSpace[i] = true;
                return true;
            }
            ++this.cntrIndex;
        }
        return false;
    }

    void ContinueContour() {
        this.ni = 1;
        if (this.iedge >= 3) {
            this.ij[0] = this.ij[0] - this.i3[this.iedge - 1];
            this.ij[1] = this.ij[1] - this.i3[this.iedge + 1];
        }
        int local_k = 1;
        while (local_k < 5) {
            if (local_k != this.iedge) {
                this.ii = this.ij[0] + this.i3[local_k - 1];
                this.jj = this.ij[1] + this.i3[local_k];
                this.z1 = this.z[this.ii - 1][this.jj - 1];
                this.ii = this.ij[0] + this.i3[local_k];
                this.jj = this.ij[1] + this.i3[local_k + 1];
                this.z2 = this.z[this.ii - 1][this.jj - 1];
                if (this.cval > Math.min(this.z1, this.z2) && this.cval <= Math.max(this.z1, this.z2)) {
                    if (local_k == 1 || local_k == 4) {
                        double zz = this.z2;
                        this.z2 = this.z1;
                        this.z1 = zz;
                    }
                    this.intersect[local_k - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                    ++this.ni;
                    this.ks = local_k;
                }
            }
            local_k = (short)(local_k + 1);
        }
        if (this.ni != 2) {
            this.ks = 5 - this.iedge;
            if (this.intersect[2] >= this.intersect[0]) {
                this.ks = 3 - this.iedge;
                if (this.ks <= 0) {
                    this.ks += 4;
                }
            }
        }
        this.elle = this.ks - 1;
        this.iflag = 1;
        this.jump = true;
        if (this.ks >= 3) {
            this.ij[0] = this.ij[0] + this.i3[this.ks - 1];
            this.ij[1] = this.ij[1] + this.i3[this.ks + 1];
            this.elle = this.ks - 3;
        }
    }

    void ContourPlotKernel(Graphics g, boolean[] workSpace) {
        this.l1[0] = this.xSteps;
        this.l1[1] = this.ySteps;
        this.l1[2] = -1;
        this.l1[3] = -1;
        this.i1[0] = 1;
        this.i1[1] = 0;
        this.i2[0] = 1;
        this.i2[1] = -1;
        this.i3[0] = 1;
        this.i3[1] = 0;
        this.i3[2] = 0;
        this.i3[3] = 1;
        this.i3[4] = 1;
        this.i3[5] = 0;
        this.prevXY[0] = 0.0;
        this.prevXY[1] = 0.0;
        this.xy[0] = 1.0;
        this.xy[1] = 1.0;
        this.cntrIndex = 0;
        this.prevIndex = -1;
        this.iflag = 6;
        this.DrawKernel(g);
        this.icur = Math.max(1, Math.min((int)Math.floor(this.xy[0]), this.xSteps));
        this.jcur = Math.max(1, Math.min((int)Math.floor(this.xy[1]), this.ySteps));
        this.ibkey = 0;
        this.ij[0] = this.icur;
        this.ij[1] = this.jcur;
        if (this.Routine_label_020() && this.Routine_label_150()) {
            return;
        }
        if (this.Routine_label_050()) {
            return;
        }
        while (true) {
            short val_label_200;
            this.DetectBoundary();
            if (this.jump) {
                if (this.ix != 0) {
                    this.iflag = 4;
                }
                this.iedge = this.ks + 2;
                if (this.iedge > 4) {
                    this.iedge -= 4;
                }
                this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
                val_label_200 = this.Routine_label_200(g, workSpace);
                if (val_label_200 == 1) {
                    if (this.Routine_label_020() && this.Routine_label_150()) {
                        return;
                    }
                    if (!this.Routine_label_050()) continue;
                    return;
                }
                if (val_label_200 == 2) continue;
                return;
            }
            if (this.ix != 3 && this.ix + this.ibkey != 0 && this.CrossedByContour(workSpace)) {
                this.iedge = this.elle + 1;
                this.cval = this.cv[this.cntrIndex];
                if (this.ix != 1) {
                    this.iedge += 2;
                }
                this.iflag = 2 + this.ibkey;
                this.intersect[this.iedge - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                val_label_200 = this.Routine_label_200(g, workSpace);
                if (val_label_200 == 1) {
                    if (this.Routine_label_020() && this.Routine_label_150()) {
                        return;
                    }
                    if (!this.Routine_label_050()) continue;
                    return;
                }
                if (val_label_200 == 2) continue;
                return;
            }
            if (++this.elle > 1) {
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.Routine_label_150()) {
                    return;
                }
            }
            if (this.Routine_label_050()) break;
        }
    }

    public void paint(Graphics g) {
        int workLength = 2 * this.xSteps * this.ySteps * this.ncv;
        this.SetMeasurements();
        this.DrawGrid(g);
        if (this.cv[0] != this.cv[1]) {
            boolean[] workSpace = new boolean[workLength];
            this.ContourPlotKernel(g, workSpace);
        }
    }

    public void ParseZedMatrix(String s) throws ParseMatrixException, IOException {
        StringBufferInputStream i = new StringBufferInputStream(s);
        StreamTokenizer t = new StreamTokenizer(i);
        this.z = null;
        this.EatCharacter(t, 123);
        do {
            this.ParseRowVector(t);
        } while (t.nextToken() == 44);
        if (t.ttype != 125) {
            this.InvalidData();
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errExpect + '}');
        }
        if (t.nextToken() != -1) {
            this.InvalidData();
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errEOF);
        }
        this.MakeMatrixRectangular();
        this.GetExtremes();
        if (this.zMax > 1.0E10) {
            this.zMax = 1.0E10;
        }
        if (this.zMin < -1.0E10) {
            this.zMin = -1.0E10;
        }
        this.AssignContourValues();
    }

    public void ParseRowVector(StreamTokenizer t) throws ParseMatrixException, IOException {
        if (this.z == null) {
            this.z = new float[1][];
        } else {
            this.AddRow();
        }
        this.EatCharacter(t, 123);
        do {
            int x;
            if (t.nextToken() == -2) {
                x = this.z.length - 1;
                if (this.z[x] == null) {
                    this.z[x] = new float[1];
                    this.z[x][0] = (float)t.nval;
                    continue;
                }
                this.AddColumn((float)t.nval);
                continue;
            }
            x = this.z.length - 1;
            int y = this.z[x].length - 1;
            this.InvalidData();
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errComp + " [" + Integer.toString(x) + "," + Integer.toString(y) + "]");
        } while (t.nextToken() == 44);
        if (t.ttype != 125) {
            this.InvalidData();
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errExpect + '}');
        }
    }

    public void AddRow() throws ParseMatrixException {
        int leng = this.z.length;
        if (leng >= 100) {
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errBounds);
        }
        float[][] temp = new float[leng + 1][];
        System.arraycopy(this.z, 0, temp, 0, leng);
        this.z = temp;
    }

    public void AddColumn(float val) throws ParseMatrixException {
        int i = this.z.length - 1;
        int leng = this.z[i].length;
        if (leng >= 100) {
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errBounds);
        }
        float[] temp = new float[leng + 1];
        System.arraycopy(this.z[i], 0, temp, 0, leng);
        temp[leng] = val;
        this.z[i] = temp;
    }

    public void MakeMatrixRectangular() {
        this.xSteps = this.z.length;
        this.ySteps = 2;
        int i = 0;
        while (i < this.xSteps) {
            int y = this.z[i].length;
            if (this.ySteps < y) {
                this.ySteps = y;
            }
            ++i;
        }
        i = 0;
        while (i < this.xSteps) {
            int leng = this.z[i].length;
            if (leng < this.ySteps) {
                float[] temp = new float[this.ySteps];
                System.arraycopy(this.z[i], 0, temp, 0, leng);
                while (leng < this.ySteps) {
                    temp[leng++] = 0.0f;
                }
                this.z[i] = temp;
            }
            ++i;
        }
    }

    public String ReturnZedMatrix() {
        String s = new String(String.valueOf(ContourPlotApplet.infoStrX) + this.xSteps + EOL + ContourPlotApplet.infoStrY + this.ySteps + EOL);
        int i = 0;
        while (i < this.xSteps) {
            int j = 0;
            while (j < this.ySteps) {
                String oneValue = Double.toString(this.z[i][j]);
                while (oneValue.length() < 3) {
                    oneValue = " " + oneValue;
                }
                s = String.valueOf(s) + oneValue;
                if (j < this.ySteps - 1) {
                    s = String.valueOf(s) + " ";
                }
                ++j;
            }
            s = String.valueOf(s) + EOL;
            ++i;
        }
        return s;
    }

    public void EatCharacter(StreamTokenizer t, int c) throws ParseMatrixException, IOException {
        while (t.nextToken() == 32) {
        }
        if (t.ttype != c) {
            this.InvalidData();
            throw new ParseMatrixException(String.valueOf(ContourPlotApplet.errParse) + EOL + ContourPlotApplet.errExpect + (char)c);
        }
    }
}

