#include "cn_gd_signal_TFRNative.h"
#include <math.h>


  /**
   *   cmr: computes real part of x times y
   */
static double	cmr(double xr,double xi,double yr,double yi){
  //double	rtemp;

  return xr*yr - xi*yi;

  //return(rtemp);
  }


  /**
   *   cmi: computes imaginary part of x times y
   */
static double cmi(double xr,double xi,double yr,double yi) {
  return xi*yr + xr*yi;
}

  /**
   *   ccmr: computes real part of x times y*
   */
static double	ccmr(double xr,double xi, double yr,double yi){
  double	rtemp;

  rtemp = xr*yr + xi*yi;

  return(rtemp);
  }

  /**
   *   ccmi: computes imaginary part of x times y*
   */
static double	ccmi(double xr,double xi,double yr,double yi){
  double	rtemp;

  rtemp = xi*yr - xr*yi;

  return(rtemp);
}


  /****************************************************************/
  /*		fft.c						*/
  /*		Douglas L. Jones				*/
  /*		University of Illinois at Urbana-Champaign	*/
  /*		January 19, 1992				*/
  /*								*/
  /*   fft: in-place radix-2 DIT DFT of a complex input		*/
  /*								*/
  /*   input:							*/
  /*	n:	length of FFT: must be a power of two		*/
  /*	m:	n = 2**m					*/
  /*   input/output						*/
  /*	x:	double array of length n with real part of data	*/
  /*	y:	double array of length n with imag part of data	*/
  /*								*/
  /*   Permission to copy and use this program is granted	*/
  /*   as long as this header is included.			*/
  /****************************************************************/

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    fft
 * Signature: (II[D[D)V
 */
JNIEXPORT void JNICALL Java_cn_gd_signal_TFRNative_fft
(JNIEnv *env, jclass cls, jint n, jint m, jdoubleArray x1, jdoubleArray y1){
  jdouble *x = (*env)->GetDoubleArrayElements(env, x1, 0);
  jdouble *y = (*env)->GetDoubleArrayElements(env, y1, 0);


  //static void fft(int n,int m,double[] x,double[] y){
    int	i,j,k,n1,n2;
    double	c,s,e,a,t1,t2;


    j = 0;				/* bit-reverse	*/
    n2 = n/2;
    for (i=1; i < n - 1; i++){
      n1 = n2;
      while ( j >= n1 ){
        j = j - n1;
        n1 = n1/2;
      }
      j = j + n1;

      if (i < j){
        t1 = x[i];
        x[i] = x[j];
        x[j] = t1;
        t1 = y[i];
        y[i] = y[j];
        y[j] = t1;
      }
    }


    n1 = 0;				/* FFT	*/
    n2 = 1;

    for (i=0; i < m; i++){
      n1 = n2;
      n2 = n2 + n2;
      e = -6.283185307179586/n2;
      a = 0.0;

      for (j=0; j < n1; j++){
        c = cos(a);
        s = sin(a);
        a = a + e;

        for (k=j; k < n; k=k+n2){
          t1 = c*x[k+n1] - s*y[k+n1];
          t2 = s*x[k+n1] + c*y[k+n1];
          x[k+n1] = x[k] - t1;
          y[k+n1] = y[k] - t2;
          x[k] = x[k] + t1;
          y[k] = y[k] + t2;
        }
      }
    }

    (*env)->ReleaseDoubleArrayElements(env,x1,x,0);
    (*env)->ReleaseDoubleArrayElements(env,y1,y,0);

    return;
  }


/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    ccmr
 * Signature: (DDDD)D
 */
JNIEXPORT jdouble JNICALL Java_cn_gd_signal_TFRNative_ccmr
(JNIEnv *env, jclass cls, jdouble xr, jdouble xi, jdouble yr, jdouble yi) {

  /**
   *   ccmr: computes real part of x times y*
   */
  //static double	ccmr(double xr,double xi, double yr,double yi){
    double	rtemp;

    rtemp = xr*yr + xi*yi;

    return(rtemp);
  }

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    ccmi
 * Signature: (DDDD)D
 */
JNIEXPORT jdouble JNICALL Java_cn_gd_signal_TFRNative_ccmi
(JNIEnv *env, jclass cls, jdouble xr, jdouble xi, jdouble yr, jdouble yi) {

  /**
   *   ccmi: computes imaginary part of x times y*
   */
  //  static double	ccmi(double xr,double xi,double yr,double yi){
    double	rtemp;

    rtemp = xi*yr - xr*yi;

    return(rtemp);
}



/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    rectaf
 * Signature: ([D[DII[D[D[D[D[D[D)V
 */
JNIEXPORT void JNICALL Java_cn_gd_signal_TFRNative_rectaf
(JNIEnv *env, jclass cls, jdoubleArray ntv_xr, jdoubleArray ntv_xi, jint laglen, jint freqlen,
 jdoubleArray ntv_alphar, jdoubleArray ntv_alphai, jdoubleArray ntv_alpharN,
 jdoubleArray ntv_alphaiN, jdoubleArray ntv_afr, jdoubleArray ntv_afi) {

  jdouble *xr = (*env)->GetDoubleArrayElements(env, ntv_xr, 0);
  jdouble *xi = (*env)->GetDoubleArrayElements(env, ntv_xi, 0);
  jdouble *alphar = (*env)->GetDoubleArrayElements(env, ntv_alphar, 0);
  jdouble *alphai = (*env)->GetDoubleArrayElements(env, ntv_alphai, 0);
  jdouble *alpharN = (*env)->GetDoubleArrayElements(env, ntv_alpharN, 0);
  jdouble *alphaiN = (*env)->GetDoubleArrayElements(env, ntv_alphaiN, 0);
  jdouble *afr = (*env)->GetDoubleArrayElements(env, ntv_afr, 0);
  jdouble *afi = (*env)->GetDoubleArrayElements(env, ntv_afi, 0);

/*								*/
/*   rectaf: generate running AF on rectangular grid;		*/
/*	     negative lags, all DFT frequencies			*/
/*								*/
//  static void rectaf(double[] xr, double[] xi,int laglen,int freqlen,
//                     double[] alphar, double[] alphai,double[] alpharN,
//    double[] alphaiN, double[] afr,double[] afi) {
    int	i,j;
    double	rtemp,rr,ri,rrN,riN;
    //extern	double	cmr(),cmi();
    //extern	double	ccmr(),ccmi();

    for (i=0; i < laglen; i++){
      rr = ccmr(xr[0],xi[0],xr[i],xi[i]);
      ri = ccmi(xr[0],xi[0],xr[i],xi[i]);

      rrN = ccmr(xr[freqlen-i],xi[freqlen-i],xr[freqlen],xi[freqlen]);
      riN = ccmi(xr[freqlen-i],xi[freqlen-i],xr[freqlen],xi[freqlen]);

      for (j = 0; j < freqlen; j++){
        rtemp = cmr(afr[i*freqlen+j],afi[i*freqlen+j],alphar[j],alphai[j]) -
               cmr(rrN,riN,alpharN[i*freqlen+j],alphaiN[i*freqlen+j]) + rr;
        afi[i*freqlen + j] = cmi(afr[i*freqlen+j],afi[i*freqlen+j],alphar[j],alphai[j]) -
                             cmi(rrN,riN,alpharN[i*freqlen+j],alphaiN[i*freqlen+j]) + ri;
        afr[i*freqlen + j] = rtemp;
      }
    }

    (*env)->ReleaseDoubleArrayElements(env,ntv_xr,xr,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_xi,xi,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_alphar,alphar,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_alphai,alphai,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_alpharN,alpharN,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_alphaiN,alphaiN,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_afr,afr,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_afi,afi,0);
    return;
  }

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    polafint
 * Signature: (III[II[D[D[D[D)V
 */
JNIEXPORT void JNICALL Java_cn_gd_signal_TFRNative_polafint
(JNIEnv *env, jclass cls, jint nrad, jint nphi, jint ntheta, jintArray ntv_maxrad, jint nlag,
 jdoubleArray ntv_plag, jdoubleArray ntv_ptheta, jdoubleArray ntv_rectafm2, jdoubleArray ntv_polafm2) {

  jint *maxrad = (*env)->GetIntArrayElements(env, ntv_maxrad, 0);
  jdouble *plag = (*env)->GetDoubleArrayElements(env, ntv_plag, 0);
  jdouble *ptheta = (*env)->GetDoubleArrayElements(env, ntv_ptheta, 0);
  jdouble *rectafm2 = (*env)->GetDoubleArrayElements(env, ntv_rectafm2, 0);
  jdouble *polafm2 = (*env)->GetDoubleArrayElements(env, ntv_polafm2, 0);

/*								*/
/*   polafint: interpolate AF on polar grid;			*/
/*								*/
//  static void polafint(int nrad,int nphi,int ntheta,int[] maxrad,int nlag,
//                       double[]plag, double[] ptheta, double[] rectafm2, double[]polafm2){
    int i,j;
    int ilag,itheta,itheta1;
    double rlag,rtheta,rtemp,rtemp1;


    for (i=0; i < nphi/2; i++){	/* for all phi ...	*/
      for (j = 0; j < maxrad[i]; j++){	/* and all radii with |theta| < pi */
        ilag = (int) plag[i*nrad+j];
        rlag = plag[i*nrad+j] - ilag;

        if ( ilag >= nlag ){
          polafm2[i*nrad+j] = 0.0;
        }
        else{
          itheta = (int) ptheta[i*nrad+j];
          rtheta = ptheta[i*nrad+j] - itheta;

          itheta1 = itheta + 1;
          if ( itheta1 >= ntheta )  itheta1 = 0;

          rtemp =  (rectafm2[ilag*ntheta+itheta1] -
                    rectafm2[ilag*ntheta+itheta])*rtheta + rectafm2[ilag*ntheta+itheta];
          rtemp1 =  (rectafm2[(ilag+1)*ntheta+itheta1] -
                     rectafm2[(ilag+1)*ntheta+itheta])*rtheta +
                    rectafm2[(ilag+1)*ntheta+itheta];
          polafm2[i*nrad+j] = (rtemp1-rtemp)*rlag + rtemp;
        }
      }
    }


    for (i=nphi/2; i < nphi; i++) {/* for all phi ...	*/
      for (j = 0; j < maxrad[i]; j++){	/* and all radii with |theta| < pi */
        ilag = (int) plag[i*nrad+j];
        rlag = plag[i*nrad+j] - ilag;

        if ( ilag >= nlag ){
          polafm2[i*nrad+j] = 0.0;
        }
        else{
          itheta = (int) ptheta[i*nrad+j];
          rtheta = ptheta[i*nrad+j] - itheta;

          rtemp =  (rectafm2[ilag*ntheta+itheta+1] -
                    rectafm2[ilag*ntheta+itheta])*rtheta +
                   rectafm2[ilag*ntheta+itheta];
          rtemp1 =  (rectafm2[(ilag+1)*ntheta+itheta+1] -
                     rectafm2[(ilag+1)*ntheta+itheta])*rtheta +
                    rectafm2[(ilag+1)*ntheta+itheta];
          polafm2[i*nrad+j] = (rtemp1-rtemp)*rlag + rtemp;
        }
      }
    }

    (*env)->ReleaseIntArrayElements(env,ntv_maxrad,maxrad,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_plag,plag,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_ptheta,ptheta,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_rectafm2,rectafm2,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_polafm2,polafm2,0);
    return;
  }

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    mklag
 * Signature: (IIIII)D
 */
JNIEXPORT jdouble JNICALL Java_cn_gd_signal_TFRNative_mklag
(JNIEnv *env, jclass cls, jint nrad, jint nphi, jint nlag, jint iphi, jint jrad){
  /**
   *   mklag: compute radial sample lag
   */
  //  static double	mklag(int nrad, int nphi, int nlag, int iphi, int jrad){
    double	delay;

    delay = ((1.414213562*(nlag-1)*jrad)/nrad)*sin((3.141592654*iphi)/nphi);

    return(delay);
  }

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    rectkern
 * Signature: (IIII[D[D[D)D
 */
JNIEXPORT jdouble JNICALL Java_cn_gd_signal_TFRNative_rectkern
(JNIEnv *env, jclass cls, jint itau, jint itheta, jint ntheta, jint nphi,
 jdoubleArray ntv_req, jdoubleArray ntv_pheq, jdoubleArray ntv_sigma){
  jdouble *req = (*env)->GetDoubleArrayElements(env, ntv_req, 0);
  jdouble *pheq = (*env)->GetDoubleArrayElements(env, ntv_pheq, 0);
  jdouble *sigma = (*env)->GetDoubleArrayElements(env, ntv_sigma, 0);
  /**
   *   rectkern: generate kernel samples on rectangular grid
   */
  //  static double rectkern(int itau,int itheta, int ntheta, int nphi,
  //                         double[]req, double[]pheq, double[]sigma) {
    int	iphi,iphi1;
    double	kern,tsigma;


    iphi = (int) pheq[itau*ntheta + itheta];
    iphi1 = iphi + 1;
    if (iphi1 > (nphi-1))
      iphi1 = 0;
    tsigma = sigma[iphi] + (pheq[itau*ntheta + itheta] - iphi)*(sigma[iphi1]-sigma[iphi]);

/*  Tom Polver says on his machine, exp screws up when the argument of */
/*  the exp function is too large */
    kern = exp(-req[itau*ntheta+itheta]*req[itau*ntheta+itheta]/(tsigma*tsigma));

    (*env)->ReleaseDoubleArrayElements(env,ntv_req,req,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_pheq,pheq,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_sigma,sigma,0);
    return(kern);
  }

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    sigupdate
 * Signature: (IIIDD[I[D[D[D)V
 */
JNIEXPORT void JNICALL Java_cn_gd_signal_TFRNative_sigupdate
(JNIEnv *env, jclass cls, jint nrad, jint nphi, jint nits, jdouble vol, jdouble mu0,
 jintArray ntv_maxrad, jdoubleArray ntv_polafm2, jdoubleArray ntv_sigma, jdoubleArray ntv_grad) {

  jint *maxrad = (*env)->GetIntArrayElements(env, ntv_maxrad, 0);
  jdouble *polafm2 = (*env)->GetDoubleArrayElements(env, ntv_polafm2, 0);
  jdouble *sigma = (*env)->GetDoubleArrayElements(env, ntv_sigma, 0);
  jdouble *grad = (*env)->GetDoubleArrayElements(env, ntv_grad, 0);

  /**
   *   sigupdate: update RG kernel parameters
   */
  //  static void sigupdate(int nrad,int nphi,int nits, double vol,double mu0,
  //                        int[] maxrad,double[] polafm2,double[]sigma){
    int	ii,i,j;
    //double[] grad = new double[1024];
    for(i=0; i<1024; i++)
      grad[i]=0.0;
    double gradsum,gradsum1,tvol,volfac,eec,ee1,ee2,mu;


    for (ii=0; ii < nits; ii++){
      gradsum = 0.0;
      gradsum1 = 0.0;

      for (i=0; i < nphi; i++){
        grad[i] = 0.0;

        ee1 = exp( - 1.0/(sigma[i]*sigma[i]) );	/* use Kaiser's efficient method */
        //if(Double.isNaN(ee1)) { //debug
          //System.out.println( "Math.exp( - 1.0/(sigma[i]*sigma[i]) )="+ee1+",\tsigma[i]="+sigma[i]);
          //System.out.println("now try calc again:");
          //ee1 = Math.exp( - 1.0/(sigma[i]*sigma[i]) );
          //System.out.println("Math.exp( - 1.0/(sigma[i]*sigma[i]) )="+ee1+",\tsigma[i]="+sigma[i]);
        //}
        ee2 = 1.0;
        eec = ee1*ee1;

        for (j=1; j < maxrad[i]; j++){
          ee2 = ee1*ee2;
          ee1 = eec*ee1;

          grad[i] = grad[i] + j*j*j*ee2*polafm2[i*nrad+j];
        }
        grad[i] = grad[i]/(sigma[i]*sigma[i]*sigma[i]);

        gradsum = gradsum + grad[i]*grad[i];
        gradsum1 = gradsum1 + sigma[i]*grad[i];
      }

      gradsum1 = 2.0*gradsum1;
      if ( gradsum < 0.0000001 )  gradsum = 0.0000001;
      if ( gradsum1 < 0.0000001 )  gradsum1 = 0.0000001;

      mu = ( sqrt(gradsum1*gradsum1 + 4.0*gradsum*vol*mu0) - gradsum1 ) / ( 2.0*gradsum );



      tvol = 0.0;

      for (i=0; i < nphi; i++){
        sigma[i] = sigma[i] + mu*grad[i];
        if (sigma[i] < 0.5)  sigma[i] = 0.5;
      /*printf("sigma[%d] = %g\n", i,sigma[i]); */
        tvol = tvol + sigma[i]*sigma[i];
      }

      volfac = sqrt(vol/tvol);
      for (i=0; i < nphi; i++)  sigma[i] = volfac*sigma[i];
    }

    (*env)->ReleaseIntArrayElements(env,ntv_maxrad,maxrad,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_polafm2,polafm2,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_sigma,sigma,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_grad,grad,0);

    return;
  }

/*
 * Class:     cn_gd_signal_TFRNative
 * Method:    mkmag2
 * Signature: (I[D[D[D)V
 */
JNIEXPORT void JNICALL Java_cn_gd_signal_TFRNative_mkmag2
(JNIEnv *env, jclass cls, jint tlen, jdoubleArray ntv_xr, jdoubleArray ntv_xi, jdoubleArray ntv_xm2) {
  jdouble *xr = (*env)->GetDoubleArrayElements(env, ntv_xr, 0);
  jdouble *xi = (*env)->GetDoubleArrayElements(env, ntv_xi, 0);
  jdouble *xm2 = (*env)->GetDoubleArrayElements(env, ntv_xm2, 0);

  /**
   *   mkmag2: compute squared magnitude of an array
   */
  //  static void mkmag2(int tlen,double[] xr, double[]xi, double[]xm2){
    int	i;


    for (i=0; i < tlen; i++){
      xm2[i] = xr[i]*xr[i] + xi[i]*xi[i];
    }

    (*env)->ReleaseDoubleArrayElements(env,ntv_xr,xr,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_xi,xi,0);
    (*env)->ReleaseDoubleArrayElements(env,ntv_xm2,xm2,0);
    return;
  }

