/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.JdkVersion;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class RedirectView
extends AbstractUrlBasedView {
    public static final String DEFAULT_ENCODING_SCHEME = "UTF-8";
    private boolean contextRelative = false;
    private boolean http10Compatible = true;
    private String encodingScheme = "UTF-8";

    public RedirectView() {
    }

    public RedirectView(String url) {
        super(url);
    }

    public RedirectView(String url, boolean contextRelative) {
        super(url);
        this.contextRelative = contextRelative;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public void setHttp10Compatible(boolean http10Compatible) {
        this.http10Compatible = http10Compatible;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer targetUrl = new StringBuffer();
        if (this.contextRelative && this.getUrl().startsWith("/")) {
            targetUrl.append(request.getContextPath());
        }
        targetUrl.append(this.getUrl());
        this.appendQueryProperties(targetUrl, model, this.encodingScheme);
        this.sendRedirect(request, response, targetUrl.toString(), this.http10Compatible);
    }

    protected void appendQueryProperties(StringBuffer targetUrl, Map model, String encodingScheme) throws UnsupportedEncodingException {
        String fragment = null;
        int anchorIndex = targetUrl.toString().indexOf(35);
        if (anchorIndex > -1) {
            fragment = targetUrl.substring(anchorIndex);
            targetUrl.delete(anchorIndex, targetUrl.length());
        }
        boolean first = this.getUrl().indexOf(63) < 0;
        Iterator entries = this.queryProperties(model).entrySet().iterator();
        while (entries.hasNext()) {
            if (first) {
                targetUrl.append('?');
                first = false;
            } else {
                targetUrl.append('&');
            }
            Map.Entry entry = entries.next();
            String encodedKey = this.urlEncode(entry.getKey().toString(), encodingScheme);
            String encodedValue = entry.getValue() != null ? this.urlEncode(entry.getValue().toString(), encodingScheme) : "";
            targetUrl.append(encodedKey).append('=').append(encodedValue);
        }
        if (fragment != null) {
            targetUrl.append(fragment);
        }
    }

    protected String urlEncode(String input, String encodingScheme) throws UnsupportedEncodingException {
        if (JdkVersion.getMajorJavaVersion() < 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Only JDK 1.3 URLEncoder available: using platform default encoding instead of the requested scheme '" + encodingScheme + "'");
            }
            return URLEncoder.encode(input);
        }
        return URLEncoder.encode(input, encodingScheme);
    }

    protected Map queryProperties(Map model) {
        return model;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
        if (http10Compatible) {
            response.sendRedirect(response.encodeRedirectURL(targetUrl));
        } else {
            response.setStatus(303);
            response.setHeader("Location", response.encodeRedirectURL(targetUrl));
        }
    }
}

