/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class ControllerClassNameHandlerMapping
extends AbstractUrlHandlerMapping
implements HandlerMapping {
    private static final String CONTROLLER_SUFFIX = "Controller";
    private Set excludedPackages = Collections.singleton("org.springframework.web.servlet.mvc");
    private Set excludedClasses = Collections.EMPTY_SET;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$Controller;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$multiaction$MultiActionController;

    public void setExcludedPackages(String[] excludedPackages) {
        this.excludedPackages = excludedPackages != null ? new HashSet<String>(Arrays.asList(excludedPackages)) : Collections.EMPTY_SET;
    }

    public void setExcludedClasses(Class[] excludedClasses) {
        this.excludedClasses = excludedClasses != null ? new HashSet<Class>(Arrays.asList(excludedClasses)) : Collections.EMPTY_SET;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        this.detectControllers();
    }

    protected void detectControllers() throws BeansException {
        this.registerControllers(class$org$springframework$web$servlet$mvc$Controller == null ? (class$org$springframework$web$servlet$mvc$Controller = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.Controller")) : class$org$springframework$web$servlet$mvc$Controller);
        this.registerControllers(class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController == null ? (class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.throwaway.ThrowawayController")) : class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController);
    }

    protected void registerControllers(Class controllerType) throws BeansException {
        String[] beanNames = this.getApplicationContext().getBeanNamesForType(controllerType);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            Class beanClass = this.getApplicationContext().getType(beanName);
            if (!this.isEligibleForMapping(beanName, beanClass)) continue;
            this.registerController(beanName, beanClass);
        }
    }

    protected boolean isEligibleForMapping(String beanName, Class beanClass) {
        if (beanClass == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean type could not be determined");
            }
            return false;
        }
        if (this.excludedClasses.contains(beanClass)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean class is explicitly excluded: " + beanClass.getName());
            }
            return false;
        }
        String beanClassName = beanClass.getName();
        Iterator it = this.excludedPackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!beanClassName.startsWith(packageName)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean class is defined in an excluded package: " + beanClass.getName());
            }
            return false;
        }
        return true;
    }

    protected void registerController(String beanName, Class beanClass) throws BeansException, IllegalStateException {
        String urlPath = this.generatePathMapping(beanClass);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering Controller '" + beanName + "' as handler for URL path [" + urlPath + "]");
        }
        this.registerHandler(urlPath, (Object)beanName);
    }

    protected String generatePathMapping(Class beanClass) {
        StringBuffer pathMapping = new StringBuffer("/");
        String className = ClassUtils.getShortName(beanClass.getName());
        String path = className.endsWith(CONTROLLER_SUFFIX) ? className.substring(0, className.indexOf(CONTROLLER_SUFFIX)) : className;
        pathMapping.append(path.toLowerCase());
        if ((class$org$springframework$web$servlet$mvc$multiaction$MultiActionController == null ? (class$org$springframework$web$servlet$mvc$multiaction$MultiActionController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.multiaction.MultiActionController")) : class$org$springframework$web$servlet$mvc$multiaction$MultiActionController).isAssignableFrom(beanClass)) {
            pathMapping.append("/*");
        } else {
            pathMapping.append("*");
        }
        return pathMapping.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

