/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler.metadata;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Constants;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.handler.metadata.PathMap;

public abstract class AbstractPathMapHandlerMapping
extends AbstractUrlHandlerMapping {
    private static final Constants constants = new Constants(class$org$springframework$beans$factory$config$AutowireCapableBeanFactory == null ? (class$org$springframework$beans$factory$config$AutowireCapableBeanFactory = AbstractPathMapHandlerMapping.class$("org.springframework.beans.factory.config.AutowireCapableBeanFactory")) : class$org$springframework$beans$factory$config$AutowireCapableBeanFactory);
    private int autowireMode = 4;
    private boolean dependencyCheck = true;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$AutowireCapableBeanFactory;

    public void setAutowireModeName(String constantName) throws IllegalArgumentException {
        this.setAutowireMode(constants.asNumber(constantName).intValue());
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (!(this.getApplicationContext() instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("[" + this.getClass().getName() + "] needs to run in a ConfigurableApplicationContext");
        }
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory();
        this.detectAndCreateHandlers(beanFactory);
    }

    protected void detectAndCreateHandlers(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            Class[] handlerClasses = this.getClassesWithPathMapAttributes();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found " + handlerClasses.length + " attribute-targeted handlers");
            }
            for (int i = 0; i < handlerClasses.length; ++i) {
                Class handlerClass = handlerClasses[i];
                Object handler = beanFactory.createBean(handlerClass, this.autowireMode, this.dependencyCheck);
                beanFactory.registerSingleton(handlerClass.getName(), handler);
                PathMap[] pathMaps = this.getPathMapAttributes(handlerClass);
                this.registerHandler(pathMaps, handler);
            }
        }
        catch (BeansException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not retrieve PathMap attributes", ex);
        }
    }

    protected void registerHandler(PathMap[] pathMaps, Object handler) throws BeansException, IllegalStateException {
        for (int j = 0; j < pathMaps.length; ++j) {
            PathMap pathMap = pathMaps[j];
            String path = pathMap.getUrl();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.registerHandler(path, handler);
        }
    }

    protected abstract Class[] getClassesWithPathMapAttributes() throws Exception;

    protected abstract PathMap[] getPathMapAttributes(Class var1) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

