/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class BeanNameUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private boolean detectHandlersInAncestorContexts = false;
    static /* synthetic */ Class class$java$lang$Object;

    public void setDetectHandlersInAncestorContexts(boolean detectHandlersInAncestorContexts) {
        this.detectHandlersInAncestorContexts = detectHandlersInAncestorContexts;
    }

    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking for URL mappings in application context: " + this.getApplicationContext());
        }
        String[] beanNames = this.detectHandlersInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.getApplicationContext(), class$java$lang$Object == null ? (class$java$lang$Object = BeanNameUrlHandlerMapping.class$("java.lang.Object")) : class$java$lang$Object) : this.getApplicationContext().getBeanNamesForType(class$java$lang$Object == null ? (class$java$lang$Object = BeanNameUrlHandlerMapping.class$("java.lang.Object")) : class$java$lang$Object);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            String[] urls = this.determineUrlsForHandler(beanName);
            if (urls.length > 0) {
                this.registerHandler(urls, beanName);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Rejected bean name '" + beanNames[i] + "': no URL paths identified");
        }
    }

    protected String[] determineUrlsForHandler(String beanName) {
        ArrayList<String> urls = new ArrayList<String>();
        if (beanName.startsWith("/")) {
            urls.add(beanName);
        }
        String[] aliases = this.getApplicationContext().getAliases(beanName);
        for (int j = 0; j < aliases.length; ++j) {
            if (!aliases[j].startsWith("/")) continue;
            urls.add(aliases[j]);
        }
        return StringUtils.toStringArray(urls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

