/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestContextFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ServletRequestAttributes attributes = new ServletRequestAttributes(request);
        LocaleContextHolder.setLocale(request.getLocale());
        RequestContextHolder.setRequestAttributes(attributes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound request context to thread: " + request);
        }
        try {
            filterChain.doFilter(request, response);
        }
        finally {
            RequestContextHolder.setRequestAttributes(null);
            LocaleContextHolder.setLocale(null);
            attributes.requestCompleted();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cleared thread-bound request context: " + request);
            }
        }
    }
}

