/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.ScheduledExecutorTask;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ScheduledExecutorFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledExecutorTask[] scheduledExecutorTasks;
    private int poolSize = 1;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private boolean exposeUnconfigurableExecutor = false;
    private ScheduledExecutorService executor;

    public void setScheduledExecutorTasks(ScheduledExecutorTask[] scheduledExecutorTasks) {
        this.scheduledExecutorTasks = scheduledExecutorTasks;
    }

    public void setPoolSize(int poolSize) {
        Assert.isTrue(poolSize > 0, "'poolSize' must be 1 or higher");
        this.poolSize = poolSize;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler != null ? rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy();
    }

    public void setExposeUnconfigurableExecutor(boolean exposeUnconfigurableExecutor) {
        this.exposeUnconfigurableExecutor = exposeUnconfigurableExecutor;
    }

    public void afterPropertiesSet() {
        this.logger.info("Initializing SchedulerExecutorService");
        ScheduledExecutorService executor = this.createExecutor(this.poolSize, this.threadFactory, this.rejectedExecutionHandler);
        if (!ObjectUtils.isEmpty(this.scheduledExecutorTasks)) {
            this.registerTasks(this.scheduledExecutorTasks, executor);
        }
        this.executor = this.exposeUnconfigurableExecutor ? Executors.unconfigurableScheduledExecutorService(executor) : executor;
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler);
    }

    protected void registerTasks(ScheduledExecutorTask[] tasks, ScheduledExecutorService executor) {
        for (int i = 0; i < tasks.length; ++i) {
            ScheduledExecutorTask task = tasks[i];
            if (task.isOneTimeTask()) {
                executor.schedule(task.getRunnable(), task.getDelay(), task.getTimeUnit());
                continue;
            }
            if (task.isFixedRate()) {
                executor.scheduleAtFixedRate(task.getRunnable(), task.getDelay(), task.getPeriod(), task.getTimeUnit());
                continue;
            }
            executor.scheduleWithFixedDelay(task.getRunnable(), task.getDelay(), task.getPeriod(), task.getTimeUnit());
        }
    }

    public Object getObject() {
        return this.executor;
    }

    public Class getObjectType() {
        return this.executor != null ? this.executor.getClass() : ScheduledExecutorService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info("Shutting down ScheduledExecutorService");
        this.executor.shutdown();
    }
}

