/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.jaxrpc.LocalJaxRpcServiceFactory;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import org.springframework.util.CollectionUtils;

public class JaxRpcPortClientInterceptor
extends LocalJaxRpcServiceFactory
implements MethodInterceptor,
InitializingBean {
    private Service jaxRpcService;
    private Service serviceToUse;
    private String portName;
    private String username;
    private String password;
    private String endpointAddress;
    private boolean maintainSession;
    private final Map customPropertyMap = new HashMap();
    private Class serviceInterface;
    private Class portInterface;
    private boolean lookupServiceOnStartup = true;
    private boolean refreshServiceAfterConnectFailure = false;
    private QName portQName;
    private Remote portStub;
    private final Object preparationMonitor = new Object();
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setJaxRpcService(Service jaxRpcService) {
        this.jaxRpcService = jaxRpcService;
    }

    public Service getJaxRpcService() {
        return this.jaxRpcService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
    }

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void setCustomProperties(Properties customProperties) {
        CollectionUtils.mergePropertiesIntoMap(customProperties, this.customPropertyMap);
    }

    public void setCustomPropertyMap(Map customProperties) {
        if (customProperties != null) {
            Iterator it = customProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Illegal property key [" + entry.getKey() + "]: only Strings allowed");
                }
                this.addCustomProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public Map getCustomPropertyMap() {
        return this.customPropertyMap;
    }

    public void addCustomProperty(String name, Object value) {
        this.customPropertyMap.put(name, value);
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setPortInterface(Class portInterface) {
        if (!(portInterface == null || portInterface.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JaxRpcPortClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(portInterface))) {
            throw new IllegalArgumentException("portInterface must be an interface derived from [java.rmi.Remote]");
        }
        this.portInterface = portInterface;
    }

    public Class getPortInterface() {
        return this.portInterface;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this.lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public void setRefreshServiceAfterConnectFailure(boolean refreshServiceAfterConnectFailure) {
        this.refreshServiceAfterConnectFailure = refreshServiceAfterConnectFailure;
    }

    public void afterPropertiesSet() throws ServiceException {
        if (this.lookupServiceOnStartup) {
            this.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws ServiceException, RemoteLookupFailureException {
        if (this.getPortName() == null) {
            throw new IllegalArgumentException("Property 'portName' is required");
        }
        Object object = this.preparationMonitor;
        synchronized (object) {
            this.serviceToUse = null;
            this.portQName = this.getQName(this.getPortName());
            Service service = this.getJaxRpcService();
            if (service == null) {
                service = this.createJaxRpcService();
            } else {
                this.postProcessJaxRpcService(service);
            }
            Class portInterface = this.getPortInterface();
            if (portInterface != null && !this.alwaysUseJaxRpcCall()) {
                Class serviceInterface;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Creating JAX-RPC proxy for JAX-RPC port [" + this.portQName + "], using port interface [" + portInterface.getName() + "]");
                }
                Remote remoteObj = service.getPort(this.portQName, portInterface);
                if (this.logger.isDebugEnabled() && (serviceInterface = this.getServiceInterface()) != null) {
                    boolean isImpl = serviceInterface.isInstance(remoteObj);
                    this.logger.debug("Using service interface [" + serviceInterface.getName() + "] for JAX-RPC port [" + this.portQName + "] - " + (!isImpl ? "not" : "") + " directly implemented");
                }
                if (!(remoteObj instanceof Stub)) {
                    throw new RemoteLookupFailureException("Port stub of class [" + remoteObj.getClass().getName() + "] is not a valid JAX-RPC stub: it does not implement interface [javax.xml.rpc.Stub]");
                }
                Stub stub = (Stub)remoteObj;
                this.preparePortStub(stub);
                this.postProcessPortStub(stub);
                this.portStub = remoteObj;
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using JAX-RPC dynamic calls for JAX-RPC port [" + this.portQName + "]");
            }
            this.serviceToUse = service;
        }
    }

    protected boolean alwaysUseJaxRpcCall() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = this.preparationMonitor;
        synchronized (object) {
            this.serviceToUse = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPrepared() {
        Object object = this.preparationMonitor;
        synchronized (object) {
            return this.serviceToUse != null;
        }
    }

    protected QName getPortQName() {
        return this.portQName;
    }

    protected void preparePortStub(Stub stub) {
        String endpointAddress;
        String password;
        String username = this.getUsername();
        if (username != null) {
            stub._setProperty("javax.xml.rpc.security.auth.username", (Object)username);
        }
        if ((password = this.getPassword()) != null) {
            stub._setProperty("javax.xml.rpc.security.auth.password", (Object)password);
        }
        if ((endpointAddress = this.getEndpointAddress()) != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpointAddress);
        }
        if (this.isMaintainSession()) {
            stub._setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.TRUE);
        }
        if (this.customPropertyMap != null) {
            Iterator it = this.customPropertyMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                stub._setProperty(key, this.customPropertyMap.get(key));
            }
        }
    }

    protected void postProcessPortStub(Stub stub) {
    }

    protected Remote getPortStub() {
        return this.portStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (AopUtils.isToStringMethod(invocation.getMethod())) {
            return "JAX-RPC proxy for port [" + this.getPortName() + "] of service [" + this.getServiceName() + "]";
        }
        if (!this.lookupServiceOnStartup || this.refreshServiceAfterConnectFailure) {
            Object object = this.preparationMonitor;
            synchronized (object) {
                if (!this.isPrepared()) {
                    try {
                        this.prepare();
                    }
                    catch (ServiceException ex) {
                        throw new RemoteLookupFailureException("Preparation of JAX-RPC service failed", ex);
                    }
                }
            }
        }
        if (!this.isPrepared()) {
            throw new IllegalStateException("JaxRpcClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        return this.doInvoke(invocation);
    }

    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        Remote stub = this.getPortStub();
        if (stub != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Invoking operation '" + invocation.getMethod().getName() + "' on JAX-RPC port stub");
            }
            return this.doInvoke(invocation, stub);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Invoking operation '" + invocation.getMethod().getName() + "' as JAX-RPC dynamic call");
        }
        return this.performJaxRpcCall(invocation);
    }

    protected Object doInvoke(MethodInvocation invocation, Remote portStub) throws Throwable {
        try {
            return RmiClientInterceptorUtils.doInvoke(invocation, portStub);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof RemoteException) {
                RemoteException rex = (RemoteException)targetEx;
                boolean isConnectFailure = this.isConnectFailure(rex);
                if (isConnectFailure && this.refreshServiceAfterConnectFailure) {
                    this.reset();
                }
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, isConnectFailure, this.portQName.toString());
            }
            if (targetEx instanceof JAXRPCException) {
                throw new RemoteProxyFailureException("Invalid call on JAX-RPC port stub", targetEx);
            }
            throw targetEx;
        }
    }

    protected Object performJaxRpcCall(MethodInvocation invocation) throws Throwable {
        return this.performJaxRpcCall(invocation, this.serviceToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performJaxRpcCall(MethodInvocation invocation, Service service) throws Throwable {
        QName portQName = this.getPortQName();
        Call call = null;
        Service service2 = service;
        synchronized (service2) {
            call = service.createCall(portQName, invocation.getMethod().getName());
        }
        this.prepareJaxRpcCall(call);
        this.postProcessJaxRpcCall(call, invocation);
        try {
            return call.invoke(invocation.getArguments());
        }
        catch (RemoteException ex) {
            boolean isConnectFailure = this.isConnectFailure(ex);
            if (isConnectFailure && this.refreshServiceAfterConnectFailure) {
                this.reset();
            }
            throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), ex, isConnectFailure, portQName.toString());
        }
        catch (JAXRPCException ex) {
            throw new RemoteProxyFailureException("Invalid JAX-RPC call configuration", ex);
        }
    }

    protected void prepareJaxRpcCall(Call call) {
        String endpointAddress;
        String password;
        String username = this.getUsername();
        if (username != null) {
            call.setProperty("javax.xml.rpc.security.auth.username", (Object)username);
        }
        if ((password = this.getPassword()) != null) {
            call.setProperty("javax.xml.rpc.security.auth.password", (Object)password);
        }
        if ((endpointAddress = this.getEndpointAddress()) != null) {
            call.setTargetEndpointAddress(endpointAddress);
        }
        if (this.isMaintainSession()) {
            call.setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.TRUE);
        }
        if (this.customPropertyMap != null) {
            Iterator it = this.customPropertyMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                call.setProperty(key, this.customPropertyMap.get(key));
            }
        }
    }

    protected void postProcessJaxRpcCall(Call call, MethodInvocation invocation) {
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

