/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.support;

import java.lang.reflect.Method;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionLogEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsLoggingSessionLog
extends AbstractSessionLog {
    public static final String NAMESPACE_PREFIX = "oracle.toplink.";
    public static final String DEFAULT_NAMESPACE = "session";
    public static final String DEFAULT_SEPARATOR = "--";
    private static Method getExceptionMethod;
    private String separator = "--";
    static /* synthetic */ Class class$oracle$toplink$logging$SessionLogEntry;

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void log(oracle.toplink.logging.SessionLogEntry entry) {
        Log logger = LogFactory.getLog(this.getCategory(entry));
        switch (entry.getLevel()) {
            case 7: {
                if (!logger.isErrorEnabled()) break;
                if (entry.hasException()) {
                    logger.error(this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.error(this.getMessageString(entry));
                break;
            }
            case 6: {
                if (!logger.isWarnEnabled()) break;
                if (entry.hasException()) {
                    logger.warn(this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.warn(this.getMessageString(entry));
                break;
            }
            case 5: {
                if (!logger.isInfoEnabled()) break;
                if (entry.hasException()) {
                    logger.info(this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.info(this.getMessageString(entry));
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (!logger.isDebugEnabled()) break;
                if (entry.hasException()) {
                    logger.debug(this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.debug(this.getMessageString(entry));
                break;
            }
            case 1: {
                if (!logger.isTraceEnabled()) break;
                if (entry.hasException()) {
                    logger.trace(this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.trace(this.getMessageString(entry));
            }
        }
    }

    protected String getCategory(oracle.toplink.logging.SessionLogEntry entry) {
        if (entry.getNameSpace() != null) {
            return NAMESPACE_PREFIX + entry.getNameSpace();
        }
        return "oracle.toplink.session";
    }

    protected String getMessageString(oracle.toplink.logging.SessionLogEntry entry) {
        StringBuffer buf = new StringBuffer();
        if (entry.getSession() != null) {
            buf.append(this.getSessionString((Session)entry.getSession()));
            buf.append(this.getSeparator());
        }
        if (entry.getConnection() != null) {
            buf.append(this.getConnectionString(entry.getConnection()));
            buf.append(this.getSeparator());
        }
        buf.append(this.formatMessage(entry));
        return buf.toString();
    }

    protected Throwable getException(oracle.toplink.logging.SessionLogEntry entry) {
        try {
            return (Throwable)getExceptionMethod.invoke((Object)entry, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not invoke method SessionLogEntry.getException(): " + ex.getMessage());
        }
    }

    public void log(SessionLogEntry entry) {
        throw new UnsupportedOperationException("oracle.toplink.sessions.SessionLogEntry not supported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            getExceptionMethod = (class$oracle$toplink$logging$SessionLogEntry == null ? (class$oracle$toplink$logging$SessionLogEntry = CommonsLoggingSessionLog.class$("oracle.toplink.logging.SessionLogEntry")) : class$oracle$toplink$logging$SessionLogEntry).getMethod("getException", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Could not find method SessionLogEntry.getException()");
        }
    }
}

