/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.publicinterface.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TopLinkTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean lazyDatabaseTransaction = false;
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public TopLinkTransactionManager() {
    }

    public TopLinkTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setLazyDatabaseTransaction(boolean lazyDatabaseTransaction) {
        this.lazyDatabaseTransaction = lazyDatabaseTransaction;
    }

    public boolean isLazyDatabaseTransaction() {
        return this.lazyDatabaseTransaction;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    protected Object doGetTransaction() {
        TopLinkTransactionObject txObject = new TopLinkTransactionObject();
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.sessionFactory);
        txObject.setSessionHolder(sessionHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        TopLinkTransactionObject txObject = (TopLinkTransactionObject)transaction;
        return txObject.getSessionHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        oracle.toplink.sessions.Session session = null;
        try {
            if (!definition.isReadOnly()) {
                this.logger.debug("Creating managed TopLink Session with active UnitOfWork for read-write transaction");
                session = this.getSessionFactory().createManagedClientSession();
            } else {
                this.logger.debug("Creating plain TopLink Session without active UnitOfWork for read-only transaction");
                session = this.getSessionFactory().createSession();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Opened new session [" + session + "] for TopLink transaction");
            }
            TopLinkTransactionObject txObject = (TopLinkTransactionObject)transaction;
            txObject.setSessionHolder(new SessionHolder(session));
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
            switch (definition.getIsolationLevel()) {
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getSessionHolder().setTimeoutInSeconds(timeout);
            }
            if (!definition.isReadOnly() && !this.isLazyDatabaseTransaction()) {
                session.getActiveUnitOfWork().beginEarlyTransaction();
            }
            if (this.getDataSource() != null) {
                Connection con = this.getJdbcConnection(session);
                if (con != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(con);
                    if (timeout != -1) {
                        conHolder.setTimeoutInSeconds(timeout);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exposing TopLink transaction as JDBC transaction [" + con + "]");
                    }
                    TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not exposing TopLink transaction [" + session + "] as JDBC transaction because no JDBC Connection could be retrieved from it");
                }
            }
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), txObject.getSessionHolder());
        }
        catch (Exception ex) {
            SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            throw new CannotCreateTransactionException("Could not open TopLink Session for transaction", ex);
        }
    }

    protected Connection getJdbcConnection(oracle.toplink.sessions.Session session) {
        if (!(session instanceof Session)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("TopLink Session [" + session + "] does not derive from [oracle.toplink.publicinterface.Session]");
            }
            return null;
        }
        Accessor accessor = ((Session)session).getAccessor();
        if (!(accessor instanceof DatabaseAccessor)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("TopLink Accessor [" + accessor + "] does not derive from [oracle.toplink.internal.databaseaccess.DatabaseAccessor]");
            }
            return null;
        }
        return ((DatabaseAccessor)accessor).getConnection();
    }

    protected Object doSuspend(Object transaction) {
        TopLinkTransactionObject txObject = (TopLinkTransactionObject)transaction;
        txObject.setSessionHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SessionHolder sessionHolder = (SessionHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource(this.getSessionFactory(), sessionHolder);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        TopLinkTransactionObject txObject = (TopLinkTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Committing TopLink transaction on session [" + txObject.getSessionHolder().getSession() + "]");
        }
        try {
            if (!status.isReadOnly()) {
                txObject.getSessionHolder().getSession().getActiveUnitOfWork().commit();
            }
            txObject.getSessionHolder().clear();
        }
        catch (TopLinkException ex) {
            throw this.convertTopLinkAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        TopLinkTransactionObject txObject = (TopLinkTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Not committing TopLink transaction on session [" + txObject.getSessionHolder().getSession() + "]");
        }
        txObject.getSessionHolder().clear();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        TopLinkTransactionObject txObject = (TopLinkTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Setting TopLink transaction on session [" + txObject.getSessionHolder().getSession() + "] rollback-only");
        }
        txObject.getSessionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TopLinkTransactionObject txObject = (TopLinkTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        if (txObject.hasConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        oracle.toplink.sessions.Session session = txObject.getSessionHolder().getSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Releasing TopLink Session [" + session + "] after transaction");
        }
        try {
            session.release();
        }
        catch (Throwable ex) {
            this.logger.debug("Could not release TopLink Session after transaction", ex);
        }
    }

    protected DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        Throwable internalEx;
        if (this.getJdbcExceptionTranslator() != null && ex instanceof DatabaseException && (internalEx = ex.getInternalException()) instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("TopLink commit: " + ex.getMessage(), null, (SQLException)internalEx);
        }
        return SessionFactoryUtils.convertTopLinkAccessException(ex);
    }

    private static class TopLinkTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;

        private TopLinkTransactionObject() {
        }

        public void setSessionHolder(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly();
        }
    }
}

