/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public abstract class JmsLogAppenderSupport
extends AppenderSkeleton {
    public static final int JMS_PUBLISH_ERROR_CODE = 61616;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private boolean allowTextMessages = true;
    private String subjectPrefix = "log4j.";

    public Connection getConnection() throws JMSException, NamingException {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Session getSession() throws JMSException, NamingException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public MessageProducer getProducer() throws JMSException, NamingException {
        if (this.producer == null) {
            this.producer = this.createProducer();
        }
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public void close() {
        ArrayList<JMSException> errors = new ArrayList<JMSException>();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                errors.add(e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                errors.add(e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                errors.add(e);
            }
        }
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            JMSException e = (JMSException)iter.next();
            this.getErrorHandler().error("Error closing JMS resources: " + e, e, 61616);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
        try {
            this.getProducer();
        }
        catch (Exception e) {
            this.getErrorHandler().error("Could not create JMS resources: " + e, e, 61616);
        }
    }

    protected abstract Connection createConnection() throws JMSException, NamingException;

    protected Session createSession() throws JMSException, NamingException {
        return this.getConnection().createSession(false, 1);
    }

    protected MessageProducer createProducer() throws JMSException, NamingException {
        return this.getSession().createProducer(null);
    }

    protected void append(LoggingEvent event) {
        try {
            Message message = this.createMessage(event);
            Destination destination = this.getDestination(event);
            this.getProducer().send(destination, message);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Could not send message due to: " + e, e, 61616, event);
        }
    }

    protected Message createMessage(LoggingEvent event) throws JMSException, NamingException {
        Message answer = null;
        Object value = event.getMessage();
        answer = this.allowTextMessages && value instanceof String ? this.getSession().createTextMessage((String)value) : this.getSession().createObjectMessage((Serializable)value);
        answer.setStringProperty("level", event.getLevel().toString());
        answer.setIntProperty("levelInt", event.getLevel().toInt());
        answer.setStringProperty("threadName", event.getThreadName());
        return answer;
    }

    protected Destination getDestination(LoggingEvent event) throws JMSException, NamingException {
        String name = this.subjectPrefix + event.getLoggerName();
        return this.getSession().createTopic(name);
    }
}

