/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.reliable;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.transport.reliable.ReplayBuffer;
import org.apache.activemq.transport.reliable.ReplayBufferListener;
import org.apache.activemq.transport.reliable.Replayer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultReplayBuffer
implements ReplayBuffer {
    private static final Log log = LogFactory.getLog(DefaultReplayBuffer.class);
    private final int size;
    private ReplayBufferListener listener;
    private Map map;
    private int lowestCommandId = 1;
    private Object lock = new Object();

    public DefaultReplayBuffer(int size) {
        this.size = size;
        this.map = this.createMap(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuffer(int commandId, Object buffer) {
        if (log.isDebugEnabled()) {
            log.debug("Adding command ID: " + commandId + " to replay buffer: " + this + " object: " + buffer);
        }
        Object object = this.lock;
        synchronized (object) {
            int max = this.size - 1;
            while (this.map.size() >= max) {
                Object evictedBuffer = this.map.remove(new Integer(++this.lowestCommandId));
                this.onEvictedBuffer(this.lowestCommandId, evictedBuffer);
            }
            this.map.put(new Integer(commandId), buffer);
        }
    }

    public void setReplayBufferListener(ReplayBufferListener bufferPoolAdapter) {
        this.listener = bufferPoolAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayMessages(int fromCommandId, int toCommandId, Replayer replayer) throws IOException {
        if (replayer == null) {
            throw new IllegalArgumentException("No Replayer parameter specified");
        }
        if (log.isDebugEnabled()) {
            log.debug("Buffer: " + this + " replaying messages from: " + fromCommandId + " to: " + toCommandId);
        }
        for (int i = fromCommandId; i <= toCommandId; ++i) {
            Object buffer = null;
            Object object = this.lock;
            synchronized (object) {
                buffer = this.map.get(new Integer(i));
            }
            replayer.sendBuffer(i, buffer);
        }
    }

    protected Map createMap(int maximumSize) {
        return new HashMap(maximumSize);
    }

    protected void onEvictedBuffer(int commandId, Object buffer) {
        if (this.listener != null) {
            this.listener.onBufferDiscarded(commandId, buffer);
        }
    }
}

