/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;

public abstract class DiscoveryAgentFactory {
    private static final FactoryFinder discoveryAgentFinder = new FactoryFinder("META-INF/services/org/apache/activemq/transport/discoveryagent/");
    private static final ConcurrentHashMap discoveryAgentFactorys = new ConcurrentHashMap();

    private static DiscoveryAgentFactory findDiscoveryAgentFactory(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IOException("DiscoveryAgent scheme not specified: [" + uri + "]");
        }
        DiscoveryAgentFactory daf = (DiscoveryAgentFactory)discoveryAgentFactorys.get(scheme);
        if (daf == null) {
            try {
                daf = (DiscoveryAgentFactory)discoveryAgentFinder.newInstance(scheme);
                discoveryAgentFactorys.put(scheme, daf);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("DiscoveryAgent scheme NOT recognized: [" + scheme + "]", e);
            }
        }
        return daf;
    }

    public static DiscoveryAgent createDiscoveryAgent(URI uri) throws IOException {
        DiscoveryAgentFactory tf = DiscoveryAgentFactory.findDiscoveryAgentFactory(uri);
        return tf.doCreateDiscoveryAgent(uri);
    }

    protected abstract DiscoveryAgent doCreateDiscoveryAgent(URI var1) throws IOException;
}

