/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.memory;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.memory.MemoryMessageStore;
import org.apache.activemq.store.memory.MemoryTopicMessageStore;
import org.apache.activemq.store.memory.MemoryTransactionStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryPersistenceAdapter
implements PersistenceAdapter {
    private static final Log log = LogFactory.getLog(MemoryPersistenceAdapter.class);
    MemoryTransactionStore transactionStore;
    ConcurrentHashMap topics = new ConcurrentHashMap();
    ConcurrentHashMap queues = new ConcurrentHashMap();
    private boolean useExternalMessageReferences;

    public Set getDestinations() {
        HashSet rc = new HashSet(this.queues.size() + this.topics.size());
        Iterator iter = this.queues.keySet().iterator();
        while (iter.hasNext()) {
            rc.add(iter.next());
        }
        iter = this.topics.keySet().iterator();
        while (iter.hasNext()) {
            rc.add(iter.next());
        }
        return rc;
    }

    public static MemoryPersistenceAdapter newInstance(File file) {
        return new MemoryPersistenceAdapter();
    }

    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = (MessageStore)this.queues.get(destination);
        if (rc == null) {
            rc = new MemoryMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.queues.put(destination, rc);
        }
        return rc;
    }

    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = (TopicMessageStore)this.topics.get(destination);
        if (rc == null) {
            rc = new MemoryTopicMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.topics.put(destination, rc);
        }
        return rc;
    }

    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore();
        }
        return this.transactionStore;
    }

    public void beginTransaction(ConnectionContext context) {
    }

    public void commitTransaction(ConnectionContext context) {
    }

    public void rollbackTransaction(ConnectionContext context) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    public void deleteAllMessages() throws IOException {
        MemoryMessageStore store;
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            store = this.asMemoryMessageStore(iter.next());
            if (store == null) continue;
            store.delete();
        }
        iter = this.queues.values().iterator();
        while (iter.hasNext()) {
            store = this.asMemoryMessageStore(iter.next());
            if (store == null) continue;
            store.delete();
        }
        if (this.transactionStore != null) {
            this.transactionStore.delete();
        }
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    protected MemoryMessageStore asMemoryMessageStore(Object value) {
        if (value instanceof MemoryMessageStore) {
            return (MemoryMessageStore)value;
        }
        log.warn("Expected an instance of MemoryMessageStore but was: " + value);
        return null;
    }

    public void setUsageManager(UsageManager usageManager) {
    }
}

