/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.command.BaseCommand;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.KahaTransactionStore;
import org.apache.activemq.store.kahadaptor.TxCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KahaTransaction {
    private static final Log log = LogFactory.getLog(KahaTransaction.class);
    protected List list = new ArrayList();

    KahaTransaction() {
    }

    void add(KahaMessageStore store, BaseCommand command) {
        TxCommand tx = new TxCommand();
        tx.setCommand(command);
        tx.setMessageStoreKey(store.getId());
        this.list.add(tx);
    }

    Message[] getMessages() {
        ArrayList<BaseCommand> result = new ArrayList<BaseCommand>();
        for (int i = 0; i < this.list.size(); ++i) {
            TxCommand command = (TxCommand)this.list.get(i);
            if (!command.isAdd()) continue;
            result.add(command.getCommand());
        }
        Message[] messages = new Message[result.size()];
        return result.toArray(messages);
    }

    MessageAck[] getAcks() {
        ArrayList<BaseCommand> result = new ArrayList<BaseCommand>();
        for (int i = 0; i < this.list.size(); ++i) {
            TxCommand command = (TxCommand)this.list.get(i);
            if (!command.isRemove()) continue;
            result.add(command.getCommand());
        }
        MessageAck[] acks = new MessageAck[result.size()];
        return result.toArray(acks);
    }

    void prepare() {
    }

    void rollback() {
        this.list.clear();
    }

    void commit(KahaTransactionStore transactionStore) throws IOException {
        MessageStore ms;
        TxCommand command;
        int i;
        for (i = 0; i < this.list.size(); ++i) {
            command = (TxCommand)this.list.get(i);
            ms = transactionStore.getStoreById(command.getMessageStoreKey());
            if (!command.isAdd()) continue;
            ms.addMessage(null, (Message)command.getCommand());
        }
        for (i = 0; i < this.list.size(); ++i) {
            command = (TxCommand)this.list.get(i);
            ms = transactionStore.getStoreById(command.getMessageStoreKey());
            if (!command.isRemove()) continue;
            ms.removeMessage(null, (MessageAck)command.getCommand());
        }
    }

    List getList() {
        return new ArrayList(this.list);
    }

    void setList(List list) {
        this.list = list;
    }
}

