/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Log log = LogFactory.getLog(DefaultJDBCAdapter.class);
    protected Statements statements;
    protected boolean batchStatments = true;

    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBytes(index, data);
    }

    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doCreateTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        try {
            boolean alreadyExists = false;
            ResultSet rs = null;
            try {
                rs = c.getConnection().getMetaData().getTables(null, null, this.statements.getFullMessageTableName(), new String[]{"TABLE"});
                alreadyExists = rs.next();
            }
            catch (Throwable ignore) {
                DefaultJDBCAdapter.close(rs);
                catch (Throwable throwable) {
                    DefaultJDBCAdapter.close(rs);
                    throw throwable;
                }
            }
            DefaultJDBCAdapter.close(rs);
            s = c.getConnection().createStatement();
            String[] createStatments = this.statements.getCreateSchemaStatements();
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    log.debug("Executing SQL: " + createStatments[i]);
                    boolean rc = s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    if (alreadyExists) {
                        log.debug("Could not create JDBC tables; The message table already existed. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                        continue;
                    }
                    log.warn("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                    JDBCPersistenceAdapter.log("Failure details: ", e);
                }
            }
            c.getConnection().commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDropTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        try {
            s = c.getConnection().createStatement();
            String[] dropStatments = this.statements.getDropSchemaStatements();
            for (int i = 0; i < dropStatments.length; ++i) {
                try {
                    boolean rc = s.execute(dropStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.warn("Could not drop JDBC tables; they may not exist. Failure was: " + dropStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                    JDBCPersistenceAdapter.log("Failure details: ", e);
                }
            }
            c.getConnection().commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doGetLastMessageBrokerSequenceId(TransactionContext c) throws SQLException, IOException {
        long l;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInMsgsStatement());
            rs = s.executeQuery();
            long seq1 = 0L;
            if (rs.next()) {
                seq1 = rs.getLong(1);
            }
            rs.close();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInAcksStatement());
            rs = s.executeQuery();
            long seq2 = 0L;
            if (rs.next()) {
                seq2 = rs.getLong(1);
            }
            l = Math.max(seq1, seq2);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddMessage(TransactionContext c, MessageId messageID, ActiveMQDestination destination, byte[] data, long expiration) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
                if (this.batchStatments) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, messageID.getBrokerSequenceId());
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expiration);
            this.setBinaryData(s, 6, data);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddMessageReference(TransactionContext c, MessageId messageID, ActiveMQDestination destination, long expirationTime, String messageRef) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
                if (this.batchStatments) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, messageID.getBrokerSequenceId());
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expirationTime);
            s.setString(6, messageRef);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBrokerSequenceId(TransactionContext c, MessageId messageID) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            long l;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageSequenceIdStatement());
                s.setString(1, messageID.getProducerId().toString());
                s.setLong(2, messageID.getProducerSequenceId());
                rs = s.executeQuery();
                if (rs.next()) break block3;
                l = 0L;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return l;
        }
        long l = rs.getLong(1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doGetMessage(TransactionContext c, long seq) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
                s.setLong(1, seq);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetMessageReference(TransactionContext c, long seq) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            String string;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
                s.setLong(1, seq);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return string;
        }
        String string = rs.getString(1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveMessage(TransactionContext c, long seq) throws SQLException, IOException {
        PreparedStatement s = c.getRemovedMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getRemoveMessageStatment());
                if (this.batchStatments) {
                    c.setRemovedMessageStatement(s);
                }
            }
            s.setLong(1, seq);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to remove message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecover(TransactionContext c, ActiveMQDestination destination, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllMessagesStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                while (rs.next()) {
                    listener.recoverMessageReference(rs.getString(2));
                }
            } else {
                while (rs.next()) {
                    listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
                }
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            listener.finished();
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        listener.finished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetLastAck(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getUpdateLastAckOfDurableSubStatement());
                if (this.batchStatments) {
                    c.setUpdateLastAckStatement(s);
                }
            }
            s.setLong(1, seq);
            s.setString(2, destination.getQualifiedName());
            s.setString(3, clientId);
            s.setString(4, subscriptionName);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecoverSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDurableSubMessagesStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                while (rs.next()) {
                    listener.recoverMessageReference(rs.getString(2));
                }
            } else {
                while (rs.next()) {
                    listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
                }
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            listener.finished();
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        listener.finished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecoverNextMessages(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq, int maxReturned, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            int count;
            s = c.getConnection().prepareStatement(this.statements.getFindDurableSubMessagesStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.setLong(4, seq);
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                for (count = 0; rs.next() && count < maxReturned; ++count) {
                    listener.recoverMessageReference(rs.getString(1));
                }
            } else {
                while (rs.next() && count < maxReturned) {
                    listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
                    ++count;
                }
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            listener.finished();
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        listener.finished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doGetDurableSubscriberMessageCount(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        int result = 0;
        try {
            s = c.getConnection().prepareStatement(this.statements.getDurableSubscriberMessageCountStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            rs = s.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetSubscriberEntry(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, String selector, boolean retroactive) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            long lastMessageId = -1L;
            if (!retroactive) {
                s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInMsgsStatement());
                ResultSet rs = null;
                try {
                    rs = s.executeQuery();
                    if (rs.next()) {
                        lastMessageId = rs.getLong(1);
                    }
                }
                finally {
                    DefaultJDBCAdapter.close(rs);
                    DefaultJDBCAdapter.close(s);
                }
            }
            s = c.getConnection().prepareStatement(this.statements.getCreateDurableSubStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.setString(4, selector);
            s.setLong(5, lastMessageId);
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not create durable subscription for: " + clientId);
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionInfo doGetSubscriberEntry(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            SubscriptionInfo subscriptionInfo;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindDurableSubStatement());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriptionName);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                subscriptionInfo = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return subscriptionInfo;
        }
        SubscriptionInfo subscription = new SubscriptionInfo();
        subscription.setDestination(destination);
        subscription.setClientId(clientId);
        subscription.setSubcriptionName(subscriptionName);
        subscription.setSelector(rs.getString(1));
        SubscriptionInfo subscriptionInfo = subscription;
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionInfo[] doGetAllSubscriptions(TransactionContext c, ActiveMQDestination destination) throws SQLException, IOException {
        SubscriptionInfo[] subscriptionInfoArray;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDurableSubsStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            ArrayList<SubscriptionInfo> rc = new ArrayList<SubscriptionInfo>();
            while (rs.next()) {
                SubscriptionInfo subscription = new SubscriptionInfo();
                subscription.setDestination(destination);
                subscription.setSelector(rs.getString(1));
                subscription.setSubcriptionName(rs.getString(2));
                subscription.setClientId(rs.getString(3));
                rc.add(subscription);
            }
            subscriptionInfoArray = rc.toArray(new SubscriptionInfo[rc.size()]);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveAllMessages(TransactionContext c, ActiveMQDestination destinationName) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getRemoveAllMessagesStatement());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getRemoveAllSubscriptionsStatement());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getDeleteSubscriptionStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.executeUpdate();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteOldMessages(TransactionContext c) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            log.debug("Executing SQL: " + this.statements.getDeleteOldMessagesStatement());
            s = c.getConnection().prepareStatement(this.statements.getDeleteOldMessagesStatement());
            s.setLong(1, System.currentTimeMillis());
            int i = s.executeUpdate();
            log.debug("Deleted " + i + " old message(s).");
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    private static void close(PreparedStatement s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set doGetDestinations(TransactionContext c) throws SQLException, IOException {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDestinationsStatement());
            rs = s.executeQuery();
            while (rs.next()) {
                rc.add(ActiveMQDestination.createDestination(rs.getString(1), (byte)1));
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return rc;
    }

    public boolean isBatchStatments() {
        return this.batchStatments;
    }

    public void setBatchStatments(boolean batchStatments) {
        this.batchStatments = batchStatments;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.statements.setUseExternalMessageReferences(useExternalMessageReferences);
    }

    public Statements getStatements() {
        return this.statements;
    }

    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doGetNextDurableSubscriberMessageStatement(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriberName) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getNextDurableSubscriberMessageStatement());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriberName);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetPrevDurableSubscriberMessageIdStatement(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriberName, long id, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getPrevDurableSubscriberMessageIdStatement());
            s.setString(1, destination.getQualifiedName());
            s.setLong(2, id);
            rs = s.executeQuery();
            if (rs.next()) {
                listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
            }
            listener.finished();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetNextDurableSubscriberMessageIdStatement(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriberName, long id, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getNextDurableSubscriberMessageIdStatement());
            s.setString(1, destination.getQualifiedName());
            s.setLong(2, id);
            rs = s.executeQuery();
            if (rs.next()) {
                listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
            }
            listener.finished();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }
}

