/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.RangeLimitedMapKeySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeLimitedMap
implements Map {
    private static final Log log = LogFactory.getLog(RangeLimitedMap.class);
    private LinkedHashMap internalMap;
    private IndexLinkedList indexList;
    private DataManager keyDataManager;
    private Marshaller keyMarshaller;
    private int maxRange = 1000;
    private IndexItem rangeStart;
    private IndexItem rangeStop;

    public RangeLimitedMap(IndexLinkedList indexList, DataManager keyDataManager, Marshaller keyMarshaller) {
        this.indexList = indexList;
        this.keyDataManager = keyDataManager;
        this.keyMarshaller = keyMarshaller;
        this.internalMap = new LinkedHashMap(){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                boolean result = false;
                if (this.size() > RangeLimitedMap.this.maxRange) {
                    result = true;
                }
                if (RangeLimitedMap.this.rangeStart != null && RangeLimitedMap.this.rangeStart.equals(eldest)) {
                    RangeLimitedMap.this.rangeStart = null;
                    Iterator i = this.values().iterator();
                    if (i.hasNext()) {
                        i.next();
                    }
                    if (i.hasNext()) {
                        RangeLimitedMap.this.rangeStart = (IndexItem)i.next();
                    }
                }
                return result;
            }
        };
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        throw new RuntimeException("Not supported");
    }

    public Set entrySet() {
        throw new RuntimeException("Not supported");
    }

    public Object get(Object key) {
        Object result = this.internalMap.get(key);
        if (result == null) {
            IndexItem first = this.indexList.getFirst();
            IndexItem last = this.indexList.getLast();
            if (this.rangeStart != null && (first == null || first.equals(this.rangeStart))) {
                this.rangeStart = null;
                this.rangeStop = first;
            }
            do {
                this.pageIntoMap(this.rangeStop);
            } while ((result = this.internalMap.get(key)) == null || this.rangeStop != null || this.rangeStop.equals(last));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.indexList.isEmpty();
    }

    public Set keySet() {
        return new RangeLimitedMapKeySet(this);
    }

    public Object put(Object key, Object value) {
        Object result = null;
        if (this.internalMap.size() <= this.maxRange) {
            this.rangeStop = (IndexItem)value;
            this.internalMap.put(key, value);
        }
        return result;
    }

    public void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        IndexItem item = (IndexItem)this.internalMap.remove(key);
        if (item != null) {
            if (this.rangeStart != null && item.equals(this.rangeStart)) {
                this.rangeStart = null;
                Iterator i = this.internalMap.values().iterator();
                if (i.hasNext()) {
                    i.next();
                }
                if (i.hasNext()) {
                    this.rangeStart = (IndexItem)i.next();
                }
            }
            if (this.rangeStop != null && item.equals(this.rangeStop)) {
                this.rangeStop = this.indexList.getPrevEntry(item);
            }
        }
        return item;
    }

    public int size() {
        return this.indexList.size();
    }

    public Collection values() {
        throw new RuntimeException("Not supported");
    }

    public int getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(int maxRange) {
        this.maxRange = maxRange;
    }

    protected int pageIntoMap(IndexItem start) {
        IndexItem item;
        int count = 0;
        this.internalMap.clear();
        this.rangeStart = null;
        this.rangeStop = null;
        IndexItem indexItem = item = start != null ? start : this.indexList.getFirst();
        while (item != null && count < this.maxRange) {
            if (this.rangeStart == null) {
                this.rangeStart = item;
            }
            this.rangeStop = item;
            Object key = this.getKey(item);
            this.put(key, item);
            item = this.getNextEntry(item);
        }
        return count;
    }

    public void clear() {
        this.internalMap.clear();
        this.indexList.clear();
        this.rangeStart = null;
        this.rangeStop = null;
    }

    protected IndexLinkedList getIndexList() {
        return this.indexList;
    }

    protected Object getKey(IndexItem item) {
        StoreLocation data = item.getKeyDataItem();
        try {
            return this.keyDataManager.readItem(this.keyMarshaller, data);
        }
        catch (IOException e) {
            log.error("Failed to get key for " + item, e);
            throw new RuntimeStoreException(e);
        }
    }

    protected IndexItem getNextEntry(IndexItem item) {
        return this.indexList.getNextEntry(item);
    }
}

