/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.jndi.LazyCreateContext;
import org.apache.activemq.jndi.ReadOnlyContext;

public class ActiveMQInitialContextFactory
implements InitialContextFactory {
    private static final String[] defaultConnectionFactoryNames = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    private String connectionPrefix = "connection.";
    private String queuePrefix = "queue.";
    private String topicPrefix = "topic.";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data = new ConcurrentHashMap();
        String[] names = this.getConnectionFactoryNames(environment);
        for (int i = 0; i < names.length; ++i) {
            ActiveMQConnectionFactory factory = null;
            String name = names[i];
            try {
                factory = this.createConnectionFactory(name, environment);
            }
            catch (Exception e) {
                throw new NamingException("Invalid broker URL");
            }
            data.put(name, factory);
        }
        this.createQueues(data, environment);
        this.createTopics(data, environment);
        data.put("dynamicQueues", new LazyCreateContext(){
            private static final long serialVersionUID = 6503881346214855588L;

            protected Object createEntry(String name) {
                return new ActiveMQQueue(name);
            }
        });
        data.put("dynamicTopics", new LazyCreateContext(){
            private static final long serialVersionUID = 2019166796234979615L;

            protected Object createEntry(String name) {
                return new ActiveMQTopic(name);
            }
        });
        return this.createContext(environment, data);
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    protected ReadOnlyContext createContext(Hashtable environment, Map data) {
        return new ReadOnlyContext(environment, data);
    }

    protected ActiveMQConnectionFactory createConnectionFactory(String name, Hashtable environment) throws URISyntaxException {
        Hashtable temp = new Hashtable(environment);
        String prefix = this.connectionPrefix + name + ".";
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            temp.remove(key);
            key = key.substring(prefix.length());
            temp.put(key, entry.getValue());
        }
        return this.createConnectionFactory(temp);
    }

    protected String[] getConnectionFactoryNames(Map environment) {
        String factoryNames = (String)environment.get("connectionFactoryNames");
        if (factoryNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer enumeration = new StringTokenizer(factoryNames, ",");
            while (enumeration.hasMoreTokens()) {
                list.add(enumeration.nextToken().trim());
            }
            int size = list.size();
            if (size > 0) {
                String[] answer = new String[size];
                list.toArray(answer);
                return answer;
            }
        }
        return defaultConnectionFactoryNames;
    }

    protected void createQueues(Map data, Hashtable environment) {
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(this.queuePrefix)) continue;
            String jndiName = key.substring(this.queuePrefix.length());
            data.put(jndiName, this.createQueue(entry.getValue().toString()));
        }
    }

    protected void createTopics(Map data, Hashtable environment) {
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(this.topicPrefix)) continue;
            String jndiName = key.substring(this.topicPrefix.length());
            data.put(jndiName, this.createTopic(entry.getValue().toString()));
        }
    }

    protected Queue createQueue(String name) {
        return new ActiveMQQueue(name);
    }

    protected Topic createTopic(String name) {
        return new ActiveMQTopic(name);
    }

    protected ActiveMQConnectionFactory createConnectionFactory(Hashtable environment) throws URISyntaxException {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)environment);
        answer.setProperties(properties);
        return answer;
    }

    public String getConnectionPrefix() {
        return this.connectionPrefix;
    }

    public void setConnectionPrefix(String connectionPrefix) {
        this.connectionPrefix = connectionPrefix;
    }
}

