/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.console.filter.QueryFilter;
import org.apache.activemq.console.filter.ResultTransformFilter;
import org.apache.activemq.console.formatter.GlobalWriter;

public class MapTransformFilter
extends ResultTransformFilter {
    public MapTransformFilter(QueryFilter next) {
        super(next);
    }

    protected Object transformElement(Object object) throws Exception {
        try {
            Method method = this.getClass().getDeclaredMethod("transformToMap", object.getClass());
            return (Map)method.invoke((Object)this, object);
        }
        catch (NoSuchMethodException e) {
            GlobalWriter.print("Unable to transform mbean of type: " + object.getClass().getName() + ". No corresponding transformToMap method found.");
            return null;
        }
    }

    protected Map transformToMap(ObjectInstance obj) {
        return this.transformToMap(obj.getObjectName());
    }

    protected Map transformToMap(ObjectName objname) {
        Properties props = new Properties();
        Hashtable objProps = objname.getKeyPropertyList();
        Iterator i = objProps.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object val = objProps.get(key);
            if (val == null) continue;
            props.setProperty(key.toString(), val.toString());
        }
        return props;
    }

    protected Map transformToMap(AttributeList list) {
        Properties props = new Properties();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Attribute attrib = (Attribute)i.next();
            if (attrib.getName().equals("Attribute:ObjectName:")) {
                props.putAll((Map<?, ?>)this.transformToMap((ObjectName)attrib.getValue()));
                continue;
            }
            if (attrib.getValue() == null) continue;
            props.setProperty(attrib.getName(), attrib.getValue().toString());
        }
        return props;
    }

    protected Map transformToMap(ActiveMQTextMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.transformToMap((ActiveMQMessage)msg));
        if (msg.getText() != null) {
            props.setProperty("JMS_BODY_FIELD:JMSText", msg.getText());
        }
        return props;
    }

    protected Map transformToMap(ActiveMQBytesMessage msg) throws JMSException {
        byte[] msgBody;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.transformToMap((ActiveMQMessage)msg));
        long bodyLength = msg.getBodyLength();
        int i = 0;
        i = 0;
        while ((long)i < bodyLength / Integer.MAX_VALUE) {
            msgBody = new byte[Integer.MAX_VALUE];
            props.setProperty("JMS_BODY_FIELD:JMSBytes:" + (i + 1), new String(msgBody));
            ++i;
        }
        msgBody = new byte[(int)(bodyLength % Integer.MAX_VALUE)];
        props.setProperty("JMS_BODY_FIELD:JMSBytes:" + (i + 1), new String(msgBody));
        return props;
    }

    protected Map transformToMap(ActiveMQObjectMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.transformToMap((ActiveMQMessage)msg));
        if (msg.getObject() != null) {
            props.setProperty("JMS_BODY_FIELD:JMSObjectClass", msg.getObject().getClass().getName());
            props.setProperty("JMS_BODY_FIELD:JMSObjectString", msg.getObject().toString());
        }
        return props;
    }

    protected Map transformToMap(ActiveMQMapMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.transformToMap((ActiveMQMessage)msg));
        Enumeration e = msg.getMapNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = msg.getObject(key);
            if (val == null) continue;
            props.setProperty("JMS_BODY_FIELD:" + key, val.toString());
        }
        return props;
    }

    protected Map transformToMap(ActiveMQStreamMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.transformToMap((ActiveMQMessage)msg));
        props.setProperty("JMS_BODY_FIELD:JMSStreamMessage", msg.toString());
        return props;
    }

    protected Map transformToMap(ActiveMQMessage msg) throws JMSException {
        Properties props = new Properties();
        if (msg.getJMSCorrelationID() != null) {
            props.setProperty("JMS_HEADER_FIELD:JMSCorrelationID", msg.getJMSCorrelationID());
        }
        props.setProperty("JMS_HEADER_FIELD:JMSDeliveryMode", msg.getJMSDeliveryMode() == 2 ? "persistent" : "non-persistent");
        if (msg.getJMSDestination() != null) {
            props.setProperty("JMS_HEADER_FIELD:JMSDestination", ((ActiveMQDestination)msg.getJMSDestination()).getPhysicalName());
        }
        props.setProperty("JMS_HEADER_FIELD:JMSExpiration", Long.toString(msg.getJMSExpiration()));
        props.setProperty("JMS_HEADER_FIELD:JMSMessageID", msg.getJMSMessageID());
        props.setProperty("JMS_HEADER_FIELD:JMSPriority", Integer.toString(msg.getJMSPriority()));
        props.setProperty("JMS_HEADER_FIELD:JMSRedelivered", Boolean.toString(msg.getJMSRedelivered()));
        if (msg.getJMSReplyTo() != null) {
            props.setProperty("JMS_HEADER_FIELD:JMSReplyTo", ((ActiveMQDestination)msg.getJMSReplyTo()).getPhysicalName());
        }
        props.setProperty("JMS_HEADER_FIELD:JMSTimestamp", Long.toString(msg.getJMSTimestamp()));
        if (msg.getJMSType() != null) {
            props.setProperty("JMS_HEADER_FIELD:JMSType", msg.getJMSType());
        }
        Enumeration e = msg.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (msg.getObjectProperty(name) == null) continue;
            props.setProperty("JMS_CUSTOM_FIELD:" + name, msg.getObjectProperty(name).toString());
        }
        return props;
    }

    protected Map transformToMap(CompositeDataSupport data) {
        Properties props = new Properties();
        String typeName = data.getCompositeType().getTypeName();
        if (typeName.equals(ActiveMQTextMessage.class.getName())) {
            props.setProperty("JMS_BODY_FIELD:Text", data.get("Text").toString());
        } else if (typeName.equals(ActiveMQBytesMessage.class.getName())) {
            props.setProperty("JMS_BODY_FIELD:BodyLength", data.get("BodyLength").toString());
            props.setProperty("JMS_BODY_FIELD:BodyPreview", new String((byte[])data.get("BodyPreview")));
        } else if (typeName.equals(ActiveMQMapMessage.class.getName())) {
            Map contentMap = (Map)data.get("ContentMap");
            Iterator i = contentMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                props.setProperty("JMS_BODY_FIELD:" + key, contentMap.get(key).toString());
            }
        } else if (!(typeName.equals(ActiveMQObjectMessage.class.getName()) || typeName.equals(ActiveMQStreamMessage.class.getName()) || typeName.equals(ActiveMQMessage.class.getName()))) {
            throw new IllegalArgumentException("Unrecognized composite data to transform. composite type: " + typeName);
        }
        props.setProperty("JMS_HEADER_FIELD:JMSCorrelationID", "" + data.get("JMSCorrelationID"));
        props.setProperty("JMS_HEADER_FIELD:JMSDestination", "" + data.get("JMSDestination"));
        props.setProperty("JMS_HEADER_FIELD:JMSMessageID", "" + data.get("JMSMessageID"));
        props.setProperty("JMS_HEADER_FIELD:JMSReplyTo", "" + data.get("JMSReplyTo"));
        props.setProperty("JMS_HEADER_FIELD:JMSType", "" + data.get("JMSType"));
        props.setProperty("JMS_HEADER_FIELD:JMSDeliveryMode", "" + data.get("JMSDeliveryMode"));
        props.setProperty("JMS_HEADER_FIELD:JMSExpiration", "" + data.get("JMSExpiration"));
        props.setProperty("JMS_HEADER_FIELD:JMSPriority", "" + data.get("JMSPriority"));
        props.setProperty("JMS_HEADER_FIELD:JMSRedelivered", "" + data.get("JMSRedelivered"));
        props.setProperty("JMS_HEADER_FIELD:JMSTimestamp", "" + data.get("JMSTimestamp"));
        props.setProperty("JMS_CUSTOM_FIELD:Properties", "" + data.get("Properties"));
        return props;
    }
}

