/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.filter.AbstractQueryFilter;
import org.apache.activemq.console.filter.MBeansObjectNameQueryFilter;

public class MBeansAttributeQueryFilter
extends AbstractQueryFilter {
    public static final String KEY_OBJECT_NAME_ATTRIBUTE = "Attribute:ObjectName:";
    private JMXServiceURL jmxServiceUrl;
    private Set attribView;

    public MBeansAttributeQueryFilter(JMXServiceURL jmxServiceUrl, Set attribView, MBeansObjectNameQueryFilter next) {
        super(next);
        this.jmxServiceUrl = jmxServiceUrl;
        this.attribView = attribView;
    }

    public List query(List queries) throws Exception {
        return this.getMBeanAttributesCollection(this.next.query(queries));
    }

    protected List getMBeanAttributesCollection(Collection result) throws IOException, ReflectionException, InstanceNotFoundException, NoSuchMethodException, IntrospectionException {
        ArrayList<AttributeList> mbeansCollection = new ArrayList<AttributeList>();
        Iterator i = result.iterator();
        while (i.hasNext()) {
            Object mbean = i.next();
            if (mbean instanceof ObjectInstance) {
                mbeansCollection.add(this.getMBeanAttributes(((ObjectInstance)mbean).getObjectName(), this.attribView));
                continue;
            }
            if (mbean instanceof ObjectName) {
                mbeansCollection.add(this.getMBeanAttributes((ObjectName)mbean, this.attribView));
                continue;
            }
            throw new NoSuchMethodException("Cannot get the mbean attributes for class: " + mbean.getClass().getName());
        }
        return mbeansCollection;
    }

    protected AttributeList getMBeanAttributes(ObjectInstance obj, Set attrView) throws ReflectionException, InstanceNotFoundException, IOException, IntrospectionException {
        return this.getMBeanAttributes(obj.getObjectName(), attrView);
    }

    protected AttributeList getMBeanAttributes(ObjectName objName, Set attrView) throws IOException, ReflectionException, InstanceNotFoundException, IntrospectionException {
        String[] attribs;
        JMXConnector jmxConnector = JMXConnectorFactory.connect(this.jmxServiceUrl);
        MBeanServerConnection server = jmxConnector.getMBeanServerConnection();
        if (attrView == null || attrView.isEmpty()) {
            MBeanAttributeInfo[] infos = server.getMBeanInfo(objName).getAttributes();
            attribs = new String[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].isReadable()) continue;
                attribs[i] = infos[i].getName();
            }
        } else {
            attribs = new String[attrView.size()];
            int count = 0;
            Iterator i = attrView.iterator();
            while (i.hasNext()) {
                attribs[count++] = (String)i.next();
            }
        }
        AttributeList attribList = server.getAttributes(objName, attribs);
        jmxConnector.close();
        attribList.add(0, new Attribute(KEY_OBJECT_NAME_ATTRIBUTE, objName));
        return attribList;
    }
}

