/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.formatter.GlobalWriter;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class ShutdownCommand
extends AbstractJmxCommand {
    private boolean isStopAllBrokers = false;
    protected String[] helpFile = new String[]{"Task Usage: Main stop [stop-options] [broker-name1] [broker-name2] ...", "Description: Stops a running broker.", "", "Stop Options:", "    --jmxurl <url>      Set the JMX URL to connect to.", "    --all               Stop all brokers.", "    --version           Display the version information.", "    -h,-?,--help        Display the stop broker help information.", "", "Broker Names:", "    Name of the brokers that will be stopped.", "    If omitted, it is assumed that there is only one broker running, and it will be stopped.", "    Use -all to stop all running brokers.", ""};

    protected void runTask(List brokerNames) throws Exception {
        try {
            Collection mbeans;
            if (this.isStopAllBrokers) {
                mbeans = JmxMBeansUtil.getAllBrokers(this.useJmxServiceUrl());
                brokerNames.clear();
            } else if (brokerNames.isEmpty()) {
                mbeans = JmxMBeansUtil.getAllBrokers(this.useJmxServiceUrl());
                if (mbeans.isEmpty()) {
                    GlobalWriter.printInfo("There are no brokers to stop.");
                    return;
                }
                if (mbeans.size() > 1) {
                    GlobalWriter.printInfo("There are multiple brokers to stop. Please select the broker(s) to stop or use --all to stop all brokers.");
                    return;
                }
                Object firstBroker = mbeans.iterator().next();
                mbeans.clear();
                mbeans.add(firstBroker);
            } else {
                mbeans = new HashSet();
                while (!brokerNames.isEmpty()) {
                    String brokerName = (String)brokerNames.remove(0);
                    List matchedBrokers = JmxMBeansUtil.getBrokersByName(this.useJmxServiceUrl(), brokerName);
                    if (matchedBrokers.isEmpty()) {
                        GlobalWriter.printInfo(brokerName + " did not match any running brokers.");
                        continue;
                    }
                    mbeans.addAll(matchedBrokers);
                }
            }
            this.stopBrokers(this.useJmxServiceUrl(), mbeans);
        }
        catch (Exception e) {
            GlobalWriter.printException(new RuntimeException("Failed to execute stop task. Reason: " + e));
            throw new Exception(e);
        }
    }

    protected void stopBrokers(JMXServiceURL jmxServiceUrl, Collection brokerBeans) throws Exception {
        MBeanServerConnection server = this.createJmxConnector().getMBeanServerConnection();
        Iterator i = brokerBeans.iterator();
        while (i.hasNext()) {
            ObjectName brokerObjName = ((ObjectInstance)i.next()).getObjectName();
            String brokerName = brokerObjName.getKeyProperty("BrokerName");
            GlobalWriter.print("Stopping broker: " + brokerName);
            try {
                server.invoke(brokerObjName, "terminateJVM", new Object[]{new Integer(0)}, new String[]{"int"});
                GlobalWriter.print("Succesfully stopped broker: " + brokerName);
            }
            catch (Exception e) {}
        }
        this.closeJmxConnector();
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.equals("--all")) {
            this.isStopAllBrokers = true;
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void printHelp() {
        GlobalWriter.printHelp(this.helpFile);
    }
}

