/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.console.command.AmqBrowseCommand;
import org.apache.activemq.console.command.ListCommand;
import org.apache.activemq.console.command.PurgeCommand;
import org.apache.activemq.console.command.QueryCommand;
import org.apache.activemq.console.command.ShutdownCommand;
import org.apache.activemq.console.command.StartCommand;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;
import org.apache.activemq.console.formatter.GlobalWriter;

public class ShellCommand
extends AbstractCommand {
    protected String[] helpFile = new String[]{"Usage: Main [--extdir <dir>] [task] [task-options] [task data]", "", "Tasks (default task is start):", "    start           - Creates and starts a broker using a configuration file, or a broker URI.", "    stop            - Stops a running broker specified by the broker name.", "    list            - Lists all available brokers in the specified JMX context.", "    query           - Display selected broker component's attributes and statistics.", "    browse          - Display selected messages in a specified destination.", "", "Task Options (Options specific to each task):", "    --extdir <dir>  - Add the jar files in the directory to the classpath.", "    --version       - Display the version information.", "    -h,-?,--help    - Display this help information. To display task specific help, use Main [task] -h,-?,--help", "", "Task Data:", "    - Information needed by each specific task.", ""};

    public static int main(String[] args, InputStream in, PrintStream out) {
        GlobalWriter.instantiate(new CommandShellOutputFormatter(out));
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(args));
        ShellCommand main = new ShellCommand();
        try {
            main.execute(tokens);
            return 0;
        }
        catch (Exception e) {
            GlobalWriter.printException(e);
            return -1;
        }
    }

    protected void runTask(List tokens) throws Exception {
        if (tokens.size() > 0) {
            String taskToken = (String)tokens.remove(0);
            if (taskToken.equals("start")) {
                new StartCommand().execute(tokens);
            } else if (taskToken.equals("stop")) {
                new ShutdownCommand().execute(tokens);
            } else if (taskToken.equals("list")) {
                new ListCommand().execute(tokens);
            } else if (taskToken.equals("query")) {
                new QueryCommand().execute(tokens);
            } else if (taskToken.equals("browse")) {
                new AmqBrowseCommand().execute(tokens);
            } else if (taskToken.equals("purge")) {
                new PurgeCommand().execute(tokens);
            } else {
                tokens.add(0, taskToken);
                new StartCommand().execute(tokens);
            }
        } else {
            new StartCommand().execute(tokens);
        }
    }

    protected void printHelp() {
        GlobalWriter.printHelp(this.helpFile);
    }
}

