/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.Iterator;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.kahadaptor.CommandMarshaller;

public class FilePendingMessageCursor
extends AbstractPendingMessageCursor {
    private ListContainer list;
    private Iterator iter = null;
    private Destination regionDestination;

    public FilePendingMessageCursor(String name, Store store) {
        try {
            this.list = store.getListContainer(name);
            this.list.setMarshaller(new CommandMarshaller(new OpenWireFormat()));
            this.list.setMaximumCacheSize(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void reset() {
        this.iter = this.list.listIterator();
    }

    public void addMessageLast(MessageReference node) {
        try {
            this.regionDestination = node.getMessage().getRegionDestination();
            node.decrementReferenceCount();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.list.addLast(node);
    }

    public void addMessageFirst(MessageReference node) {
        try {
            this.regionDestination = node.getMessage().getRegionDestination();
            node.decrementReferenceCount();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.list.addFirst(node);
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public MessageReference next() {
        Message message = (Message)this.iter.next();
        message.setRegionDestination(this.regionDestination);
        message.incrementReferenceCount();
        return message;
    }

    public void remove() {
        this.iter.remove();
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }
}

