/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.lang.ref.Reference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceSet<T>
extends AbstractSet<T> {
    private HashSet<Reference<T>> contents = null;

    public ReferenceSet() {
        this.contents = new HashSet();
    }

    public ReferenceSet(int n) {
        this.contents = new HashSet(n);
    }

    public ReferenceSet(Collection<T> c) {
        if (c == null) {
            throw new NullPointerException("Null collection provided to ReferenceSet");
        }
        this.contents = new HashSet(c.size() * 2);
        for (T o : c) {
            this.add(o);
        }
    }

    @Override
    public boolean add(T o) {
        boolean rv = false;
        if (!this.contains(o)) {
            this.contents.add(this.getReference(o));
            rv = true;
        }
        return rv;
    }

    @Override
    public int size() {
        int rv = 0;
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            i.next();
            ++rv;
        }
        return rv;
    }

    @Override
    public Iterator<T> iterator() {
        return new ReferenceIterator<T>(this.contents.iterator());
    }

    protected abstract Reference<T> getReference(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceIterator<T>
    implements Iterator<T> {
        private Iterator<Reference<T>> backIterator = null;
        private boolean hasNext = false;
        private T current = null;
        private Reference<T> currentRef = null;

        public ReferenceIterator(Iterator<Reference<T>> i) {
            this.backIterator = i;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (!this.hasNext) {
                throw new NoSuchElementException("All out.");
            }
            T rv = this.current;
            this.findNext();
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This is currently not supported");
        }

        private void findNext() {
            this.current = null;
            while (this.current == null && this.backIterator.hasNext()) {
                this.currentRef = this.backIterator.next();
                this.current = this.currentRef.get();
                if (this.current != null) continue;
                this.backIterator.remove();
            }
            this.hasNext = this.current != null;
        }
    }
}

