/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range<T extends Comparable<T>>
implements Comparable<Range<T>> {
    private T low = null;
    private T high = null;
    private MatchType lowMatch = MatchType.INCLUSIVE;
    private MatchType highMatch = MatchType.INCLUSIVE;

    public Range(T lowObject, T highObject) {
        this.low = lowObject;
        this.high = highObject;
        this.invariant();
    }

    private void invariant() {
        if (this.low == null && this.high == null) {
            throw new IllegalArgumentException("At least one of the low or high object must be set.");
        }
        if (this.low != null && this.high != null && this.low.compareTo(this.high) > 0) {
            throw new IllegalArgumentException("Low object must not be greater than the high object");
        }
    }

    public MatchType getLowMatch() {
        return this.lowMatch;
    }

    public void setLowMatch(MatchType lm) {
        this.lowMatch = lm;
    }

    public MatchType getHighMatch() {
        return this.highMatch;
    }

    public void setHighMatch(MatchType hm) {
        this.highMatch = hm;
    }

    public Comparable<T> getLow() {
        return this.low;
    }

    public Comparable<T> getHigh() {
        return this.high;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("{Range ");
        if (this.lowMatch == MatchType.INCLUSIVE) {
            sb.append('[');
        } else {
            sb.append('(');
        }
        sb.append(this.low);
        sb.append(", ");
        sb.append(this.high);
        if (this.highMatch == MatchType.INCLUSIVE) {
            sb.append(']');
        } else {
            sb.append(')');
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean contains(T c) {
        boolean rv = true;
        int lowCompare = 0;
        int highCompare = 0;
        if (this.lowMatch == MatchType.EXCLUSIVE) {
            lowCompare = 1;
        }
        if (this.highMatch == MatchType.EXCLUSIVE) {
            highCompare = -1;
        }
        if (c != null) {
            if (this.low != null && this.high != null && this.low.equals(this.high)) {
                if (c.compareTo(this.low) != 0) {
                    rv = false;
                }
            } else {
                if (this.low != null && c.compareTo(this.low) < lowCompare) {
                    rv = false;
                }
                if (this.high != null && c.compareTo(this.high) > highCompare) {
                    rv = false;
                }
            }
        } else {
            rv = false;
        }
        return rv;
    }

    @Override
    public int compareTo(Range<T> r) {
        int rv = this.compareLow(this, r);
        if (rv == 0) {
            rv = this.compareHigh(this, r);
        }
        return rv;
    }

    public boolean equals(Object o) {
        boolean rv = false;
        if (o instanceof Range) {
            rv = this.compareTo((Range)o) == 0;
        }
        return rv;
    }

    public int hashCode() {
        return this.low != null ? this.low.hashCode() : this.high.hashCode();
    }

    private int compareLow(Range<T> a, Range<T> b) {
        int rv = 0;
        if (a.low != null || b.low != null) {
            rv = a.low != null && b.low != null ? a.low.compareTo(b.low) : (a.low == null ? -1 : 1);
        }
        return rv;
    }

    private int compareHigh(Range<T> a, Range<T> b) {
        int rv = 0;
        if (a.high != null || b.high != null) {
            rv = a.high != null && b.high != null ? a.high.compareTo(b.high) : (a.high == null ? 1 : -1);
        }
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchType {
        INCLUSIVE,
        EXCLUSIVE;

    }
}

