/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.spy.util.InterfaceImplementor;
import net.spy.util.SpyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyInterfaceImplementor
extends InterfaceImplementor {
    public ProxyInterfaceImplementor(Class<?> c) {
        super(c);
    }

    @Override
    protected boolean buildConstructors() {
        return false;
    }

    @Override
    protected String preConstructors() {
        Class<?> i = this.getInterface();
        String ret = "\tprivate " + i.getName() + " proxyedObject=null;\n\n";
        ret = ret + "\t/**\n\t * Get a " + this.getOutClassName() + " proxying the provided object.\n" + "\t */\n";
        ret = ret + "\tprotected " + this.getOutClassName() + "(" + i.getName() + " p) {\n" + "\t\tsuper();\n" + "\t\tthis.proxyedObject=p;\n" + "\t}\n\n";
        return ret;
    }

    @Override
    protected String preMethods() {
        Class<?> i = this.getInterface();
        String rv = null;
        rv = "\t/**\n\t * Get the proxied object.\n\t */\n";
        rv = rv + "\tprotected " + i.getName() + " getProxiedObject() {\n" + "\t\treturn(proxyedObject);\n" + "\t}\n";
        rv = rv + "\t/**\n\t * Set the proxied object.\n\t */\n";
        rv = rv + "\tprotected void setProxiedObject(" + i.getName() + " o) {\n" + "\t\tthis.proxyedObject=o;\n" + "\t}\n";
        return rv;
    }

    @Override
    protected String implement(Method method) {
        String ret = "\t/**\n\t * ProxyInterfaceImplementor implementation of " + method.getName() + ".\n" + "\t * @see " + this.getInterface().getName() + "#" + this.getDocLink(method) + "\n" + "\t */\n";
        ret = ret + "\t" + this.getSignature(method) + " {\n";
        Class<?>[] types = method.getParameterTypes();
        ArrayList<String> l = new ArrayList<String>(types.length);
        for (int i = 0; i < types.length; ++i) {
            l.add("a" + i);
        }
        String params = SpyUtil.join(l, ", ");
        Class<?> rt = method.getReturnType();
        ret = rt == Void.TYPE ? ret + "\t\tproxyedObject." + method.getName() + "(" + params + ");\n" : ret + "\t\treturn(proxyedObject." + method.getName() + "(" + params + "));\n";
        ret = ret + "\t}\n\n";
        return ret;
    }

    private static void usage() {
        System.err.println("Usage:  ProxyInterfaceImplementor -interface className [-outputclass className]\n\t[-outputdir outputDir] [-superclass className]");
    }

    public static void main(String[] args) throws Exception {
        String superclassName = null;
        String interfaceName = null;
        String outclass = null;
        String outdir = ".";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-superclass")) {
                superclassName = args[++i];
                continue;
            }
            if (args[i].equals("-interface")) {
                interfaceName = args[++i];
                continue;
            }
            if (args[i].equals("-outputclass")) {
                outclass = args[++i];
                continue;
            }
            if (args[i].equals("-outputdir")) {
                outdir = args[++i];
                continue;
            }
            System.err.println("Unknown argument:  " + args[i]);
            ProxyInterfaceImplementor.usage();
            throw new Exception("Unknown argument:  " + args[i]);
        }
        if (interfaceName == null) {
            System.err.println("No superinterface given.");
            ProxyInterfaceImplementor.usage();
            throw new Exception("No superinterface given.");
        }
        ProxyInterfaceImplementor i = new ProxyInterfaceImplementor(Class.forName(interfaceName));
        if (superclassName != null) {
            System.out.println("Loading super class:  " + superclassName);
            i.setSuperClass(Class.forName(superclassName));
        }
        if (outclass != null) {
            i.setOutputClass(outclass);
            i.writeSourceToFile(outdir);
        } else {
            System.out.print(i.makeSource());
        }
    }
}

