/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.spy.SpyObject;

public class NetStringDecoder
extends SpyObject {
    private static final int MAX_LEN_LEN = 6;
    private static final int MAX_LEN = 65535;
    private String encoding = null;

    public NetStringDecoder(String enc) {
        this.encoding = enc;
    }

    public String decodeString(InputStream is) throws IOException {
        int r;
        StringBuilder sizeBuf = new StringBuilder(10);
        boolean haveSize = false;
        while (!haveSize) {
            int c = is.read();
            if (c == -1) {
                throw new EOFException("End of stream reading size");
            }
            if (c == 48 || c == 49 || c == 50 || c == 51 || c == 52 || c == 53 || c == 54 || c == 55 || c == 56 || c == 57) {
                sizeBuf.append((char)c);
                if (sizeBuf.length() <= 6) continue;
                throw new IOException("Length of netstring length too long:  " + sizeBuf);
            }
            if (c == 58) {
                haveSize = true;
                continue;
            }
            throw new IOException("Illegal character in netstring size:  " + (char)c);
        }
        int size = Integer.parseInt(sizeBuf.toString());
        if (size > 65535) {
            throw new IOException("Netstring too long:  " + size);
        }
        byte[] tmp = new byte[size];
        for (int bytesread = 0; bytesread < size; bytesread += r) {
            r = is.read(tmp, bytesread, size - bytesread);
            if (r != -1) continue;
            throw new EOFException("EOF waiting for netstring");
        }
        int c = is.read();
        if (c != 44) {
            throw new IOException("Expected comma");
        }
        String rv = new String(tmp, this.encoding);
        return rv;
    }
}

