/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.IOException;
import java.io.InputStream;
import net.spy.util.Base64;
import net.spy.util.ByteConverionInputStream;

public class Base64InputStream
extends ByteConverionInputStream {
    private Base64 base64 = new Base64();
    private int currentOut = 9;
    private byte[] outbuffer = null;

    public Base64InputStream(InputStream is) {
        super(is);
    }

    public int read() throws IOException {
        int rv = -1;
        if (this.outbuffer == null || this.currentOut >= this.outbuffer.length) {
            this.decodeMore();
        }
        if (this.outbuffer.length > 0) {
            rv = this.outbuffer[this.currentOut++] & 0xFF;
        }
        return rv;
    }

    private void decodeMore() throws IOException {
        byte[] tmp = new byte[4];
        boolean more = true;
        int bytesread = 0;
        for (bytesread = 0; bytesread < 4 && more; ++bytesread) {
            int input = this.in.read();
            if (input < 0) {
                more = false;
                continue;
            }
            if (this.base64.isValidBase64Char((char)input)) {
                tmp[bytesread] = (byte)input;
                continue;
            }
            --bytesread;
        }
        String todecode = null;
        if (bytesread < 4) {
            byte[] tmptmp = new byte[bytesread];
            System.arraycopy(tmp, 0, tmptmp, 0, bytesread);
            todecode = new String(tmptmp);
        } else {
            todecode = new String(tmp);
        }
        this.outbuffer = this.base64.decode(todecode);
        this.currentOut = 0;
    }

    public int available() throws IOException {
        int rv = this.in.available();
        rv = rv * 3 / 4;
        return rv;
    }
}

