/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.spy.SpyObject;
import net.spy.util.SPNode;
import net.spy.util.SPVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSPNode<T extends SPNode<T>>
extends SpyObject
implements SPNode<T> {
    private SortedSet<SPVertex<T>> links = null;
    private Map<SPNode<T>, SPVertex<T>> nextHops = null;

    protected AbstractSPNode(SortedSet<SPVertex<T>> l) {
        this.links = l;
        this.nextHops = new WeakHashMap<SPNode<T>, SPVertex<T>>();
    }

    protected AbstractSPNode() {
        this(new TreeSet<SPVertex<T>>());
    }

    protected void linkTo(T n, int cost) {
        this.links.add(new SPVertex<T>(n, cost));
    }

    protected void linkTo(T n) {
        this.linkTo(n, 10);
    }

    @Override
    public SortedSet<SPVertex<T>> getConnections() {
        return Collections.unmodifiableSortedSet(this.links);
    }

    @Override
    public Map<SPNode<T>, SPVertex<T>> getNextHops() {
        return Collections.unmodifiableMap(this.nextHops);
    }

    @Override
    public void clearNextHops() {
        this.nextHops.clear();
    }

    @Override
    public SPVertex<T> getNextHop(SPNode<T> n) {
        return this.nextHops.get(n);
    }

    @Override
    public void addNextHop(SPNode<T> n, SPVertex<T> v) {
        this.nextHops.put(n, v);
    }

    @Override
    public boolean equals(Object o) {
        boolean rv = false;
        try {
            rv = this.compareTo((SPNode)o) == 0;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return rv;
    }

    @Override
    public abstract int hashCode();
}

