/*
 * Decompiled with CFR 0.152.
 */
package net.spy.stat;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.SpyObject;
import net.spy.stat.ComputingStat;
import net.spy.stat.CounterStat;
import net.spy.stat.Stat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats
extends SpyObject {
    private static Stats instance = null;
    private ConcurrentMap<String, Stat> stats = new ConcurrentHashMap<String, Stat>();

    protected Stats() {
    }

    public static synchronized Stats getInstance() {
        if (instance == null) {
            instance = new Stats();
        }
        return instance;
    }

    public static synchronized void setInstance(Stats to) {
        instance = to;
    }

    public static Stat getStat(String name, Class<? extends Stat> kind) {
        Stats s = Stats.getInstance();
        Stat rv = (Stat)s.stats.get(name);
        if (rv == null) {
            try {
                rv = kind.newInstance();
                rv.setName(name);
                Stat oldStat = s.stats.putIfAbsent(name, rv);
                if (oldStat != null) {
                    rv = oldStat;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create a " + kind, e);
            }
        }
        assert (kind.isAssignableFrom(rv.getClass())) : rv + " is not an instance of " + kind;
        return rv;
    }

    public static CounterStat getCounterStat(String name) {
        return (CounterStat)Stats.getStat(name, CounterStat.class);
    }

    public static ComputingStat getComputingStat(String name) {
        return (ComputingStat)Stats.getStat(name, ComputingStat.class);
    }

    public static Stat getStat(String name) {
        return (Stat)Stats.getInstance().stats.get(name);
    }

    public Map<String, Stat> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }
}

