/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import net.spy.SpyObject;
import net.spy.pool.PoolAble;
import net.spy.pool.PoolException;

public class PooledObject
extends SpyObject {
    private PoolAble poolAble = null;

    public PooledObject(PoolAble p) {
        this.poolAble = p;
        this.poolAble.checkOut();
    }

    public Object getObject() throws PoolException {
        return this.poolAble.getObject();
    }

    public boolean isAlive() {
        return this.poolAble.isAlive();
    }

    public void checkIn() {
        this.poolAble.checkIn();
        this.poolAble = null;
    }

    public int getObjectID() {
        return this.poolAble.getObjectID();
    }

    protected void finalize() {
        if (this.poolAble != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Finalization checking in object %s", this.poolAble.getObjectID());
            }
            this.poolAble.checkIn();
        }
    }
}

