/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import net.spy.pool.PoolAble;
import net.spy.pool.PoolException;
import net.spy.util.SpyConfig;

public abstract class PoolFiller {
    private SpyConfig conf = null;
    private String name = null;
    private int poolHash = 0;

    public PoolFiller() {
    }

    public PoolFiller(String nm, SpyConfig cnf) {
        this();
        this.conf = cnf;
        this.name = nm;
    }

    public void setPoolHash(int to) {
        this.poolHash = to;
    }

    protected int getPoolHash() {
        return this.poolHash;
    }

    protected String debugName() {
        return this.name + " @" + Integer.toHexString(this.poolHash);
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public void setConfig(SpyConfig cnf) {
        this.conf = cnf;
    }

    public SpyConfig getConfig() {
        return this.conf;
    }

    public abstract PoolAble getObject() throws PoolException;

    protected int getPropertyInt(String what, int def) {
        return this.conf.getInt(this.name + "." + what, def);
    }

    protected String getProperty(String what, String def) {
        return this.conf.get(this.name + "." + what, def);
    }

    protected String getProperty(String what) {
        return this.conf.get(this.name + "." + what);
    }
}

