/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.spy.pool.PoolAble;

public class JDBCPoolAble
extends PoolAble {
    public JDBCPoolAble(Object theObject, int poolHash) {
        super(theObject, poolHash);
    }

    public JDBCPoolAble(Object theObject, long maxAge, int poolHash) {
        super(theObject, maxAge, poolHash);
    }

    public void discard() {
        try {
            Connection c = (Connection)this.intGetObject();
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error on finalize!  ObjectID=%s", this.getObjectID(), e);
        }
        super.discard();
    }

    public boolean isAlive() {
        boolean ret = false;
        try {
            Connection c = (Connection)this.intGetObject();
            Statement st = c.createStatement();
            st.setQueryTimeout(5);
            ResultSet rs = st.executeQuery("select 7");
            rs.next();
            int r = rs.getInt(1);
            ret = r == 7;
            rs.close();
            st.close();
        }
        catch (Exception e) {
            this.setUnavailable();
        }
        return ret;
    }

    public synchronized void checkIn() {
        try {
            SQLWarning sw;
            Connection c = (Connection)this.intGetObject();
            if (c != null && (sw = c.getWarnings()) != null) {
                while (sw != null) {
                    this.getLogger().warn(sw, sw);
                    sw = sw.getNextWarning();
                }
                c.clearWarnings();
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error checking in DB connection", e);
        }
        super.checkIn();
    }
}

