/*
 * Decompiled with CFR 0.152.
 */
package net.spy.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.spy.util.CloseUtil;
import net.spy.util.SpyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPFetch {
    private URL url;
    private String contents = null;
    private String stripped = null;
    private Map<String, List<String>> headers = null;
    private long ifModifiedSince = 0L;
    private int status = 0;
    private long lastModified = 0L;
    private Map<String, List<String>> responseHeaders = null;

    public HTTPFetch(URL u) {
        this(u, null);
    }

    public HTTPFetch(URL u, Map<String, List<String>> head) {
        this.url = u;
        this.headers = head;
    }

    public Map<String, List<String>> getResponseHeaders() throws IOException {
        this.getData();
        return this.responseHeaders;
    }

    public void setIfModifiedSince(long to) {
        this.ifModifiedSince = to;
    }

    public int getStatus() throws IOException {
        this.getData();
        return this.status;
    }

    public long getLastModified() throws IOException {
        this.getData();
        return this.lastModified;
    }

    public List<String> getLines() throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getData(), "\r\n");
        while (st.hasMoreTokens()) {
            a.add(st.nextToken());
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() throws IOException {
        if (this.contents == null) {
            StringBuilder sb = new StringBuilder(256);
            BufferedReader br = null;
            try {
                String line;
                br = this.getReader();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            finally {
                CloseUtil.close(br);
            }
            this.contents = sb.toString();
        }
        return this.contents;
    }

    public String getStrippedData() throws Exception {
        this.getData();
        if (this.stripped == null) {
            this.stripped = SpyUtil.deHTML(this.contents);
        }
        return this.stripped;
    }

    private BufferedReader getReader() throws IOException {
        HttpURLConnection uc = (HttpURLConnection)this.url.openConnection();
        if (this.headers != null) {
            for (Map.Entry<String, List<String>> me : this.headers.entrySet()) {
                for (String val : me.getValue()) {
                    uc.setRequestProperty(me.getKey(), val);
                }
            }
        }
        if (this.ifModifiedSince > 0L) {
            uc.setIfModifiedSince(this.ifModifiedSince);
        }
        InputStream i = uc.getInputStream();
        this.status = uc.getResponseCode();
        this.responseHeaders = new HashMap<String, List<String>>(uc.getHeaderFields());
        this.lastModified = uc.getLastModified();
        BufferedReader br = new BufferedReader(new InputStreamReader(i));
        return br;
    }

    public static void main(String[] args) throws Exception {
        HTTPFetch hf = new HTTPFetch(new URL(args[0]));
        System.out.println(hf.getStrippedData());
    }
}

