/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

public final class TranscoderUtils {
    public static byte[] encodeNum(long l, int maxBytes) {
        int firstNonZero;
        byte[] rv = new byte[maxBytes];
        for (int i = 0; i < rv.length; ++i) {
            int pos = rv.length - i - 1;
            rv[pos] = (byte)(l >> 8 * i & 0xFFL);
        }
        for (firstNonZero = 0; firstNonZero < rv.length && rv[firstNonZero] == 0; ++firstNonZero) {
        }
        if (firstNonZero > 0) {
            byte[] tmp = new byte[rv.length - firstNonZero];
            System.arraycopy(rv, firstNonZero, tmp, 0, rv.length - firstNonZero);
            rv = tmp;
        }
        return rv;
    }

    public static byte[] encodeLong(long l) {
        return TranscoderUtils.encodeNum(l, 8);
    }

    public static long decodeLong(byte[] b) {
        long rv = 0L;
        for (int n : b) {
            rv = rv << 8 | (long)(n < 0 ? 256 + n : n);
        }
        return rv;
    }

    public static byte[] encodeInt(int in) {
        return TranscoderUtils.encodeNum(in, 4);
    }

    public static int decodeInt(byte[] in) {
        assert (in.length <= 4) : "Too long to be an int (" + in.length + ") bytes";
        return (int)TranscoderUtils.decodeLong(in);
    }

    public static byte[] encodeByte(byte in) {
        return new byte[]{in};
    }

    public static byte decodeByte(byte[] in) {
        assert (in.length <= 1) : "Too long for a byte";
        byte rv = 0;
        if (in.length == 1) {
            rv = in[0];
        }
        return rv;
    }

    public static byte[] encodeBoolean(boolean b) {
        byte[] rv = new byte[]{(byte)(b ? 49 : 48)};
        return rv;
    }

    public static boolean decodeBoolean(byte[] in) {
        assert (in.length == 1) : "Wrong length for a boolean";
        return in[0] == 49;
    }
}

