/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.spy.SpyObject;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.transcoders.TranscoderUtils;
import net.spy.util.CloseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializingTranscoder
extends SpyObject
implements Transcoder<Object> {
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 16384;
    static final int SERIALIZED = 1;
    static final int COMPRESSED = 2;
    private static final int SPECIAL_MASK = 65280;
    static final int SPECIAL_BOOLEAN = 256;
    static final int SPECIAL_INT = 512;
    static final int SPECIAL_LONG = 768;
    static final int SPECIAL_DATE = 1024;
    static final int SPECIAL_BYTE = 1280;
    static final int SPECIAL_FLOAT = 1536;
    static final int SPECIAL_DOUBLE = 1792;
    static final int SPECIAL_BYTEARRAY = 2048;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private int compressionThreshold = 16384;
    private String charset = "UTF-8";

    public void setCompressionThreshold(int to) {
        this.compressionThreshold = to;
    }

    public void setCharset(String to) {
        try {
            new String(new byte[97], to);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.charset = to;
    }

    @Override
    public Object decode(CachedData d) {
        Object rv;
        block15: {
            byte[] data;
            block16: {
                block14: {
                    data = d.getData();
                    rv = null;
                    if ((d.getFlags() & 2) != 0) {
                        data = this.decompress(d.getData());
                    }
                    if ((d.getFlags() & 1) == 0) break block14;
                    rv = this.deserialize(data);
                    break block15;
                }
                if ((d.getFlags() & 0xFF00) == 0) break block16;
                switch (d.getFlags() & 0xFF00) {
                    case 256: {
                        rv = TranscoderUtils.decodeBoolean(data);
                        break block15;
                    }
                    case 512: {
                        rv = new Integer(TranscoderUtils.decodeInt(data));
                        break block15;
                    }
                    case 768: {
                        rv = new Long(TranscoderUtils.decodeLong(data));
                        break block15;
                    }
                    case 1024: {
                        rv = new Date(TranscoderUtils.decodeLong(data));
                        break block15;
                    }
                    case 1280: {
                        rv = new Byte(TranscoderUtils.decodeByte(data));
                        break block15;
                    }
                    case 1536: {
                        rv = new Float(Float.intBitsToFloat(TranscoderUtils.decodeInt(data)));
                        break block15;
                    }
                    case 1792: {
                        rv = new Double(Double.longBitsToDouble(TranscoderUtils.decodeLong(data)));
                        break block15;
                    }
                    case 2048: {
                        rv = data;
                        break block15;
                    }
                    default: {
                        assert (false);
                        break block15;
                    }
                }
            }
            try {
                rv = new String(data, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return rv;
    }

    @Override
    public CachedData encode(Object o) {
        CachedData rv = null;
        byte[] b = null;
        int flags = 0;
        if (o instanceof String) {
            try {
                b = ((String)o).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if (o instanceof Long) {
            b = TranscoderUtils.encodeLong((Long)o);
            flags |= 0x300;
        } else if (o instanceof Integer) {
            b = TranscoderUtils.encodeInt((Integer)o);
            flags |= 0x200;
        } else if (o instanceof Boolean) {
            b = TranscoderUtils.encodeBoolean((Boolean)o);
            flags |= 0x100;
        } else if (o instanceof Date) {
            b = TranscoderUtils.encodeLong(((Date)o).getTime());
            flags |= 0x400;
        } else if (o instanceof Byte) {
            b = TranscoderUtils.encodeByte((Byte)o);
            flags |= 0x500;
        } else if (o instanceof Float) {
            b = TranscoderUtils.encodeInt(Float.floatToRawIntBits(((Float)o).floatValue()));
            flags |= 0x600;
        } else if (o instanceof Double) {
            b = TranscoderUtils.encodeLong(Double.doubleToRawLongBits((Double)o));
            flags |= 0x700;
        } else if (o instanceof byte[]) {
            b = (byte[])o;
            flags |= 0x800;
        } else {
            b = this.serialize(o);
            flags |= 1;
        }
        if (b != null) {
            if (b.length > this.compressionThreshold) {
                byte[] compressed = this.compress(b);
                if (compressed.length < b.length) {
                    this.getLogger().info("Compressed %s from %d to %d", o.getClass().getName(), b.length, compressed.length);
                    b = compressed;
                    flags |= 2;
                } else {
                    this.getLogger().info("Compression increased the size of %s from %d to %d", o.getClass().getName(), b.length, compressed.length);
                }
            }
            rv = new CachedData(flags, b);
        }
        return rv;
    }

    private byte[] serialize(Object o) {
        assert (o != null);
        byte[] rv = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        return rv;
    }

    private Object deserialize(byte[] in) {
        Object rv = null;
        assert (in != null);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            ObjectInputStream is = new ObjectInputStream(bis);
            rv = is.readObject();
            is.close();
            bis.close();
        }
        catch (IOException e) {
            this.getLogger().warn("Caught IOException decoding %d bytes of data", in.length, e);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warn("Caught CNFE decoding %d bytes of data", in.length, e);
        }
        return rv;
    }

    private byte[] compress(byte[] in) {
        assert (in != null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("IO exception compressing data", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(gz);
                CloseUtil.close(bos);
                throw throwable;
            }
        }
        CloseUtil.close(gz);
        CloseUtil.close(bos);
        byte[] rv = bos.toByteArray();
        this.getLogger().debug("Compressed %d bytes to %d", in.length, rv.length);
        return rv;
    }

    private byte[] decompress(byte[] in) {
        assert (in != null);
        ByteArrayInputStream bis = new ByteArrayInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPInputStream gis = new GZIPInputStream(bis);
            byte[] buf = new byte[8192];
            int r = -1;
            while ((r = gis.read(buf)) > 0) {
                bos.write(buf, 0, r);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error decompressing data", e);
        }
        return bos.toByteArray();
    }
}

