/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.MutatatorOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.NoopOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.ops.VersionOperation;
import net.spy.memcached.protocol.binary.DeleteOperationImpl;
import net.spy.memcached.protocol.binary.FlushOperationImpl;
import net.spy.memcached.protocol.binary.GetOperationImpl;
import net.spy.memcached.protocol.binary.MultiGetOperationImpl;
import net.spy.memcached.protocol.binary.MutatorOperationImpl;
import net.spy.memcached.protocol.binary.NoopOperationImpl;
import net.spy.memcached.protocol.binary.StoreOperationImpl;
import net.spy.memcached.protocol.binary.VersionOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperationFactory
implements OperationFactory {
    @Override
    public DeleteOperation delete(String key, int when, OperationCallback operationCallback) {
        return new DeleteOperationImpl(key, when, operationCallback);
    }

    @Override
    public FlushOperation flush(int delay, OperationCallback cb) {
        return new FlushOperationImpl(cb);
    }

    @Override
    public GetOperation get(String key, GetOperation.Callback callback) {
        return new GetOperationImpl(key, callback);
    }

    @Override
    public GetOperation get(Collection<String> value, GetOperation.Callback cb) {
        return new MultiGetOperationImpl(value, cb);
    }

    @Override
    public GetsOperation gets(String key, GetsOperation.Callback cb) {
        return new GetOperationImpl(key, cb);
    }

    @Override
    public MutatatorOperation mutate(Mutator m, String key, int by, long def, int exp, OperationCallback cb) {
        return new MutatorOperationImpl(m, key, by, def, exp, cb);
    }

    @Override
    public StatsOperation stats(String arg, StatsOperation.Callback cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StoreOperation store(StoreType storeType, String key, int flags, int exp, byte[] data, OperationCallback cb) {
        return new StoreOperationImpl(storeType, key, flags, exp, data, cb);
    }

    @Override
    public VersionOperation version(OperationCallback cb) {
        return new VersionOperationImpl(cb);
    }

    @Override
    public NoopOperation noop(OperationCallback cb) {
        return new NoopOperationImpl(cb);
    }

    @Override
    public CASOperation cas(String key, long casId, int flags, byte[] data, OperationCallback cb) {
        return new StoreOperationImpl(StoreType.set, key, flags, 0, data, casId, cb);
    }
}

